/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.compare.ui.queries;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.compare.diff.metamodel.AttributeChange;
import org.eclipse.emf.compare.diff.metamodel.AttributeChangeLeftTarget;
import org.eclipse.emf.compare.diff.metamodel.AttributeChangeRightTarget;
import org.eclipse.emf.compare.diff.metamodel.AttributeOrderChange;
import org.eclipse.emf.compare.diff.metamodel.DiffGroup;
import org.eclipse.emf.compare.diff.metamodel.ModelElementChangeLeftTarget;
import org.eclipse.emf.compare.diff.metamodel.ModelElementChangeRightTarget;
import org.eclipse.emf.compare.diff.metamodel.MoveModelElement;
import org.eclipse.emf.compare.diff.metamodel.ReferenceChangeLeftTarget;
import org.eclipse.emf.compare.diff.metamodel.ReferenceChangeRightTarget;
import org.eclipse.emf.compare.diff.metamodel.ReferenceOrderChange;
import org.eclipse.emf.compare.diff.metamodel.UpdateAttribute;
import org.eclipse.emf.compare.diff.metamodel.UpdateContainmentFeature;
import org.eclipse.emf.compare.diff.metamodel.UpdateModelElement;
import org.eclipse.emf.compare.diff.metamodel.UpdateReference;
import org.eclipse.emf.compare.diff.provider.DiffElementItemProvider;
import org.eclipse.emf.compare.util.AdapterUtils;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.facet.infra.query.core.exception.ModelQueryExecutionException;
import org.eclipse.emf.facet.infra.query.core.java.IJavaModelQuery;
import org.eclipse.emf.facet.infra.query.core.java.ParameterValueList;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.core.sasheditor.editor.IMultiPageEditorPart;
import org.eclipse.papyrus.infra.emf.Activator;
import org.eclipse.papyrus.infra.emf.compare.ui.internal.utils.CustomizationAndViewerActionDispatcher;
import org.eclipse.papyrus.infra.tools.util.EditorHelper;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.builders.NotificationBuilder;
import org.eclipse.ui.IEditorPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetDiffElementLabel
implements IJavaModelQuery<EObject, String> {
    public String evaluate(EObject context, ParameterValueList parameterValues) throws ModelQueryExecutionException {
        AttributeChangeLeftTarget operation;
        LabelProvider labelProvider;
        AdapterFactory adapter = AdapterUtils.getAdapterFactory();
        DiffElementItemProvider itemProvider = new DiffElementItemProvider(adapter);
        IEditorPart editor = EditorHelper.getCurrentEditor();
        if (editor instanceof IMultiPageEditorPart) {
            editor = ((IMultiPageEditorPart)editor).getActiveEditor();
        }
        if (editor == null) {
            return null;
        }
        try {
            labelProvider = CustomizationAndViewerActionDispatcher.getExistingLabelProvider(editor);
        }
        catch (NullPointerException e) {
            return null;
        }
        String diffLabel = null;
        if (context instanceof UpdateAttribute) {
            UpdateAttribute updateOp = (UpdateAttribute)context;
            String attributeLabel = labelProvider.getText((Object)updateOp.getAttribute());
            String elementLabel = labelProvider.getText((Object)updateOp.getLeftElement());
            Object leftValue = updateOp.getLeftElement().eGet((EStructuralFeature)updateOp.getAttribute());
            Object rightValue = updateOp.getRightElement().eGet((EStructuralFeature)updateOp.getAttribute());
            diffLabel = updateOp.isRemote() ? itemProvider.getString("_UI_RemoteUpdateAttribute_type", new Object[]{attributeLabel, elementLabel, leftValue, rightValue}) : (updateOp.isConflicting() ? itemProvider.getString("_UI_UpdateAttribute_conflicting", new Object[]{attributeLabel, rightValue, leftValue}) : itemProvider.getString("_UI_UpdateAttribute_type", new Object[]{attributeLabel, elementLabel, rightValue, leftValue}));
        } else if (context instanceof AttributeOrderChange) {
            AttributeOrderChange attributeOrderChange = (AttributeOrderChange)context;
            diffLabel = itemProvider.getString("_UI_AttributeOrderChange_type", new Object[]{attributeOrderChange.getAttribute().getName()});
        } else if (context instanceof AttributeChangeLeftTarget) {
            operation = (AttributeChangeLeftTarget)context;
            String attributeLabel = labelProvider.getText((Object)operation.getAttribute());
            String elementLabel = labelProvider.getText((Object)operation.getRightElement());
            diffLabel = operation.isRemote() ? itemProvider.getString("_UI_RemoteRemoveAttribute_type", new Object[]{operation.getLeftTarget(), attributeLabel, elementLabel}) : itemProvider.getString("_UI_AddAttribute_type", new Object[]{operation.getLeftTarget(), attributeLabel, elementLabel});
        } else if (context instanceof AttributeChangeRightTarget) {
            operation = (AttributeChangeRightTarget)context;
            String attributeLabel = labelProvider.getText((Object)operation.getAttribute());
            String elementLabel = labelProvider.getText((Object)operation.getLeftElement());
            diffLabel = operation.isRemote() ? itemProvider.getString("_UI_RemoteAddAttribute_type", new Object[]{operation.getRightTarget(), attributeLabel, elementLabel}) : itemProvider.getString("_UI_RemoveAttribute_type", new Object[]{operation.getRightTarget(), attributeLabel, elementLabel});
        } else if (context instanceof AttributeChange) {
            AttributeChange attributeChange = (AttributeChange)context;
            diffLabel = String.valueOf(itemProvider.getString("_UI_AttributeChange_type")) + " " + attributeChange.isConflicting();
        } else if (context instanceof DiffGroup) {
            DiffGroup group = (DiffGroup)context;
            EObject parent = group.getRightParent();
            if (parent != null) {
                String parentLabel = labelProvider.getText((Object)parent);
                diffLabel = itemProvider.getString("_UI_DiffGroup_type", new Object[]{group.getSubchanges(), parentLabel});
            } else {
                diffLabel = itemProvider.getString("_UI_DiffGroup_type", new Object[]{group.getSubchanges(), "model"});
            }
        } else if (context instanceof UpdateContainmentFeature) {
            operation = (UpdateContainmentFeature)context;
            String leftContainmentFeature = operation.getLeftElement().eContainmentFeature().getName();
            String rightContainmentFeature = operation.getRightElement().eContainmentFeature().getName();
            diffLabel = operation.isRemote() ? itemProvider.getString("_UI_RemoteUpdateContainmentFeature_type", new Object[]{rightContainmentFeature, leftContainmentFeature}) : itemProvider.getString("_UI_UpdateContainmentFeature_type", new Object[]{rightContainmentFeature, leftContainmentFeature});
        } else if (context instanceof MoveModelElement) {
            operation = (MoveModelElement)context;
            String elementLabel = labelProvider.getText((Object)operation.getLeftElement());
            String oldParentLabel = labelProvider.getText((Object)operation.getLeftTarget());
            String newParentLabel = labelProvider.getText((Object)operation.getRightTarget());
            diffLabel = operation.isRemote() ? itemProvider.getString("_UI_RemoteMoveModelElement_type", new Object[]{elementLabel, oldParentLabel, newParentLabel}) : (operation.isConflicting() ? itemProvider.getString("_UI_MoveModelElement_conflicting", new Object[]{elementLabel, oldParentLabel, newParentLabel}) : itemProvider.getString("_UI_MoveModelElement_type", new Object[]{elementLabel, oldParentLabel, newParentLabel}));
        } else if (context instanceof UpdateModelElement) {
            UpdateModelElement updateModelElement = (UpdateModelElement)context;
            diffLabel = String.valueOf(itemProvider.getString("_UI_UpdateModelElement_type")) + " " + updateModelElement.isConflicting();
        } else if (context instanceof ModelElementChangeLeftTarget) {
            operation = (ModelElementChangeLeftTarget)context;
            String targetName = labelProvider.getText((Object)operation.getLeftElement());
            diffLabel = operation.isRemote() ? (operation.isConflicting() ? itemProvider.getString("_UI_RemoteRemoveModelElement_conflicting", new Object[]{targetName}) : itemProvider.getString("_UI_RemoteRemoveModelElement_type", new Object[]{targetName})) : itemProvider.getString("_UI_AddModelElement_type", new Object[]{targetName});
        } else if (context instanceof ModelElementChangeRightTarget) {
            operation = (ModelElementChangeRightTarget)context;
            String targetName = labelProvider.getText((Object)operation.getRightElement());
            diffLabel = operation.isRemote() ? itemProvider.getString("_UI_RemoteAddModelElement_type", new Object[]{targetName}) : (operation.isConflicting() ? itemProvider.getString("_UI_RemoveModelElement_conflicting", new Object[]{targetName}) : itemProvider.getString("_UI_RemoveModelElement_type", new Object[]{targetName}));
        } else if (context instanceof UpdateReference) {
            operation = (UpdateReference)context;
            String elementLabel = labelProvider.getText((Object)operation.getLeftElement());
            String referenceLabel = AdapterUtils.getItemProviderText((EObject)operation.getReference());
            String leftValueLabel = labelProvider.getText((Object)this.getLeftValue((UpdateReference)operation));
            String rightValueLabel = labelProvider.getText((Object)this.getRightValue((UpdateReference)operation));
            diffLabel = operation.isRemote() ? itemProvider.getString("_UI_RemoteUpdateReference_type", new Object[]{referenceLabel, elementLabel, leftValueLabel, rightValueLabel}) : (operation.isConflicting() ? itemProvider.getString("_UI_UpdateReference_conflicting", new Object[]{referenceLabel, elementLabel, rightValueLabel, leftValueLabel}) : itemProvider.getString("_UI_UpdateReference_type", new Object[]{referenceLabel, elementLabel, rightValueLabel, leftValueLabel}));
        } else if (context instanceof ReferenceOrderChange) {
            ReferenceOrderChange referenceOrderChange = (ReferenceOrderChange)context;
            diffLabel = itemProvider.getString("_UI_ReferenceOrderChange_type", new Object[]{referenceOrderChange.getReference().getName()});
        } else if (context instanceof ReferenceChangeLeftTarget) {
            operation = (ReferenceChangeLeftTarget)context;
            String valueLabel = labelProvider.getText((Object)operation.getLeftTarget());
            String referenceLabel = labelProvider.getText((Object)operation.getReference());
            String elementLabel = labelProvider.getText((Object)operation.getRightElement());
            diffLabel = operation.isRemote() ? itemProvider.getString("_UI_RemoteRemoveReferenceValue_type", new Object[]{valueLabel, referenceLabel, elementLabel}) : itemProvider.getString("_UI_AddReferenceValue_type", new Object[]{valueLabel, referenceLabel, elementLabel});
        } else if (context instanceof ReferenceChangeRightTarget) {
            operation = (ReferenceChangeRightTarget)context;
            String valueLabel = labelProvider.getText((Object)operation.getRightTarget());
            String referenceLabel = labelProvider.getText((Object)operation.getReference());
            String elementLabel = labelProvider.getText((Object)operation.getLeftElement());
            diffLabel = operation.isRemote() ? itemProvider.getString("_UI_RemoteAddReferenceValue_type", new Object[]{valueLabel, referenceLabel, elementLabel}) : itemProvider.getString("_UI_RemoveReferenceValue_type", new Object[]{valueLabel, referenceLabel, elementLabel});
        }
        if (diffLabel == null) {
            String message = NLS.bind((String)"{0} doesn't manage {1}", (Object[])new Object[]{this.getClass().getSimpleName(), context.getClass().getSimpleName()});
            Activator.log.warn(message);
            NotificationBuilder.createAsyncPopup((String)message).run();
        }
        return diffLabel;
    }

    private EObject getLeftValue(UpdateReference operation) {
        EReference reference = operation.getReference();
        return (EObject)operation.getLeftElement().eGet((EStructuralFeature)reference);
    }

    private EObject getRightValue(UpdateReference operation) {
        EReference reference = operation.getReference();
        return (EObject)operation.getRightElement().eGet((EStructuralFeature)reference);
    }
}

