/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.compare.ui.structural.viewer;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareViewerPane;
import org.eclipse.emf.compare.ui.ModelCompareInput;
import org.eclipse.emf.compare.ui.viewer.structure.ParameterizedStructureContentProvider;
import org.eclipse.emf.compare.ui.viewer.structure.ParameterizedStructureMergeViewer;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.papyrus.infra.emf.compare.ui.actions.CollapseAllAction;
import org.eclipse.papyrus.infra.emf.compare.ui.actions.CustomizationAction;
import org.eclipse.papyrus.infra.emf.compare.ui.actions.ExpandAllAction;
import org.eclipse.papyrus.infra.emf.compare.ui.internal.utils.CustomizationAndViewerActionDispatcher;
import org.eclipse.papyrus.infra.emf.compare.ui.internal.utils.EMFCompareUIUtils;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorPart;

public class PapyrusCustomizableParameterizedStructureMergeViewer
extends ParameterizedStructureMergeViewer {
    private Collection<EPackage> metamodels;
    private LabelProvider labelProvider;
    private final IEditorPart editor;

    public PapyrusCustomizableParameterizedStructureMergeViewer(Composite parent, CompareConfiguration compareConfiguration, IEditorPart editor) {
        super(parent, compareConfiguration);
        this.editor = editor;
        this.setLabelProvider((IBaseLabelProvider)this.createLabelProvider());
    }

    protected void inputChanged(Object input, Object oldInput) {
        if (input instanceof ModelCompareInput) {
            this.metamodels = EMFCompareUIUtils.getMetamodelForCustomization(input, this.metamodels);
        }
        super.inputChanged(input, oldInput);
    }

    protected void createToolItems() {
        ToolBarManager tbm = CompareViewerPane.getToolBarManager((Composite)this.getControl().getParent());
        tbm.removeAll();
        super.createToolItems();
        if (this.metamodels == null) {
            this.metamodels = new HashSet<EPackage>();
        }
        ExpandAllAction expandAllAction = new ExpandAllAction((TreeViewer)this);
        ActionContributionItem expandAllContributionItem = new ActionContributionItem((IAction)expandAllAction);
        tbm.insert(0, (IContributionItem)expandAllContributionItem);
        CollapseAllAction collapseAllAction = new CollapseAllAction((TreeViewer)this);
        ActionContributionItem collapseAllActionContributionItem = new ActionContributionItem((IAction)collapseAllAction);
        tbm.insert(1, (IContributionItem)collapseAllActionContributionItem);
        tbm.insert(2, (IContributionItem)new Separator("treeAction"));
        CustomizationAction customizationAction = new CustomizationAction(Collections.unmodifiableCollection(this.metamodels));
        ActionContributionItem customizationContributionItem = new ActionContributionItem((IAction)customizationAction);
        tbm.insert(3, (IContributionItem)customizationContributionItem);
        tbm.update(true);
    }

    protected void handleDispose(DisposeEvent event) {
        this.metamodels.clear();
        CustomizationAndViewerActionDispatcher.dissociateTreeViewerAndLabelProvider((TreeViewer)this, this.labelProvider);
        super.handleDispose(event);
    }

    protected LabelProvider createLabelProvider() {
        this.labelProvider = CustomizationAndViewerActionDispatcher.getLabelProvider(this.editor);
        return this.labelProvider;
    }

    protected ParameterizedStructureContentProvider buildContentProvider(CompareConfiguration compareConfiguration) {
        ParameterizedStructureContentProvider contentProvider = new ParameterizedStructureContentProvider(compareConfiguration, this.getDefaultOrdering(), this.getDefaultFilters()){

            public boolean hasChildren(Object element) {
                return super.getChildren(element).length != 0;
            }
        };
        return contentProvider;
    }
}

