/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.compare.ui.utils;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.facet.infra.browser.custom.MetamodelView;
import org.eclipse.emf.facet.infra.browser.custom.core.CustomizationsCatalog;
import org.eclipse.emf.facet.infra.browser.uicore.CustomizationManager;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.emf.compare.ui.Activator;
import org.eclipse.papyrus.infra.emf.compare.ui.messages.Messages;
import org.eclipse.papyrus.infra.emf.compare.ui.provider.EMFCompareLabelProvider;

public class LabelProviderUtil {
    private static Collection<String> wantedCustomName;

    private LabelProviderUtil() {
    }

    public static final EMFCompareLabelProvider createLabelProvider() {
        CustomizationManager customizationManager = new CustomizationManager();
        LabelProviderUtil.init(customizationManager);
        return new EMFCompareLabelProvider(customizationManager);
    }

    private static void init(CustomizationManager customizationManager) {
        if (wantedCustomName == null) {
            wantedCustomName = new ArrayList<String>();
            wantedCustomName.add("uml_compare_diff");
            wantedCustomName.add("uml_emf_compare_diff");
            wantedCustomName.add("compare_diff");
            wantedCustomName.add("UMLPapyrusDefaultBrowserCustomization");
        }
        customizationManager.setShowDerivedLinks(true);
        try {
            ArrayList<MetamodelView> wantedCustom = new ArrayList<MetamodelView>();
            for (String current : wantedCustomName) {
                MetamodelView custom = CustomizationsCatalog.getInstance().getCustomization(current);
                if (custom != null) {
                    wantedCustom.add(custom);
                    continue;
                }
                Activator.log.warn(NLS.bind((String)Messages.LabelProviderUtil_CustomizationNotFound, (Object)current));
            }
            for (MetamodelView metamodelView : wantedCustom) {
                customizationManager.registerCustomization(metamodelView);
            }
            customizationManager.loadCustomizations();
        }
        catch (Throwable e) {
            Activator.log.error(e);
        }
    }
}

