/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.css.configuration.handler;

import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.papyrus.infra.gmfdiag.css.Attribute;
import org.eclipse.papyrus.infra.gmfdiag.css.AttributeValue;
import org.eclipse.papyrus.infra.gmfdiag.css.Declaration;
import org.eclipse.papyrus.infra.gmfdiag.css.Expression;
import org.eclipse.papyrus.infra.gmfdiag.css.HexColor;
import org.eclipse.papyrus.infra.gmfdiag.css.Name;
import org.eclipse.papyrus.infra.gmfdiag.css.Number;
import org.eclipse.papyrus.infra.gmfdiag.css.SelectorCondition;
import org.eclipse.papyrus.infra.gmfdiag.css.StringValue;
import org.eclipse.papyrus.infra.gmfdiag.css.Subterm;
import org.eclipse.papyrus.infra.gmfdiag.css.Term;
import org.eclipse.papyrus.infra.gmfdiag.css.configuration.helper.DiagramTypeHelper;
import org.eclipse.papyrus.infra.gmfdiag.css.util.CssSwitch;
import org.eclipse.papyrus.infra.widgets.Activator;
import org.eclipse.papyrus.infra.widgets.editors.AbstractEditor;
import org.eclipse.papyrus.infra.widgets.editors.BooleanCheckbox;
import org.eclipse.papyrus.infra.widgets.editors.EnumRadio;
import org.eclipse.papyrus.infra.widgets.editors.ICommitListener;
import org.eclipse.papyrus.infra.widgets.editors.StringEditor;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.StaticContentProvider;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractStyleDialog
extends TrayDialog {
    protected final Map<Attribute, Boolean> conditions;
    protected final Map<Declaration, Boolean> declarations;
    protected final String selectorName;
    protected boolean useSelectorName = true;
    protected boolean diagramRestriction = false;
    protected String cssClass;
    protected View contextView;
    protected CLabel errorLabel;
    protected StringEditor selectorPreview;
    protected CTabFolder tabFolder;
    protected Composite conditionsContainer;
    protected Composite declarationsContainer;

    public AbstractStyleDialog(Shell shell, Map<Attribute, Boolean> conditions, Map<Declaration, Boolean> declarations, String selectorName, View context) {
        super(shell);
        this.conditions = conditions;
        this.declarations = declarations;
        this.selectorName = selectorName;
        this.contextView = context;
    }

    public void create() {
        super.create();
        Composite parent = this.getDialogArea();
        this.selectorPreview = new StringEditor(parent, 0);
        this.selectorPreview.setReadOnly(true);
        this.selectorPreview.setLabel("Selector preview:");
        this.selectorPreview.setLayoutData((Object)new GridData(4, 1, true, false));
        GridLayout layout = (GridLayout)this.selectorPreview.getLayout();
        layout.marginWidth = 0;
        this.tabFolder = new CTabFolder(parent, 2048);
        this.tabFolder.setLayoutData((Object)new GridData(4, 4, true, true));
        CTabItem conditionsTab = new CTabItem(this.tabFolder, 0);
        CTabItem declarationsTab = new CTabItem(this.tabFolder, 0);
        conditionsTab.setText("Conditions");
        declarationsTab.setText("Properties");
        this.conditionsContainer = new Composite((Composite)this.tabFolder, 0);
        this.conditionsContainer.setLayoutData((Object)new GridData(1, 1, true, true));
        this.conditionsContainer.setBackground(parent.getDisplay().getSystemColor(1));
        this.conditionsContainer.setBackgroundMode(1);
        conditionsTab.setControl((Control)this.conditionsContainer);
        this.declarationsContainer = new Composite((Composite)this.tabFolder, 0);
        this.declarationsContainer.setLayoutData((Object)new GridData(1, 1, true, true));
        this.declarationsContainer.setBackground(parent.getDisplay().getSystemColor(1));
        this.declarationsContainer.setBackgroundMode(1);
        declarationsTab.setControl((Control)this.declarationsContainer);
        this.createConditions(this.conditionsContainer);
        this.createDeclarations(this.declarationsContainer);
        this.updateSelectorLabel();
        this.updateButtons();
        this.tabFolder.setSelection(conditionsTab);
        this.getShell().pack();
    }

    protected void updateButtons() {
        this.setError(null);
        this.getButton(0).setEnabled(this.isValid());
        this.getDialogArea().layout();
    }

    protected boolean isValid() {
        boolean result = true;
        boolean atLeastOneDeclaration = false;
        for (Boolean value : this.declarations.values()) {
            if (!value.booleanValue()) continue;
            atLeastOneDeclaration = true;
            break;
        }
        boolean bl = result = result && atLeastOneDeclaration;
        if (!atLeastOneDeclaration) {
            this.setError("There must be at least one property declaration");
        }
        return result;
    }

    protected void setError(String errorMessage) {
        if (errorMessage == null && this.errorLabel != null) {
            this.errorLabel.dispose();
            this.errorLabel = null;
            return;
        }
        if (errorMessage != null) {
            if (this.errorLabel == null) {
                this.errorLabel = new CLabel(this.getDialogArea(), 64);
                this.errorLabel.setLayoutData((Object)new GridData(4, 1, true, false));
                this.errorLabel.setImage(Activator.getDefault().getImage("icons/error.gif"));
            }
            if (this.errorLabel.getText() != null && !this.errorLabel.getText().trim().equals("")) {
                this.errorLabel.setText(String.valueOf(this.errorLabel.getText()) + "\n" + errorMessage);
            } else {
                this.errorLabel.setText(errorMessage);
            }
        }
    }

    protected void createConditions(Composite parent) {
        parent.setLayout((Layout)new GridLayout(3, false));
        Label conditionsLabel = new Label(parent, 64);
        conditionsLabel.setText("Select the condition(s) under which the style will be applied.");
        conditionsLabel.setLayoutData((Object)new GridData(4, 1, true, false, 3, 1));
        this.createElementNameSection(parent);
        this.createAttributeSelectorsSection(parent);
        this.createStyleNameSection(parent);
    }

    protected void createElementNameSection(Composite parent) {
        EnumRadio diagramRestrictionWidget = new EnumRadio(parent, 0, "Diagram:");
        diagramRestrictionWidget.setLayoutData((Object)new GridData(4, 1, true, false, 3, 1));
        LabelProvider labelProvider = new LabelProvider(){

            public String getText(Object element) {
                Boolean value = (Boolean)element;
                return value != false ? String.valueOf(DiagramTypeHelper.getDiagramType(AbstractStyleDialog.this.contextView.getDiagram())) + " only" : "Any diagram";
            }
        };
        diagramRestrictionWidget.setProviders((IStaticContentProvider)new StaticContentProvider((Object[])new Boolean[]{true, false}), (ILabelProvider)labelProvider);
        diagramRestrictionWidget.setValue((Object)this.diagramRestriction);
        diagramRestrictionWidget.addCommitListener(new ICommitListener(){

            public void commit(AbstractEditor editor) {
                AbstractStyleDialog.this.diagramRestriction = (Boolean)((EnumRadio)editor).getValue();
                AbstractStyleDialog.this.updateSelectorLabel();
            }
        });
        EnumRadio selectorNameWidget = new EnumRadio(parent, 0, "Applies to:");
        selectorNameWidget.setLayoutData((Object)new GridData(4, 1, true, false, 3, 1));
        labelProvider = new LabelProvider(){

            public String getText(Object element) {
                Boolean value = (Boolean)element;
                return value != false ? String.valueOf(AbstractStyleDialog.this.selectorName) + " only" : "Any kind of element";
            }
        };
        selectorNameWidget.setProviders((IStaticContentProvider)new StaticContentProvider((Object[])new Boolean[]{true, false}), (ILabelProvider)labelProvider);
        selectorNameWidget.setValue((Object)this.useSelectorName);
        selectorNameWidget.addCommitListener(new ICommitListener(){

            public void commit(AbstractEditor editor) {
                AbstractStyleDialog.this.useSelectorName = (Boolean)((EnumRadio)editor).getValue();
                AbstractStyleDialog.this.updateSelectorLabel();
            }
        });
    }

    protected void createAttributeSelectorsSection(Composite parent) {
        if (this.conditions.isEmpty()) {
            return;
        }
        Label detailLabel = new Label(parent, 0);
        detailLabel.setText("If the following properties are matched:");
        detailLabel.setLayoutData((Object)new GridData(4, 1, true, false, 3, 1));
        for (SelectorCondition selectorCondition : this.conditions.keySet()) {
            final Attribute currentCondition = (Attribute)selectorCondition;
            String attributeLabel = currentCondition.getName();
            if (currentCondition.getValue() != null) {
                attributeLabel = String.valueOf(attributeLabel) + " " + currentCondition.getValue().getOperator() + " " + currentCondition.getValue().getValue();
            }
            BooleanCheckbox checkbox = new BooleanCheckbox(parent, 0, attributeLabel);
            checkbox.setValue(this.conditions.get(currentCondition));
            checkbox.addCommitListener(new ICommitListener(){

                public void commit(AbstractEditor editor) {
                    AbstractStyleDialog.this.conditions.put(currentCondition, ((BooleanCheckbox)editor).getValue());
                    AbstractStyleDialog.this.updateSelectorLabel();
                }
            });
        }
    }

    protected void createStyleNameSection(Composite parent) {
        Label styleNameLabel = new Label(parent, 64);
        String label = "If a name is used for this style, it will have to be applied manually:";
        styleNameLabel.setText(label);
        styleNameLabel.setLayoutData((Object)new GridData(4, 1, true, false, 3, 1));
        StringEditor styleNameEditor = new StringEditor(parent, 0, "Style name:");
        styleNameEditor.setLayoutData((Object)new GridData(4, 1, true, false, 3, 1));
        styleNameEditor.setValue((Object)this.cssClass);
        styleNameEditor.addCommitListener(new ICommitListener(){

            public void commit(AbstractEditor editor) {
                AbstractStyleDialog.this.cssClass = (String)((StringEditor)editor).getValue();
                AbstractStyleDialog.this.updateSelectorLabel();
            }
        });
    }

    protected void createDeclarations(Composite parent) {
        parent.setLayout((Layout)new GridLayout(3, false));
        Label declarationsLabel = new Label(parent, 64);
        declarationsLabel.setText("Select the properties you want to set. Unchecked properties will keep their default value\n (Which might be inherited from another style).");
        declarationsLabel.setLayoutData((Object)new GridData(4, 1, true, false, 3, 1));
        for (Declaration declaration : this.declarations.keySet()) {
            String label = String.valueOf(declaration.getProperty()) + ": " + this.getLabel(declaration.getExpression());
            BooleanCheckbox checkbox = new BooleanCheckbox(parent, 0, label);
            final Declaration currentDeclaration = declaration;
            checkbox.setValue(this.declarations.get(currentDeclaration));
            checkbox.addCommitListener(new ICommitListener(){

                public void commit(AbstractEditor editor) {
                    boolean value = ((BooleanCheckbox)editor).getValue();
                    AbstractStyleDialog.this.declarations.put(currentDeclaration, value);
                    AbstractStyleDialog.this.updateButtons();
                }
            });
            checkbox.setValue(this.declarations.get(declaration));
        }
    }

    public String getCSSClass() {
        if (this.cssClass != null) {
            return this.cssClass.trim().equals("") ? null : this.cssClass.trim();
        }
        return null;
    }

    protected String getLabel(Expression expression) {
        if (expression == null) {
            return "";
        }
        String label = this.getLabel(expression.getTerms());
        for (Subterm subTerm : expression.getSubterms()) {
            if (subTerm.getOperator() != null) {
                label = String.valueOf(label) + subTerm.getOperator();
            }
            label = String.valueOf(label) + " " + this.getLabel(subTerm.getTerm());
        }
        return label;
    }

    protected String getLabel(Term term) {
        return (String)new CssSwitch<String>(){

            public String caseHexColor(HexColor term) {
                return String.valueOf('#') + term.getValue();
            }

            public String caseName(Name term) {
                return term.getValue();
            }

            public String caseStringValue(StringValue term) {
                return "\"" + term.getValue() + "\"";
            }

            public String caseNumber(Number term) {
                String label = "";
                if (term.getOp() != null) {
                    label = String.valueOf(label) + term.getOp().getOperator();
                }
                label = String.valueOf(label) + term.getValue();
                return label;
            }
        }.doSwitch((EObject)term);
    }

    protected void updateSelectorLabel() {
        String selectorText = "";
        if (this.diagramRestriction) {
            selectorText = String.valueOf(selectorText) + DiagramTypeHelper.getDiagramType(this.contextView.getDiagram()) + " ";
        }
        selectorText = String.valueOf(selectorText) + (this.useSelectorName ? this.selectorName : "*");
        for (Map.Entry<Attribute, Boolean> selectorEntry : this.conditions.entrySet()) {
            Attribute condition;
            if (!selectorEntry.getValue().booleanValue()) continue;
            Attribute attribute = condition = selectorEntry.getKey();
            AttributeValue value = attribute.getValue();
            selectorText = String.valueOf(selectorText) + "[" + attribute.getName() + value.getOperator() + value.getValue() + "]";
        }
        if (this.cssClass != null && !"".equals(this.cssClass)) {
            selectorText = String.valueOf(selectorText) + "." + this.cssClass;
        }
        this.selectorPreview.setValue((Object)selectorText);
        this.getDialogArea().layout();
    }

    protected boolean isResizable() {
        return true;
    }

    public Composite getDialogArea() {
        return (Composite)super.getDialogArea();
    }

    public boolean useSelectorName() {
        return this.useSelectorName;
    }

    public boolean getDiagramRestriction() {
        return this.diagramRestriction;
    }
}

