/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.css.configuration.handler;

import java.util.List;
import java.util.Map;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.papyrus.infra.gmfdiag.css.Attribute;
import org.eclipse.papyrus.infra.gmfdiag.css.Class;
import org.eclipse.papyrus.infra.gmfdiag.css.CompositeSelector;
import org.eclipse.papyrus.infra.gmfdiag.css.CssPackage;
import org.eclipse.papyrus.infra.gmfdiag.css.Declaration;
import org.eclipse.papyrus.infra.gmfdiag.css.Ruleset;
import org.eclipse.papyrus.infra.gmfdiag.css.Selector;
import org.eclipse.papyrus.infra.gmfdiag.css.SelectorCondition;
import org.eclipse.papyrus.infra.gmfdiag.css.SimpleSelector;
import org.eclipse.papyrus.infra.gmfdiag.css.Stylesheet;
import org.eclipse.papyrus.infra.gmfdiag.css.configuration.handler.AbstractStyleDialog;
import org.eclipse.papyrus.infra.gmfdiag.css.configuration.helper.DiagramTypeHelper;
import org.eclipse.papyrus.infra.gmfdiag.css.configuration.providers.ExistingStyleContentProvider;
import org.eclipse.papyrus.infra.gmfdiag.css.configuration.providers.StylesheetLabelProvider;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StyleEditionDialog
extends AbstractStyleDialog
implements ISelectionChangedListener {
    protected Composite styleSelectionPanel;
    protected Composite styleEditionPanel;
    protected Ruleset ruleset;

    public StyleEditionDialog(Shell shell, Map<Attribute, Boolean> conditions, Map<Declaration, Boolean> declarations, String selectorName, View context) {
        super(shell, conditions, declarations, selectorName, context);
    }

    @Override
    public void create() {
        super.create();
        this.createStyleSelectionPanel();
        this.getShell().setText("Edit an existing style");
    }

    public Composite createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        SashForm sash = new SashForm(dialogArea, 256);
        sash.setLayoutData((Object)new GridData(4, 4, true, true));
        this.styleSelectionPanel = new Composite((Composite)sash, 0);
        GridData data = new GridData(1, 4, false, true);
        data.widthHint = 250;
        this.styleSelectionPanel.setLayoutData((Object)data);
        this.styleSelectionPanel.setLayout((Layout)new GridLayout(1, true));
        this.styleEditionPanel = new Composite((Composite)sash, 0);
        this.styleEditionPanel.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(1, true);
        this.styleEditionPanel.setLayout((Layout)layout);
        sash.setWeights(new int[]{2, 5});
        return this.styleEditionPanel;
    }

    protected void createStyleSelectionPanel() {
        TreeViewer viewer = new TreeViewer(this.styleSelectionPanel, 2048);
        viewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        viewer.setContentProvider((IContentProvider)new ExistingStyleContentProvider(this.contextView));
        viewer.setLabelProvider((IBaseLabelProvider)new StylesheetLabelProvider());
        viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        viewer.setInput(new Object());
        this.styleSelectionPanel.layout();
        this.styleSelectionPanel.getParent().layout();
    }

    protected Stylesheet getStylesheet() {
        if (this.ruleset != null) {
            return (Stylesheet)this.ruleset.eContainer();
        }
        return null;
    }

    public Ruleset getSelectedRuleset() {
        return this.ruleset;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        selection.isEmpty();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection sSelection = (IStructuredSelection)selection;
            Object selectedElement = sSelection.getFirstElement();
            if (selectedElement instanceof Ruleset) {
                this.handleSelectionChanged((Ruleset)selectedElement);
            } else {
                this.ruleset = null;
            }
        }
        this.updateButtons();
    }

    protected void handleSelectionChanged(Ruleset selectedRuleset) {
        this.ruleset = selectedRuleset;
        for (Attribute attribute : this.conditions.keySet()) {
            this.conditions.put(attribute, false);
        }
        for (Declaration declaration : this.declarations.keySet()) {
            this.declarations.put(declaration, false);
        }
        this.diagramRestriction = false;
        this.useSelectorName = false;
        this.cssClass = null;
        for (Selector selector : selectedRuleset.getSelectors()) {
            this.handleSelector(selector);
        }
        this.handleDeclarations((List<Declaration>)selectedRuleset.getProperties());
        this.updateContents();
        this.updateSelectorLabel();
    }

    protected void handleDeclarations(List<Declaration> declarations) {
        block0: for (Declaration declaration : declarations) {
            for (Declaration currentDeclaration : this.declarations.keySet()) {
                if (!currentDeclaration.getProperty().equals(declaration.getProperty())) continue;
                this.declarations.put(currentDeclaration, true);
                continue block0;
            }
        }
    }

    protected void handleSelector(Selector selector) {
        if (selector instanceof SimpleSelector) {
            this.handleSelector((SimpleSelector)selector);
        } else if (selector instanceof CompositeSelector) {
            this.handleSelector((CompositeSelector)selector);
        }
    }

    protected void handleSelector(SimpleSelector selector) {
        if (DiagramTypeHelper.getDiagramType(this.contextView.getDiagram()).equals(selector.getElementName())) {
            this.diagramRestriction = true;
        }
        if (this.contextView.getElement().eClass().getName().equals(selector.getElementName())) {
            this.useSelectorName = true;
        }
        block0: for (SelectorCondition condition : selector.getCondition()) {
            if (condition instanceof Attribute) {
                Attribute existingAttribute = (Attribute)condition;
                for (Attribute selectedAttribute : this.conditions.keySet()) {
                    if (!existingAttribute.getName().equals(selectedAttribute.getName())) continue;
                    this.conditions.put(selectedAttribute, true);
                    continue block0;
                }
                continue;
            }
            if (condition.eClass() != CssPackage.eINSTANCE.getClass_()) continue;
            this.cssClass = ((Class)condition).getClass_();
        }
    }

    protected void updateContents() {
        this.disposeContents(this.conditionsContainer);
        this.createConditions(this.conditionsContainer);
        this.disposeContents(this.declarationsContainer);
        this.createDeclarations(this.declarationsContainer);
        this.conditionsContainer.layout();
        this.declarationsContainer.layout();
        this.tabFolder.layout();
        this.getDialogArea().layout();
    }

    protected void disposeContents(Composite composite) {
        Control[] controlArray = composite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.dispose();
            ++n2;
        }
    }

    protected void handleSelector(CompositeSelector selector) {
        this.handleSelector(selector.getLeft());
        this.handleSelector(selector.getRight());
    }

    @Override
    protected boolean isValid() {
        boolean result = true;
        if (this.ruleset == null) {
            this.setError("You must select an existing Style");
            result = false;
        }
        return super.isValid() && result;
    }
}

