/*****************************************************************************
 * Copyright (c) 2012 CEA LIST.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *  Camille Letavernier (CEA LIST) camille.letavernier@cea.fr - Initial API and implementation
 *****************************************************************************/
package org.eclipse.papyrus.infra.gmfdiag.css.handler;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.papyrus.infra.gmfdiag.common.handler.RefreshHandler;
import org.eclipse.papyrus.infra.gmfdiag.css.engine.BaseCSSEngine;

/**
 * A Handler for refreshing a single Papyrus Diagram
 * It will refresh the CSS Stylesheets before refreshing the diagram.
 * 
 * @author Camille Letavernier
 * 
 */
public class CSSRefreshHandler extends RefreshHandler {

	@Override
	public Object execute(ExecutionEvent event) throws ExecutionException {
		BaseCSSEngine.instance.reset();
		return super.execute(event);
	}
}
