/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.serializer;

import com.google.inject.Inject;
import com.google.inject.Provider;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.papyrus.infra.gmfdiag.css.Angle;
import org.eclipse.papyrus.infra.gmfdiag.css.Attribute;
import org.eclipse.papyrus.infra.gmfdiag.css.AttributeValue;
import org.eclipse.papyrus.infra.gmfdiag.css.CSSId;
import org.eclipse.papyrus.infra.gmfdiag.css.Class;
import org.eclipse.papyrus.infra.gmfdiag.css.Combinator;
import org.eclipse.papyrus.infra.gmfdiag.css.CompositeSelector;
import org.eclipse.papyrus.infra.gmfdiag.css.CssPackage;
import org.eclipse.papyrus.infra.gmfdiag.css.Declaration;
import org.eclipse.papyrus.infra.gmfdiag.css.Ems;
import org.eclipse.papyrus.infra.gmfdiag.css.Expression;
import org.eclipse.papyrus.infra.gmfdiag.css.Exs;
import org.eclipse.papyrus.infra.gmfdiag.css.Frequency;
import org.eclipse.papyrus.infra.gmfdiag.css.Function;
import org.eclipse.papyrus.infra.gmfdiag.css.HexColor;
import org.eclipse.papyrus.infra.gmfdiag.css.Import;
import org.eclipse.papyrus.infra.gmfdiag.css.Length;
import org.eclipse.papyrus.infra.gmfdiag.css.Media;
import org.eclipse.papyrus.infra.gmfdiag.css.Name;
import org.eclipse.papyrus.infra.gmfdiag.css.Number;
import org.eclipse.papyrus.infra.gmfdiag.css.Page;
import org.eclipse.papyrus.infra.gmfdiag.css.Percentage;
import org.eclipse.papyrus.infra.gmfdiag.css.Pseudo;
import org.eclipse.papyrus.infra.gmfdiag.css.PseudoPage;
import org.eclipse.papyrus.infra.gmfdiag.css.Ruleset;
import org.eclipse.papyrus.infra.gmfdiag.css.SimpleSelector;
import org.eclipse.papyrus.infra.gmfdiag.css.StringValue;
import org.eclipse.papyrus.infra.gmfdiag.css.Stylesheet;
import org.eclipse.papyrus.infra.gmfdiag.css.Subterm;
import org.eclipse.papyrus.infra.gmfdiag.css.Time;
import org.eclipse.papyrus.infra.gmfdiag.css.UnaryOperator;
import org.eclipse.papyrus.infra.gmfdiag.css.Uri;
import org.eclipse.papyrus.infra.gmfdiag.services.CSSGrammarAccess;
import org.eclipse.xtext.serializer.acceptor.ISemanticSequenceAcceptor;
import org.eclipse.xtext.serializer.acceptor.SequenceFeeder;
import org.eclipse.xtext.serializer.diagnostic.ISemanticSequencerDiagnosticProvider;
import org.eclipse.xtext.serializer.diagnostic.ISerializationDiagnostic;
import org.eclipse.xtext.serializer.sequencer.AbstractSemanticSequencer;
import org.eclipse.xtext.serializer.sequencer.GenericSequencer;
import org.eclipse.xtext.serializer.sequencer.ISemanticNodeProvider;
import org.eclipse.xtext.serializer.sequencer.ISemanticSequencer;
import org.eclipse.xtext.serializer.sequencer.ITransientValueService;

public class AbstractCSSSemanticSequencer
extends AbstractSemanticSequencer {
    @Inject
    protected CSSGrammarAccess grammarAccess;
    @Inject
    protected ISemanticSequencerDiagnosticProvider diagnosticProvider;
    @Inject
    protected ITransientValueService transientValues;
    @Inject
    @GenericSequencer
    protected Provider<ISemanticSequencer> genericSequencerProvider;
    protected ISemanticSequencer genericSequencer;

    public void init(ISemanticSequencer sequencer, ISemanticSequenceAcceptor sequenceAcceptor, ISerializationDiagnostic.Acceptor errorAcceptor) {
        super.init(sequencer, sequenceAcceptor, errorAcceptor);
        this.genericSequencer = (ISemanticSequencer)this.genericSequencerProvider.get();
        this.genericSequencer.init(sequencer, sequenceAcceptor, errorAcceptor);
    }

    public void createSequence(EObject context, EObject semanticObject) {
        if (semanticObject.eClass().getEPackage() == CssPackage.eINSTANCE) {
            switch (semanticObject.eClass().getClassifierID()) {
                case 23: {
                    if (context != this.grammarAccess.getAngleRule() && context != this.grammarAccess.getTermRule()) break;
                    this.sequence_Angle(context, (Angle)semanticObject);
                    return;
                }
                case 30: {
                    if (context != this.grammarAccess.getAttributeRule() && context != this.grammarAccess.getSelectorConditionRule()) break;
                    this.sequence_Attribute(context, (Attribute)semanticObject);
                    return;
                }
                case 31: {
                    if (context != this.grammarAccess.getAttributeValueRule()) break;
                    this.sequence_AttributeValue(context, (AttributeValue)semanticObject);
                    return;
                }
                case 33: {
                    if (context != this.grammarAccess.getCSSIdRule() && context != this.grammarAccess.getSelectorConditionRule()) break;
                    this.sequence_CSSId(context, (CSSId)semanticObject);
                    return;
                }
                case 29: {
                    if (context != this.grammarAccess.getClassRule() && context != this.grammarAccess.getSelectorConditionRule()) break;
                    this.sequence_Class(context, (Class)semanticObject);
                    return;
                }
                case 11: {
                    if (context != this.grammarAccess.getCombinatorRule()) break;
                    this.sequence_Combinator(context, (Combinator)semanticObject);
                    return;
                }
                case 8: {
                    if (context != this.grammarAccess.getCompositeSelectorRule() && context != this.grammarAccess.getSelectorRule()) break;
                    this.sequence_CompositeSelector(context, (CompositeSelector)semanticObject);
                    return;
                }
                case 12: {
                    if (context != this.grammarAccess.getDeclarationRule()) break;
                    this.sequence_Declaration(context, (Declaration)semanticObject);
                    return;
                }
                case 21: {
                    if (context != this.grammarAccess.getEmsRule() && context != this.grammarAccess.getTermRule()) break;
                    this.sequence_Ems(context, (Ems)semanticObject);
                    return;
                }
                case 13: {
                    if (context != this.grammarAccess.getExpressionRule()) break;
                    this.sequence_Expression(context, (Expression)semanticObject);
                    return;
                }
                case 22: {
                    if (context != this.grammarAccess.getExsRule() && context != this.grammarAccess.getTermRule()) break;
                    this.sequence_Exs(context, (Exs)semanticObject);
                    return;
                }
                case 25: {
                    if (context != this.grammarAccess.getFrequencyRule() && context != this.grammarAccess.getTermRule()) break;
                    this.sequence_Frequency(context, (Frequency)semanticObject);
                    return;
                }
                case 16: {
                    if (context != this.grammarAccess.getFunctionRule() && context != this.grammarAccess.getTermRule()) break;
                    this.sequence_Function(context, (Function)semanticObject);
                    return;
                }
                case 28: {
                    if (context != this.grammarAccess.getHexColorRule() && context != this.grammarAccess.getTermRule()) break;
                    this.sequence_HexColor(context, (HexColor)semanticObject);
                    return;
                }
                case 2: {
                    if (context != this.grammarAccess.getImportRule()) break;
                    this.sequence_Import(context, (Import)semanticObject);
                    return;
                }
                case 20: {
                    if (context != this.grammarAccess.getLengthRule() && context != this.grammarAccess.getTermRule()) break;
                    this.sequence_Length(context, (Length)semanticObject);
                    return;
                }
                case 3: {
                    if (context != this.grammarAccess.getContentRule() && context != this.grammarAccess.getMediaRule()) break;
                    this.sequence_Media(context, (Media)semanticObject);
                    return;
                }
                case 17: {
                    if (context != this.grammarAccess.getNameRule() && context != this.grammarAccess.getTermRule()) break;
                    this.sequence_Name(context, (Name)semanticObject);
                    return;
                }
                case 18: {
                    if (context != this.grammarAccess.getNumberRule() && context != this.grammarAccess.getTermRule()) break;
                    this.sequence_Number(context, (Number)semanticObject);
                    return;
                }
                case 4: {
                    if (context != this.grammarAccess.getContentRule() && context != this.grammarAccess.getPageRule()) break;
                    this.sequence_Page(context, (Page)semanticObject);
                    return;
                }
                case 19: {
                    if (context != this.grammarAccess.getPercentageRule() && context != this.grammarAccess.getTermRule()) break;
                    this.sequence_Percentage(context, (Percentage)semanticObject);
                    return;
                }
                case 32: {
                    if (context != this.grammarAccess.getPseudoRule() && context != this.grammarAccess.getSelectorConditionRule()) break;
                    this.sequence_Pseudo(context, (Pseudo)semanticObject);
                    return;
                }
                case 5: {
                    if (context != this.grammarAccess.getPseudoPageRule()) break;
                    this.sequence_PseudoPage(context, (PseudoPage)semanticObject);
                    return;
                }
                case 6: {
                    if (context != this.grammarAccess.getContentRule() && context != this.grammarAccess.getRulesetRule()) break;
                    this.sequence_Ruleset(context, (Ruleset)semanticObject);
                    return;
                }
                case 9: {
                    if (context != this.grammarAccess.getSelectorRule() && context != this.grammarAccess.getSimpleSelectorRule()) break;
                    this.sequence_SimpleSelector(context, (SimpleSelector)semanticObject);
                    return;
                }
                case 27: {
                    if (context != this.grammarAccess.getStringValueRule() && context != this.grammarAccess.getTermRule()) break;
                    this.sequence_StringValue(context, (StringValue)semanticObject);
                    return;
                }
                case 0: {
                    if (context != this.grammarAccess.getStylesheetRule()) break;
                    this.sequence_Stylesheet(context, (Stylesheet)semanticObject);
                    return;
                }
                case 14: {
                    if (context != this.grammarAccess.getSubtermRule()) break;
                    this.sequence_Subterm(context, (Subterm)semanticObject);
                    return;
                }
                case 24: {
                    if (context != this.grammarAccess.getTermRule() && context != this.grammarAccess.getTimeRule()) break;
                    this.sequence_Time(context, (Time)semanticObject);
                    return;
                }
                case 34: {
                    if (context != this.grammarAccess.getUnaryOperatorRule()) break;
                    this.sequence_UnaryOperator(context, (UnaryOperator)semanticObject);
                    return;
                }
                case 26: {
                    if (context != this.grammarAccess.getTermRule() && context != this.grammarAccess.getUriRule()) break;
                    this.sequence_Uri(context, (Uri)semanticObject);
                    return;
                }
            }
        }
        if (this.errorAcceptor != null) {
            this.errorAcceptor.accept(this.diagnosticProvider.createInvalidContextOrTypeDiagnostic(semanticObject, context));
        }
    }

    protected void sequence_Angle(EObject context, Angle semanticObject) {
        this.genericSequencer.createSequence(context, (EObject)semanticObject);
    }

    protected void sequence_AttributeValue(EObject context, AttributeValue semanticObject) {
        this.genericSequencer.createSequence(context, (EObject)semanticObject);
    }

    protected void sequence_Attribute(EObject context, Attribute semanticObject) {
        this.genericSequencer.createSequence(context, (EObject)semanticObject);
    }

    protected void sequence_CSSId(EObject context, CSSId semanticObject) {
        if (this.errorAcceptor != null && this.transientValues.isValueTransient((EObject)semanticObject, (EStructuralFeature)CssPackage.Literals.CSS_ID__VALUE) == ITransientValueService.ValueTransient.YES) {
            this.errorAcceptor.accept(this.diagnosticProvider.createFeatureValueMissing((EObject)semanticObject, (EStructuralFeature)CssPackage.Literals.CSS_ID__VALUE));
        }
        ISemanticNodeProvider.INodesForEObjectProvider nodes = this.createNodeProvider(semanticObject);
        SequenceFeeder feeder = this.createSequencerFeeder(semanticObject, nodes);
        feeder.accept(this.grammarAccess.getCSSIdAccess().getValueHASHTerminalRuleCall_0(), (Object)semanticObject.getValue());
        feeder.finish();
    }

    protected void sequence_Class(EObject context, Class semanticObject) {
        if (this.errorAcceptor != null && this.transientValues.isValueTransient((EObject)semanticObject, (EStructuralFeature)CssPackage.Literals.CLASS__CLASS) == ITransientValueService.ValueTransient.YES) {
            this.errorAcceptor.accept(this.diagnosticProvider.createFeatureValueMissing((EObject)semanticObject, (EStructuralFeature)CssPackage.Literals.CLASS__CLASS));
        }
        ISemanticNodeProvider.INodesForEObjectProvider nodes = this.createNodeProvider(semanticObject);
        SequenceFeeder feeder = this.createSequencerFeeder(semanticObject, nodes);
        feeder.accept(this.grammarAccess.getClassAccess().getClassT_CLASSTerminalRuleCall_0(), (Object)semanticObject.getClass_());
        feeder.finish();
    }

    protected void sequence_Combinator(EObject context, Combinator semanticObject) {
        if (this.errorAcceptor != null && this.transientValues.isValueTransient((EObject)semanticObject, (EStructuralFeature)CssPackage.Literals.COMBINATOR__KIND) == ITransientValueService.ValueTransient.YES) {
            this.errorAcceptor.accept(this.diagnosticProvider.createFeatureValueMissing((EObject)semanticObject, (EStructuralFeature)CssPackage.Literals.COMBINATOR__KIND));
        }
        ISemanticNodeProvider.INodesForEObjectProvider nodes = this.createNodeProvider(semanticObject);
        SequenceFeeder feeder = this.createSequencerFeeder(semanticObject, nodes);
        feeder.accept(this.grammarAccess.getCombinatorAccess().getKindKINDEnumRuleCall_0_0(), (Object)semanticObject.getKind());
        feeder.finish();
    }

    protected void sequence_CompositeSelector(EObject context, CompositeSelector semanticObject) {
        this.genericSequencer.createSequence(context, (EObject)semanticObject);
    }

    protected void sequence_Declaration(EObject context, Declaration semanticObject) {
        this.genericSequencer.createSequence(context, (EObject)semanticObject);
    }

    protected void sequence_Ems(EObject context, Ems semanticObject) {
        this.genericSequencer.createSequence(context, (EObject)semanticObject);
    }

    protected void sequence_Expression(EObject context, Expression semanticObject) {
        this.genericSequencer.createSequence(context, (EObject)semanticObject);
    }

    protected void sequence_Exs(EObject context, Exs semanticObject) {
        this.genericSequencer.createSequence(context, (EObject)semanticObject);
    }

    protected void sequence_Frequency(EObject context, Frequency semanticObject) {
        this.genericSequencer.createSequence(context, (EObject)semanticObject);
    }

    protected void sequence_Function(EObject context, Function semanticObject) {
        if (this.errorAcceptor != null) {
            if (this.transientValues.isValueTransient((EObject)semanticObject, (EStructuralFeature)CssPackage.Literals.FUNCTION__NAME) == ITransientValueService.ValueTransient.YES) {
                this.errorAcceptor.accept(this.diagnosticProvider.createFeatureValueMissing((EObject)semanticObject, (EStructuralFeature)CssPackage.Literals.FUNCTION__NAME));
            }
            if (this.transientValues.isValueTransient((EObject)semanticObject, (EStructuralFeature)CssPackage.Literals.FUNCTION__ARGS) == ITransientValueService.ValueTransient.YES) {
                this.errorAcceptor.accept(this.diagnosticProvider.createFeatureValueMissing((EObject)semanticObject, (EStructuralFeature)CssPackage.Literals.FUNCTION__ARGS));
            }
        }
        ISemanticNodeProvider.INodesForEObjectProvider nodes = this.createNodeProvider(semanticObject);
        SequenceFeeder feeder = this.createSequencerFeeder(semanticObject, nodes);
        feeder.accept(this.grammarAccess.getFunctionAccess().getNameIDTerminalRuleCall_0_0(), (Object)semanticObject.getName());
        feeder.accept(this.grammarAccess.getFunctionAccess().getArgsExpressionParserRuleCall_3_0(), (Object)semanticObject.getArgs());
        feeder.finish();
    }

    protected void sequence_HexColor(EObject context, HexColor semanticObject) {
        if (this.errorAcceptor != null && this.transientValues.isValueTransient((EObject)semanticObject, (EStructuralFeature)CssPackage.Literals.HEX_COLOR__VALUE) == ITransientValueService.ValueTransient.YES) {
            this.errorAcceptor.accept(this.diagnosticProvider.createFeatureValueMissing((EObject)semanticObject, (EStructuralFeature)CssPackage.Literals.HEX_COLOR__VALUE));
        }
        ISemanticNodeProvider.INodesForEObjectProvider nodes = this.createNodeProvider(semanticObject);
        SequenceFeeder feeder = this.createSequencerFeeder(semanticObject, nodes);
        feeder.accept(this.grammarAccess.getHexColorAccess().getValueHASHTerminalRuleCall_0(), (Object)semanticObject.getValue());
        feeder.finish();
    }

    protected void sequence_Import(EObject context, Import semanticObject) {
        this.genericSequencer.createSequence(context, (EObject)semanticObject);
    }

    protected void sequence_Length(EObject context, Length semanticObject) {
        this.genericSequencer.createSequence(context, (EObject)semanticObject);
    }

    protected void sequence_Media(EObject context, Media semanticObject) {
        this.genericSequencer.createSequence(context, (EObject)semanticObject);
    }

    protected void sequence_Name(EObject context, Name semanticObject) {
        if (this.errorAcceptor != null && this.transientValues.isValueTransient((EObject)semanticObject, (EStructuralFeature)CssPackage.Literals.NAME__VALUE) == ITransientValueService.ValueTransient.YES) {
            this.errorAcceptor.accept(this.diagnosticProvider.createFeatureValueMissing((EObject)semanticObject, (EStructuralFeature)CssPackage.Literals.NAME__VALUE));
        }
        ISemanticNodeProvider.INodesForEObjectProvider nodes = this.createNodeProvider(semanticObject);
        SequenceFeeder feeder = this.createSequencerFeeder(semanticObject, nodes);
        feeder.accept(this.grammarAccess.getNameAccess().getValueIDTerminalRuleCall_0(), (Object)semanticObject.getValue());
        feeder.finish();
    }

    protected void sequence_Number(EObject context, Number semanticObject) {
        this.genericSequencer.createSequence(context, (EObject)semanticObject);
    }

    protected void sequence_Page(EObject context, Page semanticObject) {
        this.genericSequencer.createSequence(context, (EObject)semanticObject);
    }

    protected void sequence_Percentage(EObject context, Percentage semanticObject) {
        this.genericSequencer.createSequence(context, (EObject)semanticObject);
    }

    protected void sequence_PseudoPage(EObject context, PseudoPage semanticObject) {
        if (this.errorAcceptor != null && this.transientValues.isValueTransient((EObject)semanticObject, (EStructuralFeature)CssPackage.Literals.PSEUDO_PAGE__ID) == ITransientValueService.ValueTransient.YES) {
            this.errorAcceptor.accept(this.diagnosticProvider.createFeatureValueMissing((EObject)semanticObject, (EStructuralFeature)CssPackage.Literals.PSEUDO_PAGE__ID));
        }
        ISemanticNodeProvider.INodesForEObjectProvider nodes = this.createNodeProvider(semanticObject);
        SequenceFeeder feeder = this.createSequencerFeeder(semanticObject, nodes);
        feeder.accept(this.grammarAccess.getPseudoPageAccess().getIdIDTerminalRuleCall_1_0(), (Object)semanticObject.getId());
        feeder.finish();
    }

    protected void sequence_Pseudo(EObject context, Pseudo semanticObject) {
        this.genericSequencer.createSequence(context, (EObject)semanticObject);
    }

    protected void sequence_Ruleset(EObject context, Ruleset semanticObject) {
        this.genericSequencer.createSequence(context, (EObject)semanticObject);
    }

    protected void sequence_SimpleSelector(EObject context, SimpleSelector semanticObject) {
        this.genericSequencer.createSequence(context, (EObject)semanticObject);
    }

    protected void sequence_StringValue(EObject context, StringValue semanticObject) {
        if (this.errorAcceptor != null && this.transientValues.isValueTransient((EObject)semanticObject, (EStructuralFeature)CssPackage.Literals.STRING_VALUE__VALUE) == ITransientValueService.ValueTransient.YES) {
            this.errorAcceptor.accept(this.diagnosticProvider.createFeatureValueMissing((EObject)semanticObject, (EStructuralFeature)CssPackage.Literals.STRING_VALUE__VALUE));
        }
        ISemanticNodeProvider.INodesForEObjectProvider nodes = this.createNodeProvider(semanticObject);
        SequenceFeeder feeder = this.createSequencerFeeder(semanticObject, nodes);
        feeder.accept(this.grammarAccess.getStringValueAccess().getValueSTRINGTerminalRuleCall_0(), (Object)semanticObject.getValue());
        feeder.finish();
    }

    protected void sequence_Stylesheet(EObject context, Stylesheet semanticObject) {
        this.genericSequencer.createSequence(context, (EObject)semanticObject);
    }

    protected void sequence_Subterm(EObject context, Subterm semanticObject) {
        this.genericSequencer.createSequence(context, (EObject)semanticObject);
    }

    protected void sequence_Time(EObject context, Time semanticObject) {
        this.genericSequencer.createSequence(context, (EObject)semanticObject);
    }

    protected void sequence_UnaryOperator(EObject context, UnaryOperator semanticObject) {
        if (this.errorAcceptor != null && this.transientValues.isValueTransient((EObject)semanticObject, (EStructuralFeature)CssPackage.Literals.UNARY_OPERATOR__OPERATOR) == ITransientValueService.ValueTransient.YES) {
            this.errorAcceptor.accept(this.diagnosticProvider.createFeatureValueMissing((EObject)semanticObject, (EStructuralFeature)CssPackage.Literals.UNARY_OPERATOR__OPERATOR));
        }
        ISemanticNodeProvider.INodesForEObjectProvider nodes = this.createNodeProvider(semanticObject);
        SequenceFeeder feeder = this.createSequencerFeeder(semanticObject, nodes);
        feeder.accept(this.grammarAccess.getUnaryOperatorAccess().getOperatorUNARYEnumRuleCall_0(), (Object)semanticObject.getOperator());
        feeder.finish();
    }

    protected void sequence_Uri(EObject context, Uri semanticObject) {
        if (this.errorAcceptor != null && this.transientValues.isValueTransient((EObject)semanticObject, (EStructuralFeature)CssPackage.Literals.URI__VALUE) == ITransientValueService.ValueTransient.YES) {
            this.errorAcceptor.accept(this.diagnosticProvider.createFeatureValueMissing((EObject)semanticObject, (EStructuralFeature)CssPackage.Literals.URI__VALUE));
        }
        ISemanticNodeProvider.INodesForEObjectProvider nodes = this.createNodeProvider(semanticObject);
        SequenceFeeder feeder = this.createSequencerFeeder(semanticObject, nodes);
        feeder.accept(this.grammarAccess.getUriAccess().getValueSTRINGTerminalRuleCall_2_0(), (Object)semanticObject.getValue());
        feeder.finish();
    }
}

