/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.css.dom;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.e4.ui.css.core.dom.ElementAdapter;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.NamedStyle;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.StringListValueStyle;
import org.eclipse.gmf.runtime.notation.StringValueStyle;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.gmfdiag.common.listener.CustomStyleListener;
import org.eclipse.papyrus.infra.gmfdiag.css.dom.StyleListener;
import org.eclipse.papyrus.infra.gmfdiag.css.engine.ExtendedCSSEngine;
import org.eclipse.papyrus.infra.gmfdiag.css.helper.SemanticElementHelper;
import org.eclipse.papyrus.infra.gmfdiag.css.notation.CSSDiagram;
import org.eclipse.papyrus.infra.tools.util.ListHelper;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GMFElementAdapter
extends ElementAdapter
implements NodeList,
IChangeListener {
    public static final Map<String, String> diagramNameMappings = new HashMap<String, String>();
    private EObject semanticElement;
    private View notationElement;
    private String namespaceURI;
    private String localName;
    private Node[] children;
    private Node parentNode;
    private Adapter styleListener;
    private CustomStyleListener cssStyleListener;

    static {
        diagramNameMappings.put("CompositeStructure", "CompositeDiagram");
        diagramNameMappings.put("Package", "PackageDiagram");
        diagramNameMappings.put("PapyrusUMLActivityDiagram", "ActivityDiagram");
        diagramNameMappings.put("PapyrusUMLClassDiagram", "ClassDiagram");
        diagramNameMappings.put("PapyrusUMLCommunicationDiagram", "CommunicationDiagram");
        diagramNameMappings.put("PapyrusUMLComponentDiagram", "ComponentDiagram");
        diagramNameMappings.put("PapyrusUMLDeploymentDiagram", "DeploymentDiagram");
        diagramNameMappings.put("PapyrusUMLProfileDiagram", "ProfileDiagram");
        diagramNameMappings.put("PapyrusUMLSequenceDiagram", "SequenceDiagram");
        diagramNameMappings.put("PapyrusUMLStateMachineDiagram", "StateMachineDiagram");
        diagramNameMappings.put("UseCase", "UseCaseDiagram");
        diagramNameMappings.put("BlockDefinition", "BlockDiagram");
        diagramNameMappings.put("InternalBlock", "InternalBlockDiagram");
        diagramNameMappings.put("PapyrusSysMLRequirement", "RequirementDiagram");
        diagramNameMappings.put("Parametric", "ParametricDiagram");
    }

    public static String getCSSID(EObject sourceElement) {
        return GMFElementAdapter.getCSSValue(sourceElement, "cssId");
    }

    public static String getCSSClass(EObject sourceElement) {
        List<String> allClasses = GMFElementAdapter.getCSSValues(sourceElement, "cssClass");
        return ListHelper.deepToString(allClasses, (String)" ");
    }

    public static String getCSSStyle(EObject sourceElement) {
        return GMFElementAdapter.getCSSValue(sourceElement, "cssStyle");
    }

    private static String getCSSValue(EObject sourceElement, String key) {
        StringValueStyle style = (StringValueStyle)GMFElementAdapter.findStyle(sourceElement, key, NotationPackage.eINSTANCE.getStringValueStyle());
        if (style == null) {
            return null;
        }
        return style.getStringValue();
    }

    private static List<String> getCSSValues(EObject sourceElement, String key) {
        StringListValueStyle style = (StringListValueStyle)GMFElementAdapter.findStyle(sourceElement, key, NotationPackage.eINSTANCE.getStringListValueStyle());
        if (style == null) {
            return Collections.emptyList();
        }
        return style.getStringListValue();
    }

    private static NamedStyle findStyle(EObject sourceElement, String key, EClass type) {
        View view = GMFElementAdapter.findView(sourceElement);
        if (view == null) {
            return null;
        }
        return view.getNamedStyle(type, key);
    }

    private static View findView(EObject sourceElement) {
        if (sourceElement == null) {
            return null;
        }
        if (sourceElement instanceof View) {
            return (View)sourceElement;
        }
        return GMFElementAdapter.findView(sourceElement.eContainer());
    }

    public GMFElementAdapter(View view, ExtendedCSSEngine engine) {
        super((Object)view, (CSSEngine)engine);
        this.notationElement = view;
        this.listenNotationElement();
    }

    public EObject getSemanticElement() {
        if (this.semanticElement == null) {
            this.semanticElement = SemanticElementHelper.findSemanticElement((EObject)this.notationElement);
            this.listenSemanticElement();
        }
        return this.semanticElement;
    }

    private Adapter getStyleListener() {
        if (this.styleListener == null) {
            this.styleListener = new StyleListener(this);
        }
        return this.styleListener;
    }

    private void listenNotationElement() {
        this.notationElement.eAdapters().add((Object)this.getStyleListener());
        List<String> cssStyles = Arrays.asList("cssClass", "cssId", "cssStyle", "css_stylesheets");
        this.cssStyleListener = new CustomStyleListener(this.notationElement, (IChangeListener)this, cssStyles);
        this.notationElement.eAdapters().add((Object)this.cssStyleListener);
    }

    private ExtendedCSSEngine getEngine() {
        return (ExtendedCSSEngine)this.engine;
    }

    private void listenSemanticElement() {
        if (this.semanticElement != null) {
            this.semanticElement.eAdapters().add((Object)this.getStyleListener());
        }
    }

    public Node getParentNode() {
        if (this.parentNode == null) {
            View gmfElement = this.notationElement;
            while (gmfElement != null) {
                EObject semanticElement = SemanticElementHelper.findSemanticElement((EObject)gmfElement);
                if (semanticElement != this.getSemanticElement()) break;
                EObject container = gmfElement.eContainer();
                if (gmfElement == container || !(container instanceof View)) {
                    gmfElement = null;
                    break;
                }
                gmfElement = (View)container;
            }
            this.parentNode = this.engine.getElement((Object)gmfElement);
            if (this.parentNode == this) {
                this.parentNode = null;
                return null;
            }
        }
        return this.parentNode;
    }

    public NodeList getChildNodes() {
        return this;
    }

    public String getNamespaceURI() {
        if (this.namespaceURI == null) {
            this.namespaceURI = EMFHelper.getQualifiedName((EPackage)this.getSemanticElement().eClass().getEPackage(), (String)".");
        }
        return this.namespaceURI;
    }

    public String getCSSId() {
        return GMFElementAdapter.getCSSID((EObject)this.notationElement);
    }

    public String getCSSClass() {
        return GMFElementAdapter.getCSSClass((EObject)this.notationElement);
    }

    public String getCSSStyle() {
        return GMFElementAdapter.getCSSStyle((EObject)this.notationElement);
    }

    public String getLocalName() {
        if (this.localName == null) {
            Diagram diagram;
            String type;
            this.localName = this.getSemanticElement() instanceof Diagram ? (diagramNameMappings.containsKey(type = (diagram = (Diagram)this.getSemanticElement()).getType()) ? diagramNameMappings.get(type) : type) : this.getSemanticElement().eClass().getName();
        }
        return this.localName;
    }

    public String getAttribute(String attr) {
        Object value;
        EStructuralFeature feature = this.getSemanticElement().eClass().getEStructuralFeature(attr);
        if (feature != null && (value = this.semanticElement.eGet(feature)) != null) {
            return value.toString();
        }
        return "";
    }

    public EObject getNativeWidget() {
        return this.notationElement;
    }

    @Override
    public Node item(int index) {
        return this.getChildren()[index];
    }

    @Override
    public int getLength() {
        return this.getChildren().length;
    }

    private Node[] getChildren() {
        if (this.children == null) {
            this.children = GMFElementAdapter.computeChildren(this.notationElement, this.engine);
        }
        return this.children;
    }

    private static Node[] computeChildren(View notationElement, CSSEngine engine) {
        EObject semanticElement = SemanticElementHelper.findSemanticElement((EObject)notationElement);
        LinkedList<Node> childList = new LinkedList<Node>();
        for (EObject child : notationElement.eContents()) {
            if (!(child instanceof View)) continue;
            View notationChild = (View)child;
            if (SemanticElementHelper.findSemanticElement((EObject)notationChild) != semanticElement) {
                childList.add(engine.getElement((Object)notationChild));
                continue;
            }
            childList.addAll(Arrays.asList(GMFElementAdapter.computeChildren(notationChild, engine)));
        }
        return childList.toArray(new Node[childList.size()]);
    }

    public View getNotationElement() {
        return this.notationElement;
    }

    public void semanticElementChanged() {
        if (this.semanticElement != null && this.semanticElement != this.notationElement) {
            this.semanticElement.eAdapters().remove((Object)this.styleListener);
            this.semanticElement = null;
        }
        this.localName = null;
        this.parentNode = null;
        this.namespaceURI = null;
        this.children = null;
        this.getEngine().notifyChange((Element)((Object)this));
    }

    public void handleChange(ChangeEvent event) {
        if (this.notationElement instanceof CSSDiagram) {
            this.getEngine().reset();
        }
        this.getEngine().notifyChange((Element)((Object)this));
    }

    public void dispose() {
        super.dispose();
        this.notationElement.eAdapters().remove((Object)this.cssStyleListener);
        this.cssStyleListener.dispose();
        this.notationElement.eAdapters().remove((Object)this.styleListener);
        if (this.semanticElement != null) {
            this.semanticElement.eAdapters().remove((Object)this.styleListener);
        }
    }

    public void notationPropertyChanged() {
        this.getEngine().notifyChange((Element)((Object)this));
    }

    public void semanticPropertyChanged() {
        this.getEngine().notifyChange((Element)((Object)this));
    }

    public void notationElementDisposed() {
        this.dispose();
        this.getEngine().handleDispose(this.notationElement);
    }
}

