/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.css.helper;

import java.io.IOException;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.datatype.GradientData;
import org.eclipse.papyrus.infra.gmfdiag.css.engine.ExtendedCSSEngine;
import org.eclipse.papyrus.infra.gmfdiag.css.helper.ParserHelper;
import org.eclipse.papyrus.infra.gmfdiag.css.helper.StringHelper;
import org.w3c.dom.css.CSSValue;

public class GradientHelper {
    public static final String GRADIENT_VERTICAL = "vertical";
    public static final String GRADIENT_HORIZONTAL = "horizontal";

    public static GradientData computeGradient(ExtendedCSSEngine engine, Object node) {
        CSSValue gradientColor = engine.retrievePropertyValue(node, "gradientColor");
        CSSValue gradientStyle = engine.retrievePropertyValue(node, "gradientStyle");
        if (gradientColor != null || gradientStyle != null) {
            int color1 = (Integer)engine.convert(gradientColor, "GMFColor", null);
            int color2 = 0;
            int style = GradientHelper.getGradientStyle(gradientStyle.getCssText());
            GradientData data = new GradientData(color1, color2, style);
            return data;
        }
        CSSValue gradient = engine.retrievePropertyValue(node, "gradient");
        if (gradient != null) {
            String gradientString = gradient.getCssText();
            if (StringHelper.equals(gradientString, "none")) {
                return null;
            }
            int[] gradientValues = GradientHelper.parseGradient(engine, gradientString);
            return new GradientData(gradientValues[0], gradientValues[1], gradientValues[2]);
        }
        return (GradientData)NotationPackage.eINSTANCE.getFillStyle_Gradient().getDefaultValue();
    }

    private static int[] parseGradient(ExtendedCSSEngine engine, String gradient) {
        String style = null;
        String color2 = null;
        String color1 = null;
        String[] values = ParserHelper.parseValues(engine, gradient);
        if (values.length == 3) {
            color1 = values[0];
            color2 = values[1];
            style = values[2];
        } else if (values.length == 2) {
            color1 = values[0];
            String value = values[1];
            if (GradientHelper.isGradientStyle(value)) {
                style = value;
            } else {
                color2 = value;
            }
        } else if (values.length == 1) {
            String value = values[0];
            if (GradientHelper.isGradientStyle(value)) {
                style = value;
            } else {
                color1 = value;
            }
        }
        return GradientHelper.parseGradient(engine, color1, color2, style);
    }

    private static int[] parseGradient(ExtendedCSSEngine engine, String sColor1, String sColor2, String sStyle) {
        int style = -1;
        int color2 = -1;
        int color1 = -1;
        try {
            CSSValue cssColor1 = engine.parsePropertyValue(sColor1);
            color1 = (Integer)engine.convert(cssColor1, "GMFColor", null);
            color2 = 0;
            style = GradientHelper.getGradientStyle(sStyle);
        }
        catch (IOException ex) {
            engine.handleExceptions(ex);
        }
        return new int[]{color1, color2, style};
    }

    private static boolean isGradientStyle(String value) {
        return StringHelper.equals(GRADIENT_VERTICAL, value) || StringHelper.equals(GRADIENT_HORIZONTAL, value);
    }

    private static int getGradientStyle(String gradientStyle) {
        if (StringHelper.equals(GRADIENT_VERTICAL, gradientStyle)) {
            return 0;
        }
        if (StringHelper.equals(GRADIENT_HORIZONTAL, gradientStyle)) {
            return 1;
        }
        return new GradientData().getGradientStyle();
    }
}

