/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.css.notation;

import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.css.resource.CSSNotationResource;

public class ForceValueHelper {
    public static void setValue(View view, EStructuralFeature feature, Object value) {
        if (!ForceValueHelper.isCSSView(view)) {
            return;
        }
        if (ForceValueHelper.equals(value, feature.getDefaultValue())) {
            String annotationKey = feature.getName();
            EAnnotation eAnnotation = view.getEAnnotation("PapyrusCSSForceValue");
            if (eAnnotation == null) {
                eAnnotation = EcorePackage.eINSTANCE.getEcoreFactory().createEAnnotation();
                eAnnotation.setEModelElement((EModelElement)view);
                eAnnotation.setSource("PapyrusCSSForceValue");
            }
            EMap details = eAnnotation.getDetails();
            details.put((Object)annotationKey, (Object)Boolean.toString(true));
        }
    }

    private static boolean isCSSView(View view) {
        return view != null && view.eResource() instanceof CSSNotationResource;
    }

    private static boolean equals(Object value1, Object value2) {
        if (value1 == null) {
            return value2 == null;
        }
        return value1.equals(value2);
    }

    public static void unsetValue(View view, EStructuralFeature feature) {
        if (feature == null) {
            return;
        }
        if (!ForceValueHelper.isCSSView(view)) {
            return;
        }
        String annotationKey = feature.getName();
        EAnnotation eAnnotation = view.getEAnnotation("PapyrusCSSForceValue");
        if (eAnnotation != null) {
            EMap details = eAnnotation.getDetails();
            details.remove((Object)annotationKey);
            if (details.isEmpty()) {
                view.getEAnnotations().remove((Object)eAnnotation);
            }
        }
    }

    public static boolean isSet(View view, EStructuralFeature feature, Object value) {
        return ForceValueHelper.isSet(view, (EObject)view, feature, value);
    }

    public static boolean isSet(View annotationContext, EObject style, EStructuralFeature feature, Object value) {
        if (!ForceValueHelper.isCSSView(annotationContext)) {
            return true;
        }
        if (ForceValueHelper.equals(value, feature.getDefaultValue())) {
            EAnnotation eAnnotation = annotationContext.getEAnnotation("PapyrusCSSForceValue");
            if (eAnnotation == null) {
                return false;
            }
            String annotationKey = feature.getName();
            return eAnnotation.getDetails().containsKey((Object)annotationKey);
        }
        return true;
    }
}

