/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.css.resource;

import java.util.Collection;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.gmf.runtime.emf.core.resources.GMFResource;
import org.eclipse.papyrus.infra.gmfdiag.css.engine.ExtendedCSSEngine;
import org.eclipse.papyrus.infra.gmfdiag.css.engine.ModelCSSEngine;

public class CSSNotationResource
extends GMFResource {
    private ExtendedCSSEngine engine;
    private Adapter disposeListener;

    public CSSNotationResource(URI uri) {
        super(uri);
    }

    public ExtendedCSSEngine getEngine() {
        if (this.engine == null) {
            this.engine = new ModelCSSEngine((Resource)this);
            this.disposeListener = new ResourceDisposeListener();
            this.getResourceSet().eAdapters().add((Object)this.disposeListener);
        }
        return this.engine;
    }

    private void disposeEngine(Object notifier) {
        if (this.engine != null) {
            this.engine.dispose();
            this.engine = null;
            ((ResourceSet)notifier).eAdapters().remove((Object)this.disposeListener);
        }
    }

    private class ResourceDisposeListener
    extends AdapterImpl {
        private ResourceDisposeListener() {
        }

        public void notifyChanged(Notification notification) {
            switch (notification.getEventType()) {
                case 6: {
                    for (Object oldValue : (Collection)notification.getOldValue()) {
                        if (oldValue != CSSNotationResource.this) continue;
                        CSSNotationResource.this.disposeEngine(notification.getNotifier());
                    }
                    break;
                }
                case 4: {
                    if (notification.getOldValue() != CSSNotationResource.this) break;
                    CSSNotationResource.this.disposeEngine(notification.getNotifier());
                }
            }
        }
    }
}

