/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.css.style.impl;

import org.eclipse.gmf.runtime.notation.FillStyle;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.datatype.GradientData;
import org.eclipse.papyrus.infra.gmfdiag.css.engine.ExtendedCSSEngine;
import org.eclipse.papyrus.infra.gmfdiag.css.helper.GradientHelper;
import org.eclipse.papyrus.infra.gmfdiag.css.style.CSSFillStyle;
import org.w3c.dom.css.CSSValue;

public class CSSFillStyleDelegate
implements CSSFillStyle {
    private FillStyle fillStyle;
    private ExtendedCSSEngine engine;

    public CSSFillStyleDelegate(FillStyle fillStyle, ExtendedCSSEngine engine) {
        this.fillStyle = fillStyle;
        this.engine = engine;
    }

    public int getCSSFillColor() {
        CSSValue cssValue = this.engine.retrievePropertyValue(this.fillStyle, "fillColor");
        if (cssValue == null) {
            Object defaultValue = NotationPackage.eINSTANCE.getFillStyle_FillColor().getDefaultValue();
            return (Integer)defaultValue;
        }
        return (Integer)this.engine.convert(cssValue, "GMFColor", null);
    }

    public int getCSSTransparency() {
        CSSValue cssValue = this.engine.retrievePropertyValue(this.fillStyle, "transparency");
        if (cssValue == null) {
            Object defaultValue = NotationPackage.eINSTANCE.getFillStyle_Transparency().getDefaultValue();
            return (Integer)defaultValue;
        }
        return (Integer)this.engine.convert(cssValue, Integer.class, null);
    }

    public GradientData getCSSGradient() {
        return GradientHelper.computeGradient(this.engine, this.fillStyle);
    }
}

