/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.css.theme;

import java.io.IOException;
import java.net.URL;
import java.text.Collator;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.papyrus.infra.gmfdiag.css.Activator;
import org.eclipse.papyrus.infra.gmfdiag.css.theme.Theme;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThemeManager {
    public static String EXTENSION_ID = "org.eclipse.papyrus.infra.gmfdiag.css.theme";
    public static ThemeManager instance = new ThemeManager();
    private Map<String, Theme> allThemes;

    public List<Theme> getThemes() {
        LinkedList<Theme> sortedThemes = new LinkedList<Theme>(this.getAllThemes().values());
        Collections.sort(sortedThemes, ThemeComparator.instance);
        return sortedThemes;
    }

    public List<URL> getWorkspaceStyleSheets() {
        Theme current = this.findCurrentTheme();
        if (current == null) {
            return Collections.emptyList();
        }
        return current.getStyleSheets();
    }

    public Theme getTheme(String themeId) {
        return this.getAllThemes().get(themeId);
    }

    private Map<String, Theme> getAllThemes() {
        if (this.allThemes == null) {
            this.allThemes = new HashMap<String, Theme>();
            this.allThemes.put(EmptyTheme.instance.getId(), EmptyTheme.instance);
            IConfigurationElement[] config = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_ID);
            this.loadThemeDefinitions(config);
            this.loadThemeContributions(config);
        }
        return this.allThemes;
    }

    private void loadThemeDefinitions(IConfigurationElement[] config) {
        IConfigurationElement[] iConfigurationElementArray = config;
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement themeConfig = iConfigurationElementArray[n2];
            if (themeConfig.getName().equals("themeDefinition")) {
                String themeId = themeConfig.getAttribute("id");
                if (themeId == null) {
                    Activator.log.warn("Cannot define a CSS Theme with an empty id (Contributed by " + themeConfig.getContributor() + ")");
                } else {
                    Image icon;
                    Theme theme = new Theme(themeId);
                    String themeLabel = themeConfig.getAttribute("label");
                    theme.setLabel(themeLabel);
                    String themeIcon = themeConfig.getAttribute("icon");
                    if (themeIcon != null && (icon = org.eclipse.papyrus.infra.widgets.Activator.getDefault().getImage(themeConfig.getContributor().getName(), themeIcon)) != null) {
                        theme.setIcon(icon);
                    }
                    this.allThemes.put(themeId, theme);
                }
            }
            ++n2;
        }
    }

    private void loadThemeContributions(IConfigurationElement[] config) {
        IConfigurationElement[] iConfigurationElementArray = config;
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement themeConfig = iConfigurationElementArray[n2];
            if (themeConfig.getName().equals("themeContribution")) {
                String themeId = themeConfig.getAttribute("id");
                if (themeId == null || !this.allThemes.containsKey(themeId)) {
                    Activator.log.warn("Cannot contribute to an undefined theme: " + themeId);
                } else {
                    IConfigurationElement[] stylesheets;
                    Theme theme = this.allThemes.get(themeId);
                    IConfigurationElement[] iConfigurationElementArray2 = stylesheets = themeConfig.getChildren("stylesheet");
                    int n3 = stylesheets.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IConfigurationElement stylesheetConfig = iConfigurationElementArray2[n4];
                        String path = stylesheetConfig.getAttribute("stylesheetPath");
                        try {
                            URL url = new URL("platform:/plugin/" + themeConfig.getContributor().getName() + "/" + path);
                            theme.addStyleSheet(url);
                        }
                        catch (IOException ex) {
                            Activator.log.error((Throwable)ex);
                        }
                        ++n4;
                    }
                }
            }
            ++n2;
        }
    }

    private Theme findCurrentTheme() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        if (store.contains("currentTheme")) {
            String themeId = store.getString("currentTheme");
            Theme theme = this.getAllThemes().containsKey(themeId) ? this.getAllThemes().get(themeId) : EmptyTheme.instance;
            return theme;
        }
        List<Theme> sortedThemes = this.getThemes();
        if (sortedThemes.size() < 2) {
            return EmptyTheme.instance;
        }
        Theme theme = sortedThemes.get(1);
        store.setValue("currentTheme", theme.getId());
        try {
            ((IPersistentPreferenceStore)store).save();
        }
        catch (IOException e) {
            Activator.log.error((Throwable)e);
        }
        return theme;
    }

    private ThemeManager() {
    }

    public static class EmptyTheme
    extends Theme {
        public static Theme instance = new EmptyTheme();

        private EmptyTheme() {
            super("none");
            this.setLabel("No theme");
            Image icon = org.eclipse.papyrus.infra.widgets.Activator.getDefault().getImage("icons/Delete_12x12.gif");
            this.setIcon(icon);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ThemeComparator
    implements Comparator<Theme> {
        public static Comparator<Theme> instance = new ThemeComparator();

        private ThemeComparator() {
        }

        @Override
        public int compare(Theme o1, Theme o2) {
            if (o1 == EmptyTheme.instance) {
                return -1;
            }
            if (o2 == EmptyTheme.instance) {
                return 1;
            }
            return Collator.getInstance().compare(o1.getLabel(), o2.getLabel());
        }
    }
}

