/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.layout.subeditor.gmf;

import java.util.Map;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.Animation;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.commands.SetConnectionBendpointsCommand;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.layout.Activator;
import org.eclipse.papyrus.layout.LayouttoolInterface;
import org.eclipse.papyrus.layout.subeditor.gmf.GMFLayoutAreaCreator;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GMFSubEditor
implements LayouttoolInterface {
    CompositeCommand command = new CompositeCommand("Apply Layout");

    public void execute(Map<EditPart, Rectangle> map) {
        TransactionalEditingDomain ted = this.getTransactionalEditingDomain();
        if (ted != null) {
            CommandStack cs = null;
            for (Map.Entry<EditPart, Rectangle> s : map.entrySet()) {
                SetBoundsCommand boundsCommand = new SetBoundsCommand(ted, "apply layout", (IAdaptable)new EObjectAdapter((EObject)((View)s.getKey().getModel())), s.getValue());
                this.command.add((IUndoableOperation)boundsCommand);
                GraphicalEditPart gep = (GraphicalEditPart)s.getKey();
                if (cs != null) continue;
                cs = gep.getViewer().getEditDomain().getCommandStack();
            }
            try {
                Animation.markBegin();
                cs.execute((Command)new ICommandProxy((ICommand)this.command));
                Animation.run((int)1000);
            }
            catch (Exception e) {
                Activator.getDefault().log(String.valueOf(e.getMessage()) + " : Cannot apply new bounds of all nodes", e);
            }
        }
    }

    private TransactionalEditingDomain getTransactionalEditingDomain() {
        IDiagramWorkbenchPart workbenchPart;
        TransactionalEditingDomain ted = null;
        IEditorPart activeEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (activeEditor instanceof IDiagramWorkbenchPart && (ted = (TransactionalEditingDomain)(workbenchPart = (IDiagramWorkbenchPart)activeEditor).getAdapter(EditingDomain.class)) == null && workbenchPart instanceof DiagramEditor) {
            DiagramEditor editor = (DiagramEditor)workbenchPart;
            ted = editor.getEditingDomain();
        }
        return ted;
    }

    public Rectangle getBounds(EditPart element) {
        Node node;
        if (element.getModel() instanceof Node && (node = (Node)element.getModel()).getLayoutConstraint() instanceof Bounds) {
            Bounds bounds = (Bounds)node.getLayoutConstraint();
            return new Rectangle(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight());
        }
        return null;
    }

    public EditPart getTarget(EditPart element) {
        if (element.getModel() instanceof Edge) {
            Edge edge = (Edge)element.getModel();
            this.removeBendPoints(edge);
            AbstractConnectionEditPart acep = (AbstractConnectionEditPart)element;
            return acep.getTarget();
        }
        return null;
    }

    public void removeBendPoints(Edge edge) {
        SetConnectionBendpointsCommand scbc = new SetConnectionBendpointsCommand(this.getTransactionalEditingDomain());
        scbc.setEdgeAdapter((IAdaptable)new EObjectAdapter((EObject)edge));
        scbc.setNewPointList(new PointList(), new Point(), new Point());
        this.command.add((IUndoableOperation)scbc);
    }

    public Rectangle getLayoutArea(EditPart[] element) {
        if (GMFLayoutAreaCreator.getBounds() != null) {
            Rectangle bounds = GMFLayoutAreaCreator.getBounds();
            GMFLayoutAreaCreator.deleteLayoutArea();
            return bounds;
        }
        EditPart[] editPartArray = element;
        int n = element.length;
        int n2 = 0;
        while (n2 < n) {
            EditPart e = editPartArray[n2];
            if (e.getModel() instanceof Node && e.getParent() instanceof GraphicalEditPart) {
                GraphicalEditPart gep = (GraphicalEditPart)e.getParent();
                Rectangle bounds = gep.getFigure().getBounds();
                bounds.x = 0;
                bounds.y = 0;
                return bounds;
            }
            ++n2;
        }
        return new Rectangle(0, 0, 1000, 1000);
    }

    public EditPart getSource(EditPart element) {
        if (element.getModel() instanceof Edge) {
            Edge edge = (Edge)element.getModel();
            this.removeBendPoints(edge);
            AbstractConnectionEditPart acep = (AbstractConnectionEditPart)element;
            return acep.getSource();
        }
        return null;
    }

    public boolean isNode(EditPart element) {
        if (element.getModel() instanceof Node) {
            return GMFLayoutAreaCreator.getArea() == null || !element.equals(GMFLayoutAreaCreator.getArea());
        }
        return false;
    }

    public boolean isRelationship(EditPart element) {
        return element.getModel() instanceof Edge;
    }

    public Class getEditorClass() {
        return IDiagramWorkbenchPart.class;
    }
}

