/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.MARTE.MARTE_DesignModel.GCM;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum DataPoolOrderingKind implements Enumerator
{
    FIFO(0, "FIFO", "FIFO"),
    LIFO(1, "LIFO", "LIFO"),
    USER_DEFINED(2, "UserDefined", "UserDefined");

    public static final int FIFO_VALUE = 0;
    public static final int LIFO_VALUE = 1;
    public static final int USER_DEFINED_VALUE = 2;
    private static final DataPoolOrderingKind[] VALUES_ARRAY;
    public static final List<DataPoolOrderingKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new DataPoolOrderingKind[]{FIFO, LIFO, USER_DEFINED};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static DataPoolOrderingKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DataPoolOrderingKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DataPoolOrderingKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DataPoolOrderingKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DataPoolOrderingKind get(int value) {
        switch (value) {
            case 0: {
                return FIFO;
            }
            case 1: {
                return LIFO;
            }
            case 2: {
                return USER_DEFINED;
            }
        }
        return null;
    }

    private DataPoolOrderingKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

