/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.MARTE.MARTE_DesignModel.GCM;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum PortSpecificationKind implements Enumerator
{
    ATOMIC(0, "atomic", "atomic"),
    INTERFACE_BASED(1, "interfaceBased", "interfaceBased"),
    FEATURE_BASED(2, "featureBased", "featureBased");

    public static final int ATOMIC_VALUE = 0;
    public static final int INTERFACE_BASED_VALUE = 1;
    public static final int FEATURE_BASED_VALUE = 2;
    private static final PortSpecificationKind[] VALUES_ARRAY;
    public static final List<PortSpecificationKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new PortSpecificationKind[]{ATOMIC, INTERFACE_BASED, FEATURE_BASED};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static PortSpecificationKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PortSpecificationKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PortSpecificationKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PortSpecificationKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PortSpecificationKind get(int value) {
        switch (value) {
            case 0: {
                return ATOMIC;
            }
            case 1: {
                return INTERFACE_BASED;
            }
            case 2: {
                return FEATURE_BASED;
            }
        }
        return null;
    }

    private PortSpecificationKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

