/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.MARTE.MARTE_DesignModel.HLAM;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ConcurrencyKind implements Enumerator
{
    READER(0, "reader", "reader"),
    WRITER(1, "writer", "writer"),
    PARALLEL(2, "parallel", "parallel");

    public static final int READER_VALUE = 0;
    public static final int WRITER_VALUE = 1;
    public static final int PARALLEL_VALUE = 2;
    private static final ConcurrencyKind[] VALUES_ARRAY;
    public static final List<ConcurrencyKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ConcurrencyKind[]{READER, WRITER, PARALLEL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ConcurrencyKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ConcurrencyKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ConcurrencyKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ConcurrencyKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ConcurrencyKind get(int value) {
        switch (value) {
            case 0: {
                return READER;
            }
            case 1: {
                return WRITER;
            }
            case 2: {
                return PARALLEL;
            }
        }
        return null;
    }

    private ConcurrencyKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

