/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.MARTE.MARTE_DesignModel.HLAM;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ExecutionKind implements Enumerator
{
    DEFERRED(0, "deferred", "deferred"),
    REMOTE_IMMEDIATE(1, "remoteImmediate", "remoteImmediate"),
    LOCAL_IMMEDIATE(2, "localImmediate", "localImmediate");

    public static final int DEFERRED_VALUE = 0;
    public static final int REMOTE_IMMEDIATE_VALUE = 1;
    public static final int LOCAL_IMMEDIATE_VALUE = 2;
    private static final ExecutionKind[] VALUES_ARRAY;
    public static final List<ExecutionKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ExecutionKind[]{DEFERRED, REMOTE_IMMEDIATE, LOCAL_IMMEDIATE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ExecutionKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ExecutionKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ExecutionKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ExecutionKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ExecutionKind get(int value) {
        switch (value) {
            case 0: {
                return DEFERRED;
            }
            case 1: {
                return REMOTE_IMMEDIATE;
            }
            case 2: {
                return LOCAL_IMMEDIATE;
            }
        }
        return null;
    }

    private ExecutionKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

