/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.MARTE.MARTE_DesignModel.HLAM;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum SynchronizationKind implements Enumerator
{
    SYNCHRONOUS(0, "synchronous", "synchronous"),
    ASYNCHRONOUS(1, "asynchronous", "asynchronous"),
    DELAYED_SYNCHRONOUS(2, "delayedSynchronous", "delayedSynchronous"),
    RENDEZ_VOUS(3, "rendezVous", "rendezVous"),
    OTHER(4, "other", "other");

    public static final int SYNCHRONOUS_VALUE = 0;
    public static final int ASYNCHRONOUS_VALUE = 1;
    public static final int DELAYED_SYNCHRONOUS_VALUE = 2;
    public static final int RENDEZ_VOUS_VALUE = 3;
    public static final int OTHER_VALUE = 4;
    private static final SynchronizationKind[] VALUES_ARRAY;
    public static final List<SynchronizationKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new SynchronizationKind[]{SYNCHRONOUS, ASYNCHRONOUS, DELAYED_SYNCHRONOUS, RENDEZ_VOUS, OTHER};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static SynchronizationKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SynchronizationKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SynchronizationKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SynchronizationKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SynchronizationKind get(int value) {
        switch (value) {
            case 0: {
                return SYNCHRONOUS;
            }
            case 1: {
                return ASYNCHRONOUS;
            }
            case 2: {
                return DELAYED_SYNCHRONOUS;
            }
            case 3: {
                return RENDEZ_VOUS;
            }
            case 4: {
                return OTHER;
            }
        }
        return null;
    }

    private SynchronizationKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

