/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.MARTE.MARTE_DesignModel.HRM.HwLogical.HwComputing.impl;

import java.util.Collection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.papyrus.MARTE.MARTE_DesignModel.HRM.HwLogical.HwComputing.HwBranchPredictor;
import org.eclipse.papyrus.MARTE.MARTE_DesignModel.HRM.HwLogical.HwComputing.HwComputingPackage;
import org.eclipse.papyrus.MARTE.MARTE_DesignModel.HRM.HwLogical.HwComputing.HwISA;
import org.eclipse.papyrus.MARTE.MARTE_DesignModel.HRM.HwLogical.HwComputing.HwProcessor;
import org.eclipse.papyrus.MARTE.MARTE_DesignModel.HRM.HwLogical.HwComputing.impl.HwComputingResourceImpl;
import org.eclipse.papyrus.MARTE.MARTE_DesignModel.HRM.HwLogical.HwStorage.HwMemory.HwCache;
import org.eclipse.papyrus.MARTE.MARTE_DesignModel.HRM.HwLogical.HwStorage.HwStorageManager.HwMMU;
import org.eclipse.papyrus.MARTE.utils.MarteUtils;
import org.eclipse.uml2.uml.Classifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HwProcessorImpl
extends HwComputingResourceImpl
implements HwProcessor {
    protected static final String ARCHITECTURE_EDEFAULT = null;
    protected static final String MIPS_EDEFAULT = null;
    protected String mips = MIPS_EDEFAULT;
    protected static final String IPC_EDEFAULT = null;
    protected static final String NB_CORES_EDEFAULT = null;
    protected String nbCores = NB_CORES_EDEFAULT;
    protected static final String NB_PIPELINES_EDEFAULT = null;
    protected String nbPipelines = NB_PIPELINES_EDEFAULT;
    protected static final String NB_STAGES_EDEFAULT = null;
    protected String nbStages = NB_STAGES_EDEFAULT;
    protected static final String NB_AL_US_EDEFAULT = null;
    protected String nbALUs = NB_AL_US_EDEFAULT;
    protected static final String NB_FP_US_EDEFAULT = null;
    protected String nbFPUs = NB_FP_US_EDEFAULT;
    protected EList<HwISA> ownedISAs;
    protected EList<HwBranchPredictor> predictors;
    protected EList<HwCache> caches;
    protected EList<HwMMU> ownedMMUs;

    protected HwProcessorImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return HwComputingPackage.Literals.HW_PROCESSOR;
    }

    @Override
    public String getArchitecture() {
        Classifier base = null;
        if (this.getBase_Classifier() != null) {
            base = this.getBase_Classifier();
        } else if (this.getBase_ConnectableElement() != null) {
            base = this.getBase_ConnectableElement();
        } else if (this.getBase_InstanceSpecification() != null) {
            base = this.getBase_InstanceSpecification();
        } else if (this.getBase_Lifeline() != null) {
            base = this.getBase_Lifeline();
        } else if (this.getBase_Property() != null) {
            base = this.getBase_Property();
        }
        String archi = null;
        if (base != null) {
            int instWidth = 0;
            for (HwISA currentISA : this.getOwnedISAs()) {
                Integer intWidth;
                String widthTuple = currentISA.getInst_Width();
                if (widthTuple == null || instWidth >= (intWidth = Integer.valueOf(MarteUtils.getValueFromTuple(widthTuple, "value")))) continue;
                instWidth = intWidth;
                String stringUnit = MarteUtils.getValueFromTuple(widthTuple, "unit");
                archi = "{unit=" + stringUnit + ",value=" + String.valueOf(instWidth) + "}";
            }
        }
        return archi;
    }

    @Override
    public void setArchitecture(String newArchitecture) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getMips() {
        return this.mips;
    }

    @Override
    public void setMips(String newMips) {
        String oldMips = this.mips;
        this.mips = newMips;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 18, (Object)oldMips, (Object)this.mips));
        }
    }

    @Override
    public String getIpc() {
        String ipc = null;
        String mipsTuple = this.getMips();
        String frequencyTuple = this.getFrequency();
        if (mipsTuple != null && frequencyTuple != null) {
            int mipsValue = Integer.valueOf(MarteUtils.getValueFromTuple(mipsTuple, "value"));
            float frequencyValue = Float.valueOf(MarteUtils.getValueFromTuple(frequencyTuple, "value")).floatValue();
            String frequencyUnit = MarteUtils.getValueFromTuple(frequencyTuple, "unit");
            long convFactor = 1L;
            if (frequencyUnit.equals("Gz")) {
                convFactor = 1000000000L;
            } else if (frequencyUnit.equals("Mz")) {
                convFactor = 1000000L;
            } else if (frequencyUnit.equals("KHz")) {
                convFactor = 1000L;
            }
            ipc = String.valueOf((float)(mipsValue * 1000000) / ((float)convFactor * frequencyValue));
        }
        return ipc;
    }

    @Override
    public void setIpc(String newIpc) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getNbCores() {
        return this.nbCores;
    }

    @Override
    public void setNbCores(String newNbCores) {
        String oldNbCores = this.nbCores;
        this.nbCores = newNbCores;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 20, (Object)oldNbCores, (Object)this.nbCores));
        }
    }

    @Override
    public String getNbPipelines() {
        return this.nbPipelines;
    }

    @Override
    public void setNbPipelines(String newNbPipelines) {
        String oldNbPipelines = this.nbPipelines;
        this.nbPipelines = newNbPipelines;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 21, (Object)oldNbPipelines, (Object)this.nbPipelines));
        }
    }

    @Override
    public String getNbStages() {
        return this.nbStages;
    }

    @Override
    public void setNbStages(String newNbStages) {
        String oldNbStages = this.nbStages;
        this.nbStages = newNbStages;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 22, (Object)oldNbStages, (Object)this.nbStages));
        }
    }

    @Override
    public String getNbALUs() {
        return this.nbALUs;
    }

    @Override
    public void setNbALUs(String newNbALUs) {
        String oldNbALUs = this.nbALUs;
        this.nbALUs = newNbALUs;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 23, (Object)oldNbALUs, (Object)this.nbALUs));
        }
    }

    @Override
    public String getNbFPUs() {
        return this.nbFPUs;
    }

    @Override
    public void setNbFPUs(String newNbFPUs) {
        String oldNbFPUs = this.nbFPUs;
        this.nbFPUs = newNbFPUs;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 24, (Object)oldNbFPUs, (Object)this.nbFPUs));
        }
    }

    @Override
    public EList<HwISA> getOwnedISAs() {
        if (this.ownedISAs == null) {
            this.ownedISAs = new EObjectResolvingEList(HwISA.class, (InternalEObject)this, 25);
        }
        return this.ownedISAs;
    }

    @Override
    public EList<HwBranchPredictor> getPredictors() {
        if (this.predictors == null) {
            this.predictors = new EObjectResolvingEList(HwBranchPredictor.class, (InternalEObject)this, 26);
        }
        return this.predictors;
    }

    @Override
    public EList<HwCache> getCaches() {
        if (this.caches == null) {
            this.caches = new EObjectResolvingEList(HwCache.class, (InternalEObject)this, 27);
        }
        return this.caches;
    }

    @Override
    public EList<HwMMU> getOwnedMMUs() {
        if (this.ownedMMUs == null) {
            this.ownedMMUs = new EObjectResolvingEList(HwMMU.class, (InternalEObject)this, 28);
        }
        return this.ownedMMUs;
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 17: {
                return this.getArchitecture();
            }
            case 18: {
                return this.getMips();
            }
            case 19: {
                return this.getIpc();
            }
            case 20: {
                return this.getNbCores();
            }
            case 21: {
                return this.getNbPipelines();
            }
            case 22: {
                return this.getNbStages();
            }
            case 23: {
                return this.getNbALUs();
            }
            case 24: {
                return this.getNbFPUs();
            }
            case 25: {
                return this.getOwnedISAs();
            }
            case 26: {
                return this.getPredictors();
            }
            case 27: {
                return this.getCaches();
            }
            case 28: {
                return this.getOwnedMMUs();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 17: {
                this.setArchitecture((String)newValue);
                return;
            }
            case 18: {
                this.setMips((String)newValue);
                return;
            }
            case 19: {
                this.setIpc((String)newValue);
                return;
            }
            case 20: {
                this.setNbCores((String)newValue);
                return;
            }
            case 21: {
                this.setNbPipelines((String)newValue);
                return;
            }
            case 22: {
                this.setNbStages((String)newValue);
                return;
            }
            case 23: {
                this.setNbALUs((String)newValue);
                return;
            }
            case 24: {
                this.setNbFPUs((String)newValue);
                return;
            }
            case 25: {
                this.getOwnedISAs().clear();
                this.getOwnedISAs().addAll((Collection)newValue);
                return;
            }
            case 26: {
                this.getPredictors().clear();
                this.getPredictors().addAll((Collection)newValue);
                return;
            }
            case 27: {
                this.getCaches().clear();
                this.getCaches().addAll((Collection)newValue);
                return;
            }
            case 28: {
                this.getOwnedMMUs().clear();
                this.getOwnedMMUs().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 17: {
                this.setArchitecture(ARCHITECTURE_EDEFAULT);
                return;
            }
            case 18: {
                this.setMips(MIPS_EDEFAULT);
                return;
            }
            case 19: {
                this.setIpc(IPC_EDEFAULT);
                return;
            }
            case 20: {
                this.setNbCores(NB_CORES_EDEFAULT);
                return;
            }
            case 21: {
                this.setNbPipelines(NB_PIPELINES_EDEFAULT);
                return;
            }
            case 22: {
                this.setNbStages(NB_STAGES_EDEFAULT);
                return;
            }
            case 23: {
                this.setNbALUs(NB_AL_US_EDEFAULT);
                return;
            }
            case 24: {
                this.setNbFPUs(NB_FP_US_EDEFAULT);
                return;
            }
            case 25: {
                this.getOwnedISAs().clear();
                return;
            }
            case 26: {
                this.getPredictors().clear();
                return;
            }
            case 27: {
                this.getCaches().clear();
                return;
            }
            case 28: {
                this.getOwnedMMUs().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 17: {
                return ARCHITECTURE_EDEFAULT == null ? this.getArchitecture() != null : !ARCHITECTURE_EDEFAULT.equals(this.getArchitecture());
            }
            case 18: {
                return MIPS_EDEFAULT == null ? this.mips != null : !MIPS_EDEFAULT.equals(this.mips);
            }
            case 19: {
                return IPC_EDEFAULT == null ? this.getIpc() != null : !IPC_EDEFAULT.equals(this.getIpc());
            }
            case 20: {
                return NB_CORES_EDEFAULT == null ? this.nbCores != null : !NB_CORES_EDEFAULT.equals(this.nbCores);
            }
            case 21: {
                return NB_PIPELINES_EDEFAULT == null ? this.nbPipelines != null : !NB_PIPELINES_EDEFAULT.equals(this.nbPipelines);
            }
            case 22: {
                return NB_STAGES_EDEFAULT == null ? this.nbStages != null : !NB_STAGES_EDEFAULT.equals(this.nbStages);
            }
            case 23: {
                return NB_AL_US_EDEFAULT == null ? this.nbALUs != null : !NB_AL_US_EDEFAULT.equals(this.nbALUs);
            }
            case 24: {
                return NB_FP_US_EDEFAULT == null ? this.nbFPUs != null : !NB_FP_US_EDEFAULT.equals(this.nbFPUs);
            }
            case 25: {
                return this.ownedISAs != null && !this.ownedISAs.isEmpty();
            }
            case 26: {
                return this.predictors != null && !this.predictors.isEmpty();
            }
            case 27: {
                return this.caches != null && !this.caches.isEmpty();
            }
            case 28: {
                return this.ownedMMUs != null && !this.ownedMMUs.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (mips: ");
        result.append(this.mips);
        result.append(", nbCores: ");
        result.append(this.nbCores);
        result.append(", nbPipelines: ");
        result.append(this.nbPipelines);
        result.append(", nbStages: ");
        result.append(this.nbStages);
        result.append(", nbALUs: ");
        result.append(this.nbALUs);
        result.append(", nbFPUs: ");
        result.append(this.nbFPUs);
        result.append(')');
        return result.toString();
    }
}

