/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.MARTE.MARTE_DesignModel.HRM.HwLogical.HwStorage.HwMemory;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ROM_Type implements Enumerator
{
    MASKED_ROM(0, "maskedROM", "maskedROM"),
    EPROM(1, "EPROM", "EPROM"),
    OTP_EPROM(2, "OTP_EPROM", "OTP_EPROM"),
    EEPROM(3, "EEPROM", "EEPROM"),
    FLASH(4, "Flash", "Flash"),
    OTHER(5, "other", "other"),
    UNDEF(6, "undef", "undef");

    public static final int MASKED_ROM_VALUE = 0;
    public static final int EPROM_VALUE = 1;
    public static final int OTP_EPROM_VALUE = 2;
    public static final int EEPROM_VALUE = 3;
    public static final int FLASH_VALUE = 4;
    public static final int OTHER_VALUE = 5;
    public static final int UNDEF_VALUE = 6;
    private static final ROM_Type[] VALUES_ARRAY;
    public static final List<ROM_Type> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ROM_Type[]{MASKED_ROM, EPROM, OTP_EPROM, EEPROM, FLASH, OTHER, UNDEF};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ROM_Type get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ROM_Type result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ROM_Type getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ROM_Type result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ROM_Type get(int value) {
        switch (value) {
            case 0: {
                return MASKED_ROM;
            }
            case 1: {
                return EPROM;
            }
            case 2: {
                return OTP_EPROM;
            }
            case 3: {
                return EEPROM;
            }
            case 4: {
                return FLASH;
            }
            case 5: {
                return OTHER;
            }
            case 6: {
                return UNDEF;
            }
        }
        return null;
    }

    private ROM_Type(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

