/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.MARTE.MARTE_DesignModel.HRM.HwPhysical.HwLayout;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ComponentState implements Enumerator
{
    OPERATING(0, "operating", "operating"),
    STORAGE(1, "storage", "storage"),
    OTHER(2, "other", "other"),
    UNDEF(3, "undef", "undef");

    public static final int OPERATING_VALUE = 0;
    public static final int STORAGE_VALUE = 1;
    public static final int OTHER_VALUE = 2;
    public static final int UNDEF_VALUE = 3;
    private static final ComponentState[] VALUES_ARRAY;
    public static final List<ComponentState> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ComponentState[]{OPERATING, STORAGE, OTHER, UNDEF};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ComponentState get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ComponentState result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ComponentState getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ComponentState result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ComponentState get(int value) {
        switch (value) {
            case 0: {
                return OPERATING;
            }
            case 1: {
                return STORAGE;
            }
            case 2: {
                return OTHER;
            }
            case 3: {
                return UNDEF;
            }
        }
        return null;
    }

    private ComponentState(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

