/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.MARTE.MARTE_DesignModel.SRM.SW_Brokering;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum AccessPolicyKind implements Enumerator
{
    READ(0, "Read", "Read"),
    WRITE(1, "Write", "Write"),
    READ_WRITE(2, "ReadWrite", "ReadWrite"),
    UNDEF(3, "Undef", "Undef"),
    OTHER(4, "Other", "Other");

    public static final int READ_VALUE = 0;
    public static final int WRITE_VALUE = 1;
    public static final int READ_WRITE_VALUE = 2;
    public static final int UNDEF_VALUE = 3;
    public static final int OTHER_VALUE = 4;
    private static final AccessPolicyKind[] VALUES_ARRAY;
    public static final List<AccessPolicyKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new AccessPolicyKind[]{READ, WRITE, READ_WRITE, UNDEF, OTHER};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static AccessPolicyKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AccessPolicyKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AccessPolicyKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AccessPolicyKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AccessPolicyKind get(int value) {
        switch (value) {
            case 0: {
                return READ;
            }
            case 1: {
                return WRITE;
            }
            case 2: {
                return READ_WRITE;
            }
            case 3: {
                return UNDEF;
            }
            case 4: {
                return OTHER;
            }
        }
        return null;
    }

    private AccessPolicyKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

