/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.MARTE.MARTE_DesignModel.SRM.SW_Interaction;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum NotificationResourceKind implements Enumerator
{
    EVENT(0, "Event", "Event"),
    BARRIER(1, "Barrier", "Barrier"),
    UNDEF(2, "Undef", "Undef"),
    OTHER(3, "Other", "Other");

    public static final int EVENT_VALUE = 0;
    public static final int BARRIER_VALUE = 1;
    public static final int UNDEF_VALUE = 2;
    public static final int OTHER_VALUE = 3;
    private static final NotificationResourceKind[] VALUES_ARRAY;
    public static final List<NotificationResourceKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new NotificationResourceKind[]{EVENT, BARRIER, UNDEF, OTHER};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static NotificationResourceKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            NotificationResourceKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static NotificationResourceKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            NotificationResourceKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static NotificationResourceKind get(int value) {
        switch (value) {
            case 0: {
                return EVENT;
            }
            case 1: {
                return BARRIER;
            }
            case 2: {
                return UNDEF;
            }
            case 3: {
                return OTHER;
            }
        }
        return null;
    }

    private NotificationResourceKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

