/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.MARTE_Library.BasicNFP_Types;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum SourceKind implements Enumerator
{
    EST(0, "est", "est"),
    MEAS(1, "meas", "meas"),
    CALC(2, "calc", "calc"),
    REQ(3, "req", "req");

    public static final int EST_VALUE = 0;
    public static final int MEAS_VALUE = 1;
    public static final int CALC_VALUE = 2;
    public static final int REQ_VALUE = 3;
    private static final SourceKind[] VALUES_ARRAY;
    public static final List<SourceKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new SourceKind[]{EST, MEAS, CALC, REQ};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static SourceKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SourceKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SourceKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SourceKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SourceKind get(int value) {
        switch (value) {
            case 0: {
                return EST;
            }
            case 1: {
                return MEAS;
            }
            case 2: {
                return CALC;
            }
            case 3: {
                return REQ;
            }
        }
        return null;
    }

    private SourceKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

