/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.MARTE_Library.GRM_BasicTypes;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum SchedPolicyKind implements Enumerator
{
    EARLIEST_DEADLINE_FIRST(0, "EarliestDeadlineFirst", "EarliestDeadlineFirst"),
    FIFO(1, "FIFO", "FIFO"),
    FIXED_PRIORITY(2, "FixedPriority", "FixedPriority"),
    LEAST_LAXITY_FIRST(3, "LeastLaxityFirst", "LeastLaxityFirst"),
    ROUND_ROBIN(4, "RoundRobin", "RoundRobin"),
    TIME_TABLE_DRIVEN(5, "TimeTableDriven", "TimeTableDriven"),
    UNDEF(6, "Undef", "Undef"),
    OTHER(7, "Other", "Other");

    public static final int EARLIEST_DEADLINE_FIRST_VALUE = 0;
    public static final int FIFO_VALUE = 1;
    public static final int FIXED_PRIORITY_VALUE = 2;
    public static final int LEAST_LAXITY_FIRST_VALUE = 3;
    public static final int ROUND_ROBIN_VALUE = 4;
    public static final int TIME_TABLE_DRIVEN_VALUE = 5;
    public static final int UNDEF_VALUE = 6;
    public static final int OTHER_VALUE = 7;
    private static final SchedPolicyKind[] VALUES_ARRAY;
    public static final List<SchedPolicyKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new SchedPolicyKind[]{EARLIEST_DEADLINE_FIRST, FIFO, FIXED_PRIORITY, LEAST_LAXITY_FIRST, ROUND_ROBIN, TIME_TABLE_DRIVEN, UNDEF, OTHER};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static SchedPolicyKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SchedPolicyKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SchedPolicyKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SchedPolicyKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SchedPolicyKind get(int value) {
        switch (value) {
            case 0: {
                return EARLIEST_DEADLINE_FIRST;
            }
            case 1: {
                return FIFO;
            }
            case 2: {
                return FIXED_PRIORITY;
            }
            case 3: {
                return LEAST_LAXITY_FIRST;
            }
            case 4: {
                return ROUND_ROBIN;
            }
            case 5: {
                return TIME_TABLE_DRIVEN;
            }
            case 6: {
                return UNDEF;
            }
            case 7: {
                return OTHER;
            }
        }
        return null;
    }

    private SchedPolicyKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

