/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.MARTE_Library.MeasurementUnits;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum EnergyUnitKind implements Enumerator
{
    J(0, "J", "J"),
    KJ(1, "KJ", "KJ"),
    WH(2, "Wh", "Wh"),
    KWH(3, "KWh", "KWh"),
    MWH(4, "mWh", "mWh");

    public static final int J_VALUE = 0;
    public static final int KJ_VALUE = 1;
    public static final int WH_VALUE = 2;
    public static final int KWH_VALUE = 3;
    public static final int MWH_VALUE = 4;
    private static final EnergyUnitKind[] VALUES_ARRAY;
    public static final List<EnergyUnitKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new EnergyUnitKind[]{J, KJ, WH, KWH, MWH};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static EnergyUnitKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            EnergyUnitKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static EnergyUnitKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            EnergyUnitKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static EnergyUnitKind get(int value) {
        switch (value) {
            case 0: {
                return J;
            }
            case 1: {
                return KJ;
            }
            case 2: {
                return WH;
            }
            case 3: {
                return KWH;
            }
            case 4: {
                return MWH;
            }
        }
        return null;
    }

    private EnergyUnitKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

