/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.MARTE_Library.MeasurementUnits;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum FrequencyUnitKind implements Enumerator
{
    HZ(0, "Hz", "Hz"),
    KHZ(1, "KHz", "KHz"),
    MHZ(2, "MHz", "MHz"),
    GHZ(3, "GHz", "GHz"),
    RPM(4, "rpm", "rpm");

    public static final int HZ_VALUE = 0;
    public static final int KHZ_VALUE = 1;
    public static final int MHZ_VALUE = 2;
    public static final int GHZ_VALUE = 3;
    public static final int RPM_VALUE = 4;
    private static final FrequencyUnitKind[] VALUES_ARRAY;
    public static final List<FrequencyUnitKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new FrequencyUnitKind[]{HZ, KHZ, MHZ, GHZ, RPM};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static FrequencyUnitKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            FrequencyUnitKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static FrequencyUnitKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            FrequencyUnitKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static FrequencyUnitKind get(int value) {
        switch (value) {
            case 0: {
                return HZ;
            }
            case 1: {
                return KHZ;
            }
            case 2: {
                return MHZ;
            }
            case 3: {
                return GHZ;
            }
            case 4: {
                return RPM;
            }
        }
        return null;
    }

    private FrequencyUnitKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

