/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.MARTE_Library.MeasurementUnits;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum PowerUnitKind implements Enumerator
{
    W(0, "W", "W"),
    MW(1, "mW", "mW"),
    KW(2, "KW", "KW");

    public static final int W_VALUE = 0;
    public static final int MW_VALUE = 1;
    public static final int KW_VALUE = 2;
    private static final PowerUnitKind[] VALUES_ARRAY;
    public static final List<PowerUnitKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new PowerUnitKind[]{W, MW, KW};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static PowerUnitKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PowerUnitKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PowerUnitKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PowerUnitKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PowerUnitKind get(int value) {
        switch (value) {
            case 0: {
                return W;
            }
            case 1: {
                return MW;
            }
            case 2: {
                return KW;
            }
        }
        return null;
    }

    private PowerUnitKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

