/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.MARTE_Library.MeasurementUnits;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum TimeUnitKind implements Enumerator
{
    S(0, "s", "s"),
    TICK(1, "tick", "tick"),
    MS(2, "ms", "ms"),
    US(3, "us", "us"),
    MIN(4, "min", "min"),
    HRS(5, "hrs", "hrs"),
    DAY(6, "day", "day");

    public static final int S_VALUE = 0;
    public static final int TICK_VALUE = 1;
    public static final int MS_VALUE = 2;
    public static final int US_VALUE = 3;
    public static final int MIN_VALUE = 4;
    public static final int HRS_VALUE = 5;
    public static final int DAY_VALUE = 6;
    private static final TimeUnitKind[] VALUES_ARRAY;
    public static final List<TimeUnitKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new TimeUnitKind[]{S, TICK, MS, US, MIN, HRS, DAY};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static TimeUnitKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TimeUnitKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TimeUnitKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TimeUnitKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TimeUnitKind get(int value) {
        switch (value) {
            case 0: {
                return S;
            }
            case 1: {
                return TICK;
            }
            case 2: {
                return MS;
            }
            case 3: {
                return US;
            }
            case 4: {
                return MIN;
            }
            case 5: {
                return HRS;
            }
            case 6: {
                return DAY;
            }
        }
        return null;
    }

    private TimeUnitKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

