/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.MARTE_Library.TimeLibrary.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.papyrus.MARTE_Library.TimeLibrary.IdealClock;
import org.eclipse.papyrus.MARTE_Library.TimeLibrary.LogicalTimeUnit;
import org.eclipse.papyrus.MARTE_Library.TimeLibrary.TimeLibraryFactory;
import org.eclipse.papyrus.MARTE_Library.TimeLibrary.TimeLibraryPackage;
import org.eclipse.papyrus.MARTE_Library.TimeLibrary.TimeUnitKind;
import org.eclipse.papyrus.MARTE_Library.TimeLibrary.impl.IdealClockImpl;

public class TimeLibraryFactoryImpl
extends EFactoryImpl
implements TimeLibraryFactory {
    public static TimeLibraryFactory init() {
        try {
            TimeLibraryFactory theTimeLibraryFactory = (TimeLibraryFactory)EPackage.Registry.INSTANCE.getEFactory("http:///MARTE_Library/TimeLibrary.ecore");
            if (theTimeLibraryFactory != null) {
                return theTimeLibraryFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new TimeLibraryFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createIdealClock();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 1: {
                return this.createTimeUnitKindFromString(eDataType, initialValue);
            }
            case 2: {
                return this.createLogicalTimeUnitFromString(eDataType, initialValue);
            }
            case 3: {
                return this.createTimedValueTypeFromString(eDataType, initialValue);
            }
            case 4: {
                return this.createClockedValueSpecificationFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 1: {
                return this.convertTimeUnitKindToString(eDataType, instanceValue);
            }
            case 2: {
                return this.convertLogicalTimeUnitToString(eDataType, instanceValue);
            }
            case 3: {
                return this.convertTimedValueTypeToString(eDataType, instanceValue);
            }
            case 4: {
                return this.convertClockedValueSpecificationToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public IdealClock createIdealClock() {
        IdealClockImpl idealClock = new IdealClockImpl();
        return idealClock;
    }

    public TimeUnitKind createTimeUnitKindFromString(EDataType eDataType, String initialValue) {
        TimeUnitKind result = TimeUnitKind.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertTimeUnitKindToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public LogicalTimeUnit createLogicalTimeUnitFromString(EDataType eDataType, String initialValue) {
        LogicalTimeUnit result = LogicalTimeUnit.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertLogicalTimeUnitToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public String createTimedValueTypeFromString(EDataType eDataType, String initialValue) {
        return (String)super.createFromString(eDataType, initialValue);
    }

    public String convertTimedValueTypeToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(eDataType, instanceValue);
    }

    public String createClockedValueSpecificationFromString(EDataType eDataType, String initialValue) {
        return (String)super.createFromString(eDataType, initialValue);
    }

    public String convertClockedValueSpecificationToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(eDataType, instanceValue);
    }

    public TimeLibraryPackage getTimeLibraryPackage() {
        return (TimeLibraryPackage)this.getEPackage();
    }

    @Deprecated
    public static TimeLibraryPackage getPackage() {
        return TimeLibraryPackage.eINSTANCE;
    }
}

