/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.MARTE_Library.TimeTypesLibrary;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum EventKind implements Enumerator
{
    START(0, "start", "start"),
    FINISH(1, "finish", "finish"),
    SEND(2, "send", "send"),
    RECEIVE(3, "receive", "receive"),
    CONSUME(4, "consume", "consume");

    public static final int START_VALUE = 0;
    public static final int FINISH_VALUE = 1;
    public static final int SEND_VALUE = 2;
    public static final int RECEIVE_VALUE = 3;
    public static final int CONSUME_VALUE = 4;
    private static final EventKind[] VALUES_ARRAY;
    public static final List<EventKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new EventKind[]{START, FINISH, SEND, RECEIVE, CONSUME};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static EventKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            EventKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static EventKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            EventKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static EventKind get(int value) {
        switch (value) {
            case 0: {
                return START;
            }
            case 1: {
                return FINISH;
            }
            case 2: {
                return SEND;
            }
            case 3: {
                return RECEIVE;
            }
            case 4: {
                return CONSUME;
            }
        }
        return null;
    }

    private EventKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

