/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.compare.file.editor;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.ObjectUndoContext;
import org.eclipse.core.commands.operations.OperationHistoryEvent;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.diff.metamodel.ComparisonResourceSetSnapshot;
import org.eclipse.emf.compare.diff.metamodel.ComparisonResourceSnapshot;
import org.eclipse.emf.compare.diff.metamodel.ComparisonSnapshot;
import org.eclipse.emf.compare.diff.metamodel.DiffModel;
import org.eclipse.emf.compare.match.metamodel.MatchModel;
import org.eclipse.emf.compare.ui.ModelCompareInput;
import org.eclipse.emf.compare.ui.editor.ModelCompareEditorInput;
import org.eclipse.emf.compare.ui.viewer.structure.ModelStructureMergeViewer;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.IWorkspaceCommandStack;
import org.eclipse.emf.workspace.ResourceUndoContext;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.core.resource.ModelMultiException;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServiceMultiException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.emf.compare.common.editor.AbstractPapyrusCompareEditor;
import org.eclipse.papyrus.infra.emf.compare.common.utils.PapyrusModelCompareEditorInput;
import org.eclipse.papyrus.uml.compare.diff.services.UMLDiffService;
import org.eclipse.papyrus.uml.compare.diff.services.standalone.StandaloneMergeUtils;
import org.eclipse.papyrus.uml.compare.diff.services.standalone.UMLStandaloneMatchEngine;
import org.eclipse.papyrus.uml.compare.file.Activator;
import org.eclipse.papyrus.uml.compare.file.editor.PapyrusModelCompareInput;
import org.eclipse.papyrus.uml.compare.file.editor.utils.ServicesRegistryUtils;
import org.eclipse.papyrus.uml.compare.file.handler.CompareUMLFileInput;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.uml2.common.util.UML2Util;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.UMLPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompareUMLFileEditor
extends AbstractPapyrusCompareEditor {
    public static final String COMPARE_UML_FILE_EDITOR_ID = "org.eclipse.papyrus.uml.compare.file.editor";
    private final TransactionalEditingDomain editingDomain;
    private ModelSet set;
    private final ObjectUndoContext undoContext;
    private final IOperationHistoryListener historyListener;
    private EObject[] roots = new EObject[2];
    private CompareUMLFileInput tmpInput;
    private ServicesRegistry servicesRegistry = this.getServicesRegistry();

    public CompareUMLFileEditor() {
        try {
            this.set = (ModelSet)this.servicesRegistry.getService(ModelSet.class);
        }
        catch (ServiceException e) {
            Activator.log.error((Throwable)e);
        }
        this.editingDomain = this.set.getTransactionalEditingDomain();
        this.undoContext = new ObjectUndoContext((Object)this, "PayrusUMLFileCompareUndoContext");
        this.historyListener = new IOperationHistoryListener(){

            public void historyNotification(OperationHistoryEvent event) {
                Set affectedResources;
                if (event.getEventType() == 4 && CompareUMLFileEditor.this.isConcerned(Collections.unmodifiableSet(affectedResources = ResourceUndoContext.getAffectedResources((IUndoableOperation)event.getOperation())))) {
                    IUndoableOperation operation = event.getOperation();
                    operation.removeContext(((IWorkspaceCommandStack)CompareUMLFileEditor.this.getEditingDomain().getCommandStack()).getDefaultUndoContext());
                    operation.addContext((IUndoContext)CompareUMLFileEditor.this.undoContext);
                    CompareUMLFileEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            CompareUMLFileEditor.this.firePropertyChange(257);
                        }
                    });
                }
            }
        };
        this.getOperationHistory().addOperationHistoryListener(this.historyListener);
        this.addUndoRedoListeners();
    }

    public void doSave(IProgressMonitor progressMonitor) {
        super.doSave(progressMonitor);
    }

    private boolean isConcerned(Set affectedResources) {
        Iterator iter = affectedResources.iterator();
        while (iter.hasNext()) {
            if (!this.set.getResources().contains(iter.next())) continue;
            return true;
        }
        return false;
    }

    private IOperationHistory getOperationHistory() {
        CommandStack commandStack;
        if (this.editingDomain != null && (commandStack = this.editingDomain.getCommandStack()) instanceof IWorkspaceCommandStack) {
            return ((IWorkspaceCommandStack)commandStack).getOperationHistory();
        }
        return null;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (input instanceof CompareUMLFileInput) {
            this.tmpInput = (CompareUMLFileInput)input;
            List<IFile> files = ((CompareUMLFileInput)input).getComparedFiles();
            int i = 0;
            while (i < files.size()) {
                IFile current = files.get(i);
                try {
                    this.set.loadModels(current);
                    String filePath = current.getFullPath().toString();
                    URI uri = URI.createPlatformResourceURI((String)filePath, (boolean)false);
                    Package root = (Package)UML2Util.load((ResourceSet)this.set, (URI)uri, (EClass)UMLPackage.Literals.PACKAGE);
                    Assert.isNotNull((Object)root, (String)"The root of the model is null");
                    this.roots[i] = root;
                }
                catch (ModelMultiException e1) {
                    Activator.log.error(NLS.bind((String)"Problem for loading the file {0}", (Object)current), (Throwable)e1);
                }
                ++i;
            }
            ModelCompareEditorInput newInput = this.getCompareInput(this.roots[0], this.roots[1]);
            this.tmpInput = null;
            super.init(site, (IEditorInput)newInput);
        } else {
            super.init(site, input);
        }
    }

    protected ModelCompareEditorInput createModelCompareEditorInput(ComparisonSnapshot snapshot) {
        return new PapyrusModelCompareEditorInput(snapshot, (IEditorPart)this){

            public Image getTitleImage() {
                return AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.papyrus.uml.compare.file", (String)"/icons/papyrus_compare_editor.gif").createImage();
            }

            protected ModelCompareInput createModelCompareInput(ComparisonSnapshot snap) {
                if (snap instanceof ComparisonResourceSetSnapshot) {
                    return new PapyrusModelCompareInput(((ComparisonResourceSetSnapshot)snap).getMatchResourceSet(), ((ComparisonResourceSetSnapshot)snap).getDiffResourceSet(), CompareUMLFileEditor.this.editingDomain);
                }
                return new PapyrusModelCompareInput(((ComparisonResourceSnapshot)snap).getMatch(), ((ComparisonResourceSnapshot)snap).getDiff(), CompareUMLFileEditor.this.editingDomain);
            }
        };
    }

    protected void configureInput(PapyrusModelCompareEditorInput input) {
        if (this.tmpInput != null) {
            String leftLabel = this.tmpInput.getComparedFiles().get(0).getFullPath().makeRelative().toString();
            String rightLabel = this.tmpInput.getComparedFiles().get(1).getFullPath().makeRelative().toString();
            Image im = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.papyrus.uml.compare.file", (String)"/icons/UMLModelFile.gif").createImage();
            input.initLabels(leftLabel, im, rightLabel, im);
        }
        CompareConfiguration cc = input.getCompareConfiguration();
        Map<String, Object> options = this.getCompareOptions(null, null, null);
        Boolean leftToRight = (Boolean)options.get("allow_merge_left_to_right");
        Boolean rightToLeft = (Boolean)options.get("allow_merge_right_to_left");
        if (rightToLeft != null) {
            cc.setLeftEditable(rightToLeft.booleanValue());
        }
        if (leftToRight != null) {
            cc.setRightEditable(leftToRight.booleanValue());
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(IUndoContext.class)) {
            return this.undoContext;
        }
        if (adapter.equals(TransactionalEditingDomain.class)) {
            try {
                this.servicesRegistry.getService(adapter);
            }
            catch (ServiceException e) {
                Activator.log.error((Throwable)e);
            }
        }
        return super.getAdapter(adapter);
    }

    public TransactionalEditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public void dispose() {
        this.getOperationHistory().removeOperationHistoryListener(this.historyListener);
        this.removeUndoRedoListener();
        if (this.servicesRegistry != null) {
            try {
                this.servicesRegistry.disposeRegistry();
            }
            catch (ServiceMultiException e) {
                org.eclipse.papyrus.infra.core.Activator.log.error((Throwable)e);
            }
        }
        super.dispose();
    }

    protected IOperationHistory getIOperationHistory() {
        return this.getOperationHistory();
    }

    protected void resetInput() {
        IEditorInput input = this.getEditorInput();
        assert (input instanceof PapyrusModelCompareEditorInput);
        ModelStructureMergeViewer viewer = ((PapyrusModelCompareEditorInput)input).getStructureMergeViewer();
        PapyrusModelCompareEditorInput newInput = (PapyrusModelCompareEditorInput)this.getCompareInput(this.roots[0], this.roots[1]);
        ModelCompareInput input2 = newInput.getpreparedModelCompareInput();
        viewer.setInput((Object)input2);
    }

    public ServicesRegistry getServicesRegistry() {
        if (this.servicesRegistry == null) {
            this.servicesRegistry = ServicesRegistryUtils.createAndInitServiceRegistryForUMLCompareFile();
        }
        return this.servicesRegistry;
    }

    protected DiffModel doDiff(MatchModel match, Map<String, Object> options) {
        return UMLDiffService.doDiff((MatchModel)match, (boolean)false, options);
    }

    protected MatchModel doMatch(IProgressMonitor monitor, EObject left, EObject right, Map<String, Object> options) throws InterruptedException {
        UMLStandaloneMatchEngine engine = new UMLStandaloneMatchEngine();
        return engine.resourceMatch(left.eResource(), right.eResource(), options);
    }

    protected Map<String, Object> getCompareOptions(IProgressMonitor monitor, EObject left, EObject right) {
        return StandaloneMergeUtils.getMergeOptions((IProgressMonitor)monitor, (EObject)left, (EObject)right);
    }
}

