/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.compare.file.handler;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.uml.compare.file.Activator;
import org.eclipse.papyrus.uml.compare.file.handler.CompareUMLFileInput;
import org.eclipse.papyrus.uml.compare.file.messages.Messages;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompareUMLFileHandler
extends AbstractHandler
implements IObjectActionDelegate {
    public static final String UML_EXTENSION = "uml";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        List<IFile> selectedFiles = this.getSelection();
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        CompareUMLFileInput input = new CompareUMLFileInput(selectedFiles);
        try {
            page.openEditor((IEditorInput)input, "org.eclipse.papyrus.uml.compare.file.editor", true);
        }
        catch (PartInitException e) {
            Activator.log.error(Messages.CompareUMLFileHandler_ICantOpenThePapyrusCompareEdito, (Throwable)e);
        }
        return null;
    }

    protected List<IFile> getSelection() {
        ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
        ArrayList<IFile> currentSelection = new ArrayList<IFile>();
        for (Object current : (IStructuredSelection)selection) {
            IFile file;
            if (!(current instanceof IAdaptable) || (file = (IFile)((IAdaptable)current).getAdapter(IFile.class)) == null) continue;
            currentSelection.add(file);
        }
        return currentSelection;
    }

    public boolean isEnabled() {
        List<IFile> selectedElement = this.getSelection();
        if (selectedElement.size() != 2) {
            return false;
        }
        for (IFile current : selectedElement) {
            String extension;
            if (!(current instanceof IFile) || (extension = current.getFileExtension()).equals(UML_EXTENSION)) continue;
            return false;
        }
        return super.isEnabled();
    }

    public void run(IAction action) {
        if (this.isEnabled()) {
            try {
                this.execute(new ExecutionEvent());
            }
            catch (ExecutionException e) {
                Activator.log.error((Throwable)e);
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }
}

