/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.menu.actions;

import java.util.List;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.papyrus.uml.diagram.common.util.Util;
import org.eclipse.papyrus.uml.diagram.menu.actions.AbstractDistributeAction;
import org.eclipse.papyrus.uml.diagram.menu.actions.DistributeAffixedChildNodeLinkAction;
import org.eclipse.papyrus.uml.diagram.menu.actions.DistributeNodeAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DistributeLinkNodeAction {
    private int distribution;
    private List<IGraphicalEditPart> selectedElements;

    public DistributeLinkNodeAction(String parameter, List<IGraphicalEditPart> selectedElements) {
        this.selectedElements = selectedElements;
        this.distribution = this.getDistributionValue(parameter);
    }

    protected int getDistributionValue(String param) {
        if (param.equals("parameter_horizontally")) {
            return 64;
        }
        if (param.equals("parameter_horizontally_between_nodes")) {
            return 66;
        }
        if (param.equals("parameter_vertically")) {
            return 128;
        }
        if (param.equals("parameter_vertically_between_nodes")) {
            return 144;
        }
        return 0;
    }

    public Command getCommand() {
        UnexecutableCommand command = null;
        int selectionType = this.getSelectionType(this.selectedElements);
        switch (selectionType) {
            case 1: {
                DistributeAffixedChildNodeLinkAction action = new DistributeAffixedChildNodeLinkAction(this.distribution, this.selectedElements);
                command = ((AbstractDistributeAction)action).getCommand();
                break;
            }
            case 2: {
                DistributeNodeAction action = new DistributeNodeAction(this.distribution, this.selectedElements);
                command = ((AbstractDistributeAction)action).getCommand();
                break;
            }
            case 3: {
                command = UnexecutableCommand.INSTANCE;
                break;
            }
        }
        return command != null ? command : UnexecutableCommand.INSTANCE;
    }

    private int getSelectionType(List<IGraphicalEditPart> selectedElements) {
        boolean affixedChildNodeAndLink = false;
        boolean otherElement = false;
        boolean badSelection = false;
        for (IGraphicalEditPart current : selectedElements) {
            if (current instanceof DiagramEditPart) {
                badSelection = true;
                continue;
            }
            if (current instanceof ConnectionEditPart) {
                affixedChildNodeAndLink = true;
                continue;
            }
            if (Util.isAffixedChildNode((EditPart)current)) {
                affixedChildNodeAndLink = true;
                continue;
            }
            otherElement = true;
        }
        if (badSelection) {
            return 3;
        }
        if (otherElement != affixedChildNodeAndLink) {
            if (affixedChildNodeAndLink) {
                return 1;
            }
            if (otherElement) {
                return 2;
            }
        } else {
            return 1;
        }
        return 3;
    }
}

