/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.menu.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.ui.util.DisplayUtils;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IResizableCompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.services.editpart.EditPartService;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.Style;
import org.eclipse.gmf.runtime.notation.TitleStyle;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.papyrus.uml.diagram.common.actions.AbstractShowHideAction;
import org.eclipse.papyrus.uml.diagram.common.commands.ShowHideCompartmentRequest;
import org.eclipse.papyrus.uml.diagram.common.commands.ShowHideTitleOfCompartmentCommand;
import org.eclipse.papyrus.uml.diagram.common.util.CompartmentUtils;
import org.eclipse.papyrus.uml.diagram.common.util.DiagramEditPartsUtil;
import org.eclipse.papyrus.uml.diagram.common.util.ViewServiceUtil;
import org.eclipse.papyrus.uml.diagram.menu.dialogs.ShowHideCompartmentSelectionDialog;
import org.eclipse.papyrus.uml.diagram.menu.messages.Messages;
import org.eclipse.ui.dialogs.SelectionDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShowHideCompartmentAction
extends AbstractShowHideAction {
    protected List<CompartmentEditPartRepresentation> visibleTitle;
    protected List<CompartmentEditPartRepresentation> visibleRepresentations;

    public ShowHideCompartmentAction() {
        super(Messages.ShowHideCompartmentAction_Title, Messages.ShowHideCompartmentAction_Messages, "Show/Hide Compartment Policy");
    }

    protected SelectionDialog getSelectionDialog() {
        ShowHideCompartmentSelectionDialog selectionDialog = new ShowHideCompartmentSelectionDialog(DisplayUtils.getDisplay().getActiveShell(), this.getEditorLabelProvider(), this.getContentProvider());
        selectionDialog.setTitle(Messages.ShowHideCompartmentAction_Title);
        selectionDialog.setMessage(Messages.ShowHideCompartmentAction_Messages);
        selectionDialog.setContainerMode(true);
        selectionDialog.setInput(this.getInput());
        selectionDialog.setExpandedElements(this.selectedElements.toArray());
        selectionDialog.setInitialElementSelections(this.getInitialSelection());
        return selectionDialog;
    }

    /*
     * WARNING - void declaration
     */
    protected void buildShowHideElementsList(Object[] results) {
        void var3_4;
        super.buildShowHideElementsList(results);
        ArrayList<Object> result = new ArrayList<Object>();
        boolean bl = false;
        while (var3_4 < results.length) {
            if (!(results[var3_4] instanceof EditPart)) {
                result.add(results[var3_4]);
            }
            ++var3_4;
        }
        for (Object e : result) {
            if (this.initialSelection.contains(e) || !(e instanceof AbstractShowHideAction.EditPartRepresentation)) continue;
            this.viewsToCreate.add((AbstractShowHideAction.EditPartRepresentation)e);
        }
        for (Object e : this.initialSelection) {
            if (result.contains(e) || !(e instanceof AbstractShowHideAction.EditPartRepresentation)) continue;
            this.viewsToDestroy.add((AbstractShowHideAction.EditPartRepresentation)e);
        }
        for (Object e : result) {
            if (!(e instanceof CompartmentEditPartRepresentation)) continue;
            this.visibleRepresentations.add((CompartmentEditPartRepresentation)((Object)e));
        }
    }

    protected void initAction() {
        super.initAction();
        this.visibleRepresentations = new ArrayList<CompartmentEditPartRepresentation>();
        for (IGraphicalEditPart current : this.selectedElements) {
            if (((View)current.getModel()).getElement() == null) continue;
            this.representations.add(new RootEditPartRepresentation(current, ((View)current.getModel()).getElement()));
        }
        this.setContentProvider(new ContentProvider());
    }

    protected List<Object> getInput() {
        return new ArrayList<Object>(this.representations);
    }

    protected Command getActionCommand() {
        IGraphicalEditPart parentEditPart;
        View currentView;
        CompartmentEditPartRepresentation currentRepresentation;
        ViewServiceUtil.forceLoad();
        ShowHideCompartmentRequest req = null;
        CompoundCommand completeCmd = new CompoundCommand("Destroy and Create Compartment Command");
        for (AbstractShowHideAction.EditPartRepresentation current : this.viewsToDestroy) {
            if (!(current instanceof CompartmentEditPartRepresentation)) continue;
            currentRepresentation = (CompartmentEditPartRepresentation)current;
            currentView = currentRepresentation.getCompartmentView();
            IResizableCompartmentEditPart currentEditPart = currentRepresentation.getRepresentedEditPart();
            if (currentEditPart == null) {
                Activator.log.debug("Warning! An edit part representation wished to destroy a view, but no edit part exists currently!" + current);
                currentEditPart = DiagramEditPartsUtil.getEditPartFromView((View)currentView, (EditPart)((EditPart)this.selectedElements.get(0))).getParent();
            }
            if (currentEditPart != null) {
                req = new ShowHideCompartmentRequest((Object)false, currentView);
                req.setType((Object)"Show/Hide Compartment");
                Command tmp = currentEditPart.getCommand((Request)req);
                if (tmp == null || !tmp.canExecute()) continue;
                completeCmd.add(tmp);
                continue;
            }
            Activator.log.debug("Impossible to find an edit part for the given representation: " + current);
        }
        for (AbstractShowHideAction.EditPartRepresentation current : this.viewsToCreate) {
            if (!(current instanceof CompartmentEditPartRepresentation)) continue;
            currentRepresentation = (CompartmentEditPartRepresentation)current;
            currentView = currentRepresentation.getCompartmentView();
            AbstractShowHideAction.EditPartRepresentation parentRepresentation = currentRepresentation.getParentRepresentation();
            parentEditPart = parentRepresentation.getRepresentedEditPart();
            if (currentView == null || parentEditPart == null) continue;
            req = new ShowHideCompartmentRequest((Object)true, currentView);
            req.setType((Object)"Show/Hide Compartment");
            Command tmp = parentEditPart.getCommand((Request)req);
            if (tmp == null || !tmp.canExecute()) continue;
            completeCmd.add(tmp);
        }
        for (CompartmentEditPartRepresentation currentRepresentation2 : this.visibleRepresentations) {
            ShowHideTitleOfCompartmentCommand tmp;
            final View currentView2 = currentRepresentation2.getCompartmentView();
            boolean newVisibility = currentRepresentation2.isTitleVisible();
            boolean oldVisibility = CompartmentUtils.isCompartmentTitleVisible((View)currentView2);
            parentEditPart = currentRepresentation2.getParentRepresentation().getRepresentedEditPart();
            TransactionalEditingDomain domain = parentEditPart.getEditingDomain();
            if (newVisibility == oldVisibility) continue;
            Style style = currentView2.getStyle(NotationPackage.eINSTANCE.getTitleStyle());
            if (style == null) {
                completeCmd.add((Command)new ICommandProxy((ICommand)new AbstractTransactionalCommand(domain, "Create title style", Collections.EMPTY_LIST){

                    public CommandResult doExecuteWithResult(IProgressMonitor dummy, IAdaptable info) {
                        TitleStyle style = (TitleStyle)currentView2.createStyle(NotationPackage.eINSTANCE.getTitleStyle());
                        style.setShowTitle(false);
                        return CommandResult.newOKCommandResult();
                    }
                }));
            }
            if ((tmp = new ShowHideTitleOfCompartmentCommand(domain, currentView2, newVisibility)) == null || !tmp.canExecute()) continue;
            completeCmd.add((Command)new ICommandProxy((ICommand)tmp));
        }
        return completeCmd;
    }

    public class CompartmentEditPartRepresentation
    extends AbstractShowHideAction.EditPartRepresentation {
        private boolean isTitleVisible;
        private final View compartmentView;

        public CompartmentEditPartRepresentation(IResizableCompartmentEditPart representedEditPart, View compartmentView, EObject eObject, AbstractShowHideAction.EditPartRepresentation parentRepresentation) {
            super((AbstractShowHideAction)ShowHideCompartmentAction.this, (IGraphicalEditPart)representedEditPart, eObject, parentRepresentation);
            this.isTitleVisible = CompartmentUtils.isCompartmentTitleVisible((View)compartmentView);
            this.compartmentView = compartmentView;
            assert (compartmentView != null) : "The compartment view should not be null";
        }

        public IResizableCompartmentEditPart getRepresentedEditPart() {
            return (IResizableCompartmentEditPart)super.getRepresentedEditPart();
        }

        public boolean isTitleVisible() {
            return this.isTitleVisible;
        }

        public String getLabel() {
            if (this.getRepresentedEditPart() != null) {
                return this.getRepresentedEditPart().getCompartmentName();
            }
            IGraphicalEditPart dummyEP = EditPartService.getInstance().createGraphicEditPart(this.getCompartmentView());
            if (dummyEP instanceof IResizableCompartmentEditPart) {
                return ((IResizableCompartmentEditPart)dummyEP).getCompartmentName();
            }
            return ShowHideCompartmentAction.this.getEditorLabelProvider().getText((Object)this.getCompartmentView());
        }

        public void setTitleVisible(boolean value) {
            this.isTitleVisible = value;
        }

        public View getCompartmentView() {
            return this.compartmentView;
        }
    }

    protected class ContentProvider
    implements ITreeContentProvider {
        protected ContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof List) {
                return ((List)inputElement).toArray();
            }
            return new Object[0];
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof AbstractShowHideAction.EditPartRepresentation) {
                return ((AbstractShowHideAction.EditPartRepresentation)parentElement).getPossibleElement().toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof AbstractShowHideAction.EditPartRepresentation) {
                AbstractShowHideAction.EditPartRepresentation editPartRepresentation = (AbstractShowHideAction.EditPartRepresentation)element;
                return editPartRepresentation.getParentRepresentation();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            Object[] children = this.getChildren(element);
            return children != null && children.length != 0;
        }
    }

    public class RootEditPartRepresentation
    extends AbstractShowHideAction.EditPartRepresentation {
        public RootEditPartRepresentation(IGraphicalEditPart representedEditPart, EObject eObject) {
            super((AbstractShowHideAction)ShowHideCompartmentAction.this, representedEditPart, eObject);
        }

        protected void initRepresentation() {
            super.initRepresentation();
            List compartmentViews = CompartmentUtils.getAllCompartments((EditPart)this.getRepresentedEditPart(), (boolean)false);
            List visibleCompartments = CompartmentUtils.getAllVisibleCompartments((EditPart)this.getRepresentedEditPart(), (boolean)false);
            for (View currentView : compartmentViews) {
                CompartmentEditPartRepresentation representation = new CompartmentEditPartRepresentation(null, currentView, this.getSemanticElement(), this);
                this.elementsToSelect.add(representation);
                if (!visibleCompartments.contains(currentView)) continue;
                this.initialSelection.add(representation);
            }
        }
    }
}

