/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.commands;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.UMLBaseItemSemanticEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.providers.ElementInitializers;
import org.eclipse.papyrus.uml.diagram.sequence.util.SequenceUtil;
import org.eclipse.uml2.uml.GeneralOrdering;
import org.eclipse.uml2.uml.InteractionFragment;
import org.eclipse.uml2.uml.OccurrenceSpecification;
import org.eclipse.uml2.uml.UMLFactory;

public class GeneralOrderingCreateCommand
extends EditElementCommand {
    protected final EObject source;
    protected final EObject target;
    protected InteractionFragment container;

    public GeneralOrderingCreateCommand(CreateRelationshipRequest request, EObject source, EObject target) {
        super(request.getLabel(), null, (IEditCommandRequest)request);
        List<OccurrenceSpecification> possibleSourceOcc = null;
        if (this.getRequest().getParameters().containsKey("Nearest occurrence specification")) {
            List<OccurrenceSpecification> occ1List;
            Object paramOccurrence1 = this.getRequest().getParameter("Nearest occurrence specification");
            possibleSourceOcc = occ1List = SequenceUtil.getAsOccSpecList(paramOccurrence1);
        }
        List<OccurrenceSpecification> possibleTargetOcc = null;
        if (this.getRequest().getParameters().containsKey("Nearest occurrence specification (end)")) {
            List<OccurrenceSpecification> occ2List;
            Object paramOccurrence2 = this.getRequest().getParameter("Nearest occurrence specification (end)");
            possibleTargetOcc = occ2List = SequenceUtil.getAsOccSpecList(paramOccurrence2);
        }
        this.source = possibleSourceOcc != null && !possibleSourceOcc.isEmpty() ? (EObject)possibleSourceOcc.get(0) : null;
        this.target = possibleTargetOcc != null && !possibleTargetOcc.isEmpty() && Collections.disjoint(possibleSourceOcc, possibleTargetOcc) ? (EObject)possibleTargetOcc.get(0) : target;
        this.container = this.deduceContainer(source, target);
    }

    public boolean canExecute() {
        if (this.source == null && this.target == null) {
            return false;
        }
        if (this.source != null && !(this.source instanceof OccurrenceSpecification)) {
            return false;
        }
        if (this.target != null && !(this.target instanceof OccurrenceSpecification)) {
            return false;
        }
        if (this.getSource() == null) {
            return true;
        }
        if (this.getContainer() == null) {
            return false;
        }
        return UMLBaseItemSemanticEditPolicy.getLinkConstraints().canCreateGeneralOrdering_4012(this.getContainer(), this.getSource(), this.getTarget());
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.canExecute()) {
            throw new ExecutionException("Invalid arguments in create link command");
        }
        GeneralOrdering newElement = UMLFactory.eINSTANCE.createGeneralOrdering();
        this.getContainer().getGeneralOrderings().add((Object)newElement);
        newElement.setBefore(this.getSource());
        newElement.setAfter(this.getTarget());
        ElementInitializers.getInstance().init_GeneralOrdering_4012(newElement);
        this.doConfigure(newElement, monitor, info);
        ((CreateElementRequest)this.getRequest()).setNewElement((EObject)newElement);
        return CommandResult.newOKCommandResult((Object)newElement);
    }

    protected void doConfigure(GeneralOrdering newElement, IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IElementType elementType = ((CreateElementRequest)this.getRequest()).getElementType();
        ConfigureRequest configureRequest = new ConfigureRequest(this.getEditingDomain(), (EObject)newElement, elementType);
        configureRequest.setClientContext(((CreateElementRequest)this.getRequest()).getClientContext());
        configureRequest.addParameters(this.getRequest().getParameters());
        configureRequest.setParameter("CreateRelationshipRequest.source", (Object)this.getSource());
        configureRequest.setParameter("CreateRelationshipRequest.target", (Object)this.getTarget());
        ICommand configureCommand = elementType.getEditCommand((IEditCommandRequest)configureRequest);
        if (configureCommand != null && configureCommand.canExecute()) {
            configureCommand.execute(monitor, info);
        }
    }

    protected void setElementToEdit(EObject element) {
        throw new UnsupportedOperationException();
    }

    protected OccurrenceSpecification getSource() {
        return (OccurrenceSpecification)this.source;
    }

    protected OccurrenceSpecification getTarget() {
        return (OccurrenceSpecification)this.target;
    }

    public InteractionFragment getContainer() {
        return this.container;
    }

    protected InteractionFragment deduceContainer(EObject source, EObject target) {
        EObject element = source;
        while (element != null) {
            if (element instanceof InteractionFragment) {
                return (InteractionFragment)element;
            }
            element = element.eContainer();
        }
        return null;
    }
}

