/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.parts;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.RelativeLocator;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.DropRequest;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.INodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.GraphicalNodeEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.SemanticEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.internal.DiagramUIDebugOptions;
import org.eclipse.gmf.runtime.diagram.ui.internal.DiagramUIPlugin;
import org.eclipse.gmf.runtime.draw2d.ui.figures.IAnchorableFigure;
import org.eclipse.gmf.runtime.draw2d.ui.figures.IOvalAnchorableFigure;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientReferenceRelationshipRequest;
import org.eclipse.gmf.runtime.gef.ui.figures.SlidableOvalAnchor;
import org.eclipse.gmf.runtime.gef.ui.internal.figures.CircleFigure;
import org.eclipse.gmf.runtime.notation.Anchor;
import org.eclipse.gmf.runtime.notation.DecorationNode;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.IdentityAnchor;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.runtime.notation.impl.ShapeImpl;
import org.eclipse.papyrus.uml.diagram.sequence.edit.commands.CommentAnnotatedElementCreateCommand;
import org.eclipse.papyrus.uml.diagram.sequence.edit.commands.ConstraintConstrainedElementCreateCommand;
import org.eclipse.papyrus.uml.diagram.sequence.providers.UMLElementTypes;
import org.eclipse.papyrus.uml.diagram.sequence.util.CommandHelper;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.ExecutionOccurrenceSpecification;
import org.eclipse.uml2.uml.OccurrenceSpecification;

public class ExecutionSpecificationEndEditPart
extends org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart
implements INodeEditPart {
    private static final String DUMMY_TYPE = "999998";
    private static final int DEFAULT_SIZE = 16;
    private Locator locator;
    private OccurrenceSpecification executionSpecificationEnd;
    static ViewHelper helper = new ViewHelper();

    public ExecutionSpecificationEndEditPart(OccurrenceSpecification occurrenceSpecification, ShapeNodeEditPart parent, RelativeLocator locator) {
        super(ExecutionSpecificationEndEditPart.createDummyView(parent, (EObject)occurrenceSpecification));
        this.executionSpecificationEnd = occurrenceSpecification;
        this.setParent((EditPart)parent);
        this.addToResource(parent.getNotationView(), this.getNotationView());
        this.locator = locator;
    }

    private static EObject createDummyView(ShapeNodeEditPart parent, EObject model) {
        ShapeImpl node = new ShapeImpl(){

            public boolean eNotificationRequired() {
                return true;
            }
        };
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(DUMMY_TYPE);
        View container = (View)parent.getModel();
        node.setElement(model);
        return node;
    }

    protected void handleNotificationEvent(Notification notification) {
        Object feature = notification.getFeature();
        if (NotationPackage.eINSTANCE.getView_SourceEdges().equals(feature)) {
            this.refreshSourceConnections();
        } else if (NotationPackage.eINSTANCE.getView_TargetEdges().equals(feature)) {
            this.refreshTargetConnections();
        } else {
            super.handleNotificationEvent(notification);
        }
    }

    protected void addNotationalListeners() {
        if (this.hasNotationView()) {
            this.addListenerFilter("View", (NotificationListener)this, (EObject)((View)this.getModel()));
        }
    }

    private void addToResource(final View container, final View view) {
        CommandHelper.executeCommandWithoutHistory((EditingDomain)this.getEditingDomain(), (Command)new DummyCommand(){

            public void execute() {
                ViewUtil.insertChildView((View)container, (View)view, (int)-1, (boolean)false);
            }
        });
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new ExecutionSpecificationEndSemanticEditPolicy());
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new ExecutionSpecificationEndGraphicalNodeEditPolicy());
    }

    public void rebuildLinks(Diagram diagram) {
        helper.collectViews(diagram);
        EObject semanticModel = this.resolveSemanticElement();
        EAnnotation annotation = this.executionSpecificationEnd.getEAnnotation("Connections");
        if (annotation != null) {
            block0: for (EObject eo : annotation.getReferences()) {
                View view = helper.findView(eo);
                if (view == null) continue;
                EList edges = view.getSourceEdges();
                for (Object o : edges) {
                    if (!(o instanceof Edge) || !this.needRestoreLink((Edge)o)) continue;
                    this.restoreEdgeTarget((Edge)o);
                    continue block0;
                }
            }
        }
    }

    private boolean needRestoreLink(Edge e) {
        if (e.getTarget() == null) {
            return true;
        }
        EObject model = e.getTarget().getElement();
        if (!(model instanceof OccurrenceSpecification)) {
            return false;
        }
        if (model == this.resolveSemanticElement()) {
            System.out.println(((OccurrenceSpecification)model).getName());
            if (!this.getNotationView().equals(e.getTarget())) {
                return true;
            }
        }
        return false;
    }

    private void restoreEdgeTarget(final Edge edge) {
        CommandHelper.executeCommandWithoutHistory((EditingDomain)this.getEditingDomain(), (Command)new DummyCommand(){

            public void execute() {
                edge.setTarget((View)ExecutionSpecificationEndEditPart.this.getModel());
            }
        });
    }

    IFigure getParentFigure() {
        return ((GraphicalEditPart)this.getParent()).getFigure();
    }

    public Locator getLocator() {
        return this.locator;
    }

    protected IFigure createFigure() {
        ExecutionOccurrenceSpecification model = (ExecutionOccurrenceSpecification)this.resolveSemanticElement();
        ExecutionSpecificationEndFigure fig = new ExecutionSpecificationEndFigure();
        fig.setForegroundColor(ColorConstants.black);
        Rectangle b = fig.getBounds();
        fig.setOpaque(false);
        IFigure parentFig = this.getParentFigure();
        parentFig.add((IFigure)fig, (Object)this.locator);
        return fig;
    }

    public boolean hasNotationView() {
        return true;
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        return null;
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connEditPart) {
        final ConnectionNodeEditPart connection = (ConnectionNodeEditPart)connEditPart;
        String t = "";
        try {
            t = (String)this.getEditingDomain().runExclusive((Runnable)new RunnableWithResult.Impl(){

                public void run() {
                    Anchor a = ((Edge)connection.getModel()).getTargetAnchor();
                    if (a instanceof IdentityAnchor) {
                        this.setResult(((IdentityAnchor)a).getId());
                    } else {
                        this.setResult("");
                    }
                }
            });
        }
        catch (InterruptedException e) {
            Trace.catching((Plugin)DiagramUIPlugin.getInstance(), (String)DiagramUIDebugOptions.EXCEPTIONS_CATCHING, ((Object)((Object)this)).getClass(), (String)"getTargetConnectionAnchor", (Throwable)e);
            Log.error((Plugin)DiagramUIPlugin.getInstance(), (int)9, (String)"getTargetConnectionAnchor", (Throwable)e);
        }
        IAnchorableFigure fig = (IAnchorableFigure)this.getFigure();
        ConnectionAnchor a = fig.getConnectionAnchor(t);
        return a;
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        Point pt;
        Point center = this.getFigure().getBounds().getCenter();
        this.getFigure().translateToAbsolute((Translatable)center);
        Point point = pt = ((DropRequest)request).getLocation() == null ? center : new Point(((DropRequest)request).getLocation());
        if (request instanceof CreateRequest) {
            this.getFigure().translateToRelative((Translatable)pt);
        }
        ConnectionAnchor a = ((IAnchorableFigure)this.getFigure()).getTargetConnectionAnchorAt(pt);
        return a;
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        return null;
    }

    public boolean canAttachNote() {
        return true;
    }

    public String mapConnectionAnchorToTerminal(ConnectionAnchor c) {
        return ((IAnchorableFigure)this.getFigure()).getConnectionAnchorTerminal(c);
    }

    public ConnectionAnchor mapTerminalToConnectionAnchor(String terminal) {
        return ((IAnchorableFigure)this.getFigure()).getConnectionAnchor(terminal);
    }

    protected List getModelSourceConnections() {
        return ViewUtil.getSourceConnectionsConnectingVisibleViews((View)((View)this.getModel()));
    }

    protected List getModelTargetConnections() {
        List list = ViewUtil.getTargetConnectionsConnectingVisibleViews((View)((View)this.getModel()));
        return list;
    }

    static class CommentAnnotatedElementCreateCommandEx
    extends CommentAnnotatedElementCreateCommand {
        public CommentAnnotatedElementCreateCommandEx(CreateRelationshipRequest request, EObject source, EObject target) {
            super(request, source, target);
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            CommandResult res = super.doExecuteWithResult(monitor, info);
            if (this.getTarget() instanceof OccurrenceSpecification) {
                ExecutionSpecificationEndHelper.addConnectionSourceToExecutionSpecificationEnd((OccurrenceSpecification)this.getTarget(), (EObject)this.getSource());
            }
            return res;
        }
    }

    static class ConstraintConstrainedElementCreateCommandEx
    extends ConstraintConstrainedElementCreateCommand {
        public ConstraintConstrainedElementCreateCommandEx(CreateRelationshipRequest request, EObject source, EObject target) {
            super(request, source, target);
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            CommandResult res = super.doExecuteWithResult(monitor, info);
            if (this.getTarget() instanceof OccurrenceSpecification) {
                ExecutionSpecificationEndHelper.addConnectionSourceToExecutionSpecificationEnd((OccurrenceSpecification)this.getTarget(), (EObject)this.getSource());
            }
            return res;
        }
    }

    static class DummyCommand
    extends AbstractCommand {
        DummyCommand() {
        }

        public void execute() {
        }

        public void redo() {
        }

        public void undo() {
        }

        protected boolean prepare() {
            return true;
        }
    }

    static class ExecutionSpecificationEndAnchor
    extends SlidableOvalAnchor {
        public ExecutionSpecificationEndAnchor(CircleFigure circleFigure, PrecisionPoint p) {
            super((IOvalAnchorableFigure)circleFigure, p);
        }

        public ExecutionSpecificationEndAnchor(CircleFigure circleFigure) {
            super((IOvalAnchorableFigure)circleFigure);
        }

        public Point getLocation(Point reference) {
            return this.getBox().getCenter();
        }
    }

    class ExecutionSpecificationEndFigure
    extends CircleFigure {
        ExecutionSpecificationEndFigure() {
            super(16, 16);
        }

        protected void paintFigure(Graphics g) {
            Rectangle r = Rectangle.SINGLETON;
            r.setBounds(this.getBounds());
            --r.width;
            --r.height;
        }

        protected ConnectionAnchor createAnchor(PrecisionPoint p) {
            if (p == null) {
                return this.createDefaultAnchor();
            }
            return new ExecutionSpecificationEndAnchor(this, p);
        }

        protected ConnectionAnchor createDefaultAnchor() {
            return new ExecutionSpecificationEndAnchor(this);
        }

        public void validate() {
            super.validate();
        }

        public ConnectionAnchor getTargetConnectionAnchorAt(Point p) {
            try {
                ConnectionAnchor a = super.getTargetConnectionAnchorAt(p);
                return a;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
    }

    static class ExecutionSpecificationEndGraphicalNodeEditPolicy
    extends GraphicalNodeEditPolicy {
        IFigure executionSpecificationEndFeedback;

        ExecutionSpecificationEndGraphicalNodeEditPolicy() {
        }

        public void eraseTargetFeedback(Request request) {
            super.eraseSourceFeedback(request);
            if (this.executionSpecificationEndFeedback != null) {
                this.removeFeedback(this.executionSpecificationEndFeedback);
            }
            this.executionSpecificationEndFeedback = null;
        }

        protected void showTargetConnectionFeedback(DropRequest request) {
            if (this.executionSpecificationEndFeedback == null) {
                CircleFigure c = new CircleFigure(16, 16);
                c.setForegroundColor(ColorConstants.black);
                ExecutionSpecificationEndEditPart p = (ExecutionSpecificationEndEditPart)this.getHost();
                IFigure parent = p.getFigure().getParent();
                Rectangle targetBounds = p.getFigure().getBounds().getCopy();
                p.getFigure().translateToAbsolute((Translatable)targetBounds);
                this.getFeedbackLayer().translateToRelative((Translatable)targetBounds);
                this.getFeedbackLayer().translateFromParent((Translatable)targetBounds);
                c.setBounds(targetBounds);
                this.addFeedback((IFigure)c);
                this.executionSpecificationEndFeedback = c;
            }
        }
    }

    public static class ExecutionSpecificationEndHelper {
        public static void removeConnectionSourceFromExecutionSpecificationEnd(OccurrenceSpecification executionOccurrence, EObject connectionSource) {
            EAnnotation annotation = executionOccurrence.getEAnnotation("Connections");
            if (annotation != null) {
                annotation.getReferences().remove((Object)connectionSource);
            }
        }

        public static void addConnectionSourceToExecutionSpecificationEnd(OccurrenceSpecification executionOccurrence, EObject connectionSource) {
            EAnnotation annotation = executionOccurrence.getEAnnotation("Connections");
            if (annotation == null) {
                annotation = EcoreFactory.eINSTANCE.createEAnnotation();
                annotation.setSource("Connections");
                executionOccurrence.getEAnnotations().add((Object)annotation);
            }
            if (!annotation.getReferences().contains((Object)connectionSource)) {
                annotation.getReferences().add((Object)connectionSource);
            }
        }
    }

    static class ExecutionSpecificationEndSemanticEditPolicy
    extends SemanticEditPolicy {
        ExecutionSpecificationEndSemanticEditPolicy() {
        }

        protected org.eclipse.gef.commands.Command getSemanticCommand(IEditCommandRequest request) {
            if (request instanceof CreateRelationshipRequest) {
                return this.getCreateRelationshipCommand((CreateRelationshipRequest)request);
            }
            if (request instanceof ReorientReferenceRelationshipRequest) {
                return this.getGEFWrapper((ICommand)new ReorientExecutionSpecificationEndCommand((ReorientReferenceRelationshipRequest)request));
            }
            org.eclipse.gef.commands.Command cmd = super.getSemanticCommand(request);
            return cmd;
        }

        protected org.eclipse.gef.commands.Command getStartCreateRelationshipCommand(CreateRelationshipRequest req) {
            if (UMLElementTypes.ConstraintConstrainedElement_4011 == req.getElementType()) {
                return this.getGEFWrapper((ICommand)new ConstraintConstrainedElementCreateCommandEx(req, req.getSource(), req.getTarget()));
            }
            return null;
        }

        protected org.eclipse.gef.commands.Command getCompleteCreateRelationshipCommand(CreateRelationshipRequest req) {
            if (UMLElementTypes.ConstraintConstrainedElement_4011 == req.getElementType()) {
                return this.getGEFWrapper((ICommand)new ConstraintConstrainedElementCreateCommandEx(req, req.getSource(), req.getTarget()));
            }
            if (UMLElementTypes.CommentAnnotatedElement_4010 == req.getElementType()) {
                return this.getGEFWrapper((ICommand)new CommentAnnotatedElementCreateCommandEx(req, req.getSource(), req.getTarget()));
            }
            return null;
        }

        protected org.eclipse.gef.commands.Command getCreateRelationshipCommand(CreateRelationshipRequest req) {
            org.eclipse.gef.commands.Command command = req.getTarget() == null ? this.getStartCreateRelationshipCommand(req) : this.getCompleteCreateRelationshipCommand(req);
            return command;
        }

        protected final org.eclipse.gef.commands.Command getGEFWrapper(ICommand cmd) {
            return new ICommandProxy(cmd);
        }
    }

    static class ReorientExecutionSpecificationEndCommand
    extends EditElementCommand {
        private ReorientReferenceRelationshipRequest request;

        public ReorientExecutionSpecificationEndCommand(ReorientReferenceRelationshipRequest request) {
            super(request.getLabel(), request.getNewRelationshipEnd(), (IEditCommandRequest)request);
            this.request = request;
        }

        public boolean canExecute() {
            return true;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            if (this.request.getNewRelationshipEnd() instanceof OccurrenceSpecification) {
                ExecutionSpecificationEndHelper.addConnectionSourceToExecutionSpecificationEnd((OccurrenceSpecification)this.request.getNewRelationshipEnd(), this.request.getReferenceOwner());
                if (this.request.getReferenceOwner() instanceof Constraint) {
                    ((Constraint)this.request.getReferenceOwner()).getConstrainedElements().add((Object)((OccurrenceSpecification)this.request.getNewRelationshipEnd()));
                } else if (this.request.getReferenceOwner() instanceof Comment) {
                    ((Comment)this.request.getReferenceOwner()).getAnnotatedElements().add((Object)((OccurrenceSpecification)this.request.getNewRelationshipEnd()));
                }
            }
            if (this.request.getOldRelationshipEnd() instanceof OccurrenceSpecification) {
                ExecutionSpecificationEndHelper.removeConnectionSourceFromExecutionSpecificationEnd((OccurrenceSpecification)this.request.getOldRelationshipEnd(), this.request.getReferenceOwner());
                if (this.request.getReferenceOwner() instanceof Constraint) {
                    ((Constraint)this.request.getReferenceOwner()).getConstrainedElements().remove((Object)((OccurrenceSpecification)this.request.getOldRelationshipEnd()));
                } else if (this.request.getReferenceOwner() instanceof Comment) {
                    ((Comment)this.request.getReferenceOwner()).getAnnotatedElements().remove((Object)((OccurrenceSpecification)this.request.getOldRelationshipEnd()));
                }
            }
            return CommandResult.newOKCommandResult();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ViewHelper {
        Diagram diagram = null;
        Set<View> allViews = new HashSet<View>();
        Map<EObject, View> viewMaps = new HashMap<EObject, View>();

        ViewHelper() {
        }

        View findView(EObject key) {
            return this.viewMaps.get(key);
        }

        void collectViews(Diagram d) {
            if (this.diagram != d) {
                this.diagram = d;
                this.allViews.clear();
                this.viewMaps.clear();
                ViewHelper.getAllNestedViews((View)this.diagram, this.allViews);
                for (View v : this.allViews) {
                    if (v instanceof DecorationNode) continue;
                    this.viewMaps.put(v.getElement(), v);
                }
            }
        }

        private static void getAllNestedViews(View view, Set<View> allViews) {
            for (View childView : view.getChildren()) {
                ViewHelper.getAllNestedViews(childView, allViews);
                allViews.add(childView);
            }
        }
    }
}

