/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.policies;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.requests.AlignmentRequest;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.XYLayoutEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.figures.IBorderItemLocator;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.draw2d.ui.figures.BaseSlidableAnchor;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.emf.type.core.commands.SetValueCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.IdentityAnchor;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.builders.NotificationBuilder;
import org.eclipse.papyrus.uml.diagram.common.commands.PreserveAnchorsPositionCommand;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.CombinedFragmentCombinedFragmentCompartmentEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.CombinedFragmentEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.DurationConstraintEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.InteractionOperandEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.LifelineEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.LifelineXYLayoutEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.part.Messages;
import org.eclipse.papyrus.uml.diagram.sequence.providers.UMLElementTypes;
import org.eclipse.papyrus.uml.diagram.sequence.util.OperandBoundsComputeHelper;
import org.eclipse.papyrus.uml.diagram.sequence.util.SequenceUtil;
import org.eclipse.uml2.uml.CombinedFragment;
import org.eclipse.uml2.uml.ExecutionSpecification;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.InteractionFragment;
import org.eclipse.uml2.uml.InteractionOperand;
import org.eclipse.uml2.uml.Lifeline;

public class InteractionCompartmentXYLayoutEditPolicy
extends XYLayoutEditPolicy {
    protected Command getResizeChildrenCommand(ChangeBoundsRequest request) {
        CompoundCommand compoundCmd = new CompoundCommand();
        compoundCmd.setLabel("Move or Resize");
        IFigure figure = this.getHostFigure();
        Rectangle hostBounds = figure.getBounds();
        for (Object o : request.getEditParts()) {
            GraphicalEditPart child = (GraphicalEditPart)o;
            Object constraintFor = this.getConstraintFor(request, child);
            if (!(constraintFor instanceof Rectangle)) continue;
            Rectangle childBounds = (Rectangle)constraintFor;
            if (childBounds.x < 0 || childBounds.y < 0) {
                return UnexecutableCommand.INSTANCE;
            }
            if (child instanceof LifelineEditPart) {
                if (this.isVerticalMove(request)) {
                    InteractionCompartmentXYLayoutEditPolicy.addLifelineResizeChildrenCommand(compoundCmd, request, (LifelineEditPart)child, 1);
                }
            } else if (child instanceof CombinedFragmentEditPart) {
                if (!OperandBoundsComputeHelper.checkRedistrictOnCFResize(request, (EditPart)child)) {
                    return null;
                }
                Command resizeChildrenCommand = InteractionCompartmentXYLayoutEditPolicy.getCombinedFragmentResizeChildrenCommand(request, (CombinedFragmentEditPart)child);
                if (resizeChildrenCommand != null && resizeChildrenCommand.canExecute()) {
                    compoundCmd.add(resizeChildrenCommand);
                }
            }
            if (!(child instanceof LifelineEditPart) || this.isVerticalMove(request)) {
                Command changeConstraintCommand = this.createChangeConstraintCommand(request, (EditPart)child, this.translateToModelConstraint(constraintFor));
                compoundCmd.add(changeConstraintCommand);
            }
            if (child instanceof CombinedFragmentEditPart) {
                OperandBoundsComputeHelper.createUpdateIOBoundsForCFResizeCommand(compoundCmd, request, (CombinedFragmentEditPart)child);
            }
            int right = childBounds.right();
            int bottom = childBounds.bottom();
            int deltaX = 0;
            int deltaY = 0;
            if (right > hostBounds.width) {
                deltaX = right - hostBounds.width;
            }
            if (bottom > hostBounds.height) {
                deltaY = bottom - hostBounds.height;
            }
            if (deltaX == 0 && deltaY == 0) continue;
            ChangeBoundsRequest boundsRequest = new ChangeBoundsRequest((Object)"resize");
            boundsRequest.setSizeDelta(new Dimension(deltaX, deltaY));
            EditPart hostParent = this.getHost().getParent();
            boundsRequest.setEditParts(hostParent);
            Command cmd = hostParent.getCommand((Request)boundsRequest);
            if (cmd == null || !cmd.canExecute()) continue;
            compoundCmd.add(cmd);
        }
        return compoundCmd.unwrap();
    }

    protected boolean isVerticalMove(ChangeBoundsRequest request) {
        if (request instanceof AlignmentRequest) {
            AlignmentRequest alignmentRequest = (AlignmentRequest)request;
            switch (alignmentRequest.getAlignment()) {
                case 8: 
                case 9: 
                case 12: 
                case 16: 
                case 17: 
                case 20: 
                case 32: 
                case 128: {
                    return false;
                }
            }
        }
        Point point = request.getMoveDelta();
        return point.y == 0;
    }

    private static void addLifelineResizeChildrenCommand(CompoundCommand compoundCmd, ChangeBoundsRequest request, LifelineEditPart lifelineEditPart, int number) {
        for (ShapeNodeEditPart executionSpecificationEP : lifelineEditPart.getChildShapeNodeEditPart()) {
            if (!(executionSpecificationEP.resolveSemanticElement() instanceof ExecutionSpecification)) continue;
            Rectangle rDotLine = lifelineEditPart.getContentPane().getBounds();
            Rectangle newBounds = executionSpecificationEP.getFigure().getBounds().getCopy();
            int widthDelta = request.getSizeDelta().width;
            if (widthDelta != 0) {
                if (rDotLine.getSize().width + widthDelta < newBounds.width * 2) {
                    compoundCmd.add((Command)UnexecutableCommand.INSTANCE);
                }
                widthDelta = Math.round((float)widthDelta / (2.0f * (float)number));
                newBounds.x += widthDelta;
                newBounds.x -= rDotLine.x;
                newBounds.y -= rDotLine.y;
                SetBoundsCommand setBoundsCmd = new SetBoundsCommand(executionSpecificationEP.getEditingDomain(), "Re-location of a ExecutionSpecification due to a Lifeline movement", (IAdaptable)executionSpecificationEP, newBounds);
                compoundCmd.add((Command)new ICommandProxy((ICommand)setBoundsCmd));
            }
            compoundCmd.add(SequenceUtil.createUpdateEnclosingInteractionCommand(executionSpecificationEP, request.getMoveDelta(), new Dimension(widthDelta, 0)));
        }
        List<LifelineEditPart> innerConnectableElementList = lifelineEditPart.getInnerConnectableElementList();
        for (LifelineEditPart lifelineEP : innerConnectableElementList) {
            InteractionCompartmentXYLayoutEditPolicy.addLifelineResizeChildrenCommand(compoundCmd, request, lifelineEP, number * innerConnectableElementList.size());
        }
        InteractionCompartmentXYLayoutEditPolicy.addUpdateInteractionFragmentsLocationCommand(compoundCmd, request, lifelineEditPart);
    }

    private static void addUpdateInteractionFragmentsLocationCommand(CompoundCommand compoundCmd, ChangeBoundsRequest request, LifelineEditPart lifelineEditPart) {
        View shape = (View)lifelineEditPart.getModel();
        Lifeline element = (Lifeline)shape.getElement();
        EList covereds = element.getCoveredBys();
        EditPart parent = lifelineEditPart.getParent();
        List children = parent.getChildren();
        for (Object obj : children) {
            EditPart et = (EditPart)obj;
            View sp = (View)et.getModel();
            if (!covereds.contains((Object)sp.getElement())) continue;
            ChangeBoundsRequest req = new ChangeBoundsRequest((Object)"move");
            req.setEditParts(et);
            req.setMoveDelta(request.getMoveDelta());
            Command command = et.getCommand((Request)req);
            if (command == null || !command.canExecute()) continue;
            compoundCmd.add(command);
        }
    }

    public static Command getCombinedFragmentResizeChildrenCommand(ChangeBoundsRequest request, CombinedFragmentEditPart combinedFragmentEditPart) {
        Command notifyCmd;
        Point moveDelta = request.getMoveDelta();
        Dimension sizeDelta = request.getSizeDelta();
        IFigure cfFigure = combinedFragmentEditPart.getFigure();
        Rectangle origCFBounds = cfFigure.getBounds().getCopy();
        cfFigure.getParent().translateToAbsolute((Translatable)origCFBounds);
        origCFBounds.translate(cfFigure.getParent().getBounds().getLocation());
        CompoundCommand compoundCmd = new CompoundCommand();
        if (sizeDelta.equals(0, 0)) {
            Set allEditPartEntries = combinedFragmentEditPart.getViewer().getEditPartRegistry().entrySet();
            for (Map.Entry epEntry : allEditPartEntries) {
                ShapeEditPart sep;
                EObject elem;
                EditPart ep = (EditPart)epEntry.getValue();
                if (ep instanceof ShapeEditPart && (elem = (sep = (ShapeEditPart)ep).getNotationView().getElement()) instanceof InteractionFragment) {
                    EditPart parentEP;
                    IFigure figure = sep.getFigure();
                    Rectangle figureBounds = figure.getBounds().getCopy();
                    figure.getParent().translateToAbsolute((Translatable)figureBounds);
                    if (origCFBounds.contains(figureBounds) && (parentEP = sep.getParent()) instanceof LifelineEditPart) {
                        ChangeBoundsRequest esRequest = new ChangeBoundsRequest((Object)"move");
                        esRequest.setEditParts((EditPart)sep);
                        esRequest.setMoveDelta(moveDelta);
                        Command moveESCommand = LifelineXYLayoutEditPolicy.getResizeOrMoveChildrenCommand((LifelineEditPart)parentEP, esRequest, true, false, true);
                        if (moveESCommand != null && !moveESCommand.canExecute()) {
                            return UnexecutableCommand.INSTANCE;
                        }
                        if (moveESCommand != null) {
                            compoundCmd.add(moveESCommand);
                        }
                    }
                }
                if (ep instanceof ConnectionEditPart) {
                    Rectangle figureBounds;
                    IdentityAnchor gmfAnchor;
                    ConnectionEditPart cep = (ConnectionEditPart)ep;
                    Connection msgFigure = cep.getConnectionFigure();
                    ConnectionAnchor sourceAnchor = msgFigure.getSourceAnchor();
                    ConnectionAnchor targetAnchor = msgFigure.getTargetAnchor();
                    Point sourcePoint = sourceAnchor.getReferencePoint();
                    Point targetPoint = targetAnchor.getReferencePoint();
                    Edge edge = (Edge)cep.getModel();
                    if (origCFBounds.contains(sourcePoint) && cep.getSource() instanceof LifelineEditPart) {
                        gmfAnchor = (IdentityAnchor)edge.getSourceAnchor();
                        figureBounds = sourceAnchor.getOwner().getBounds();
                        compoundCmd.add((Command)new ICommandProxy(InteractionCompartmentXYLayoutEditPolicy.getMoveAnchorCommand(moveDelta.y, figureBounds, gmfAnchor)));
                    }
                    if (origCFBounds.contains(targetPoint) && cep.getTarget() instanceof LifelineEditPart) {
                        gmfAnchor = (IdentityAnchor)edge.getTargetAnchor();
                        figureBounds = targetAnchor.getOwner().getBounds();
                        compoundCmd.add((Command)new ICommandProxy(InteractionCompartmentXYLayoutEditPolicy.getMoveAnchorCommand(moveDelta.y, figureBounds, gmfAnchor)));
                    }
                }
                if (!(ep instanceof DurationConstraintEditPart)) continue;
                DurationConstraintEditPart dcp = (DurationConstraintEditPart)ep;
                InteractionCompartmentXYLayoutEditPolicy.moveCoveredDurationConstraint(dcp, compoundCmd, origCFBounds, moveDelta);
            }
        } else {
            Rectangle newBoundsCF = origCFBounds.getCopy();
            newBoundsCF.translate(moveDelta);
            newBoundsCF.resize(sizeDelta);
            CombinedFragment cf = (CombinedFragment)combinedFragmentEditPart.resolveSemanticElement();
            if (combinedFragmentEditPart.getChildren().size() > 0 && combinedFragmentEditPart.getChildren().get(0) instanceof CombinedFragmentCombinedFragmentCompartmentEditPart) {
                CombinedFragmentCombinedFragmentCompartmentEditPart compartment = (CombinedFragmentCombinedFragmentCompartmentEditPart)((Object)combinedFragmentEditPart.getChildren().get(0));
                List combinedFragmentChildrenEditParts = compartment.getChildren();
                ArrayList<InteractionOperandEditPart> interactionOperandEditParts = new ArrayList<InteractionOperandEditPart>();
                InteractionOperand firstOperand = (InteractionOperand)cf.getOperands().get(0);
                HashSet notCoveredAnymoreInteractionFragments = new HashSet();
                int headerHeight = 0;
                for (EditPart ep : combinedFragmentChildrenEditParts) {
                    if (!(ep instanceof InteractionOperandEditPart)) continue;
                    InteractionOperandEditPart ioEP = (InteractionOperandEditPart)ep;
                    InteractionOperand io = (InteractionOperand)ioEP.resolveSemanticElement();
                    if (!cf.getOperands().contains((Object)io)) continue;
                    interactionOperandEditParts.add(ioEP);
                    notCoveredAnymoreInteractionFragments.addAll(io.getFragments());
                    if (!firstOperand.equals(io)) continue;
                    Rectangle boundsIO = ioEP.getFigure().getBounds().getCopy();
                    ioEP.getFigure().getParent().translateToAbsolute((Translatable)boundsIO);
                    headerHeight = boundsIO.y - origCFBounds.y;
                }
                double heightRatio = (double)(newBoundsCF.height - headerHeight) / (double)(origCFBounds.height - headerHeight);
                double widthRatio = (double)newBoundsCF.width / (double)origCFBounds.width;
                for (InteractionOperandEditPart ioEP : interactionOperandEditParts) {
                    InteractionOperand io = (InteractionOperand)ioEP.resolveSemanticElement();
                    Rectangle newBoundsIO = SequenceUtil.getAbsoluteBounds((IGraphicalEditPart)ioEP);
                    newBoundsIO.translate(moveDelta);
                    newBoundsIO.height = (int)((double)newBoundsIO.height * heightRatio);
                    newBoundsIO.width = (int)((double)newBoundsIO.width * widthRatio);
                    if (firstOperand.equals(io)) {
                        newBoundsIO.y -= headerHeight;
                        newBoundsIO.height += headerHeight;
                    }
                    HashSet<InteractionFragment> ignoreSet = new HashSet<InteractionFragment>();
                    ignoreSet.add((InteractionFragment)cf);
                    ignoreSet.addAll((Collection<InteractionFragment>)cf.getOperands());
                    Set<InteractionFragment> coveredInteractionFragments = SequenceUtil.getCoveredInteractionFragments(newBoundsIO, (EditPart)combinedFragmentEditPart, ignoreSet);
                    if (coveredInteractionFragments == null) {
                        return UnexecutableCommand.INSTANCE;
                    }
                    notCoveredAnymoreInteractionFragments.removeAll(coveredInteractionFragments);
                    for (InteractionFragment ift : coveredInteractionFragments) {
                        if (cf.equals(ift)) continue;
                        Interaction interactionOwner = ift.getEnclosingInteraction();
                        InteractionOperand ioOwner = ift.getEnclosingOperand();
                        if ((ioOwner == null || !ioOwner.equals(cf.getEnclosingOperand()) && !cf.equals(ioOwner.getOwner())) && (interactionOwner == null || !interactionOwner.equals(cf.getEnclosingInteraction()) && !cf.equals(interactionOwner.getOwner()))) continue;
                        compoundCmd.add((Command)new ICommandProxy(SequenceUtil.getSetEnclosingInteractionCommand(ioEP.getEditingDomain(), ift, (EObject)io)));
                    }
                }
                for (InteractionFragment ift : notCoveredAnymoreInteractionFragments) {
                    if (cf.getEnclosingOperand() != null) {
                        compoundCmd.add((Command)new ICommandProxy(SequenceUtil.getSetEnclosingInteractionCommand(combinedFragmentEditPart.getEditingDomain(), ift, (EObject)cf.getEnclosingOperand())));
                        continue;
                    }
                    compoundCmd.add((Command)new ICommandProxy(SequenceUtil.getSetEnclosingInteractionCommand(combinedFragmentEditPart.getEditingDomain(), ift, (EObject)cf.getEnclosingInteraction())));
                }
            }
        }
        EObject combinedFragment = combinedFragmentEditPart.resolveSemanticElement();
        if (combinedFragment instanceof CombinedFragment && !sizeDelta.equals(0, 0) && ((CombinedFragment)combinedFragment).getOperands().size() > 1 && (notifyCmd = new Command(){

            public void execute() {
                NotificationBuilder warning = NotificationBuilder.createAsyncPopup((String)Messages.Warning_ResizeInteractionOperandTitle, (String)NLS.bind((String)Messages.Warning_ResizeInteractionOperandTxt, (Object)System.getProperty("line.separator")));
                warning.run();
            }

            public void undo() {
                this.execute();
            }
        }).canExecute()) {
            compoundCmd.add(notifyCmd);
        }
        if (compoundCmd.isEmpty()) {
            return null;
        }
        return compoundCmd;
    }

    private static void moveCoveredDurationConstraint(DurationConstraintEditPart dcp, CompoundCommand compoundCmd, Rectangle origCFBounds, Point moveDelta) {
        Rectangle r = dcp.getFigure().getBounds().getCopy();
        dcp.getFigure().translateToAbsolute((Translatable)r);
        if (origCFBounds.contains(r)) {
            DurationConstraintEditPart borderItemEP = dcp;
            IBorderItemLocator borderItemLocator = borderItemEP.getBorderItemLocator();
            Rectangle realLocation = borderItemLocator.getValidLocation(dcp.getFigure().getBounds().getCopy(), borderItemEP.getFigure());
            Point parentOrigin = borderItemEP.getFigure().getParent().getBounds().getTopLeft();
            Dimension d = realLocation.getTopLeft().getDifference(parentOrigin);
            Point location = new Point(d.width, d.height);
            location = location.translate(0, moveDelta.y);
            ICommandProxy resize = new ICommandProxy((ICommand)new SetBoundsCommand(dcp.getEditingDomain(), DiagramUIMessages.Commands_MoveElement, (IAdaptable)new EObjectAdapter((EObject)((View)dcp.getModel())), location));
            compoundCmd.add((Command)resize);
        }
    }

    private static ICommand getMoveAnchorCommand(int yDelta, Rectangle figureBounds, IdentityAnchor gmfAnchor) {
        String oldTerminal = gmfAnchor.getId();
        PrecisionPoint pp = BaseSlidableAnchor.parseTerminalString((String)oldTerminal);
        int yPos = (int)Math.round((double)figureBounds.height * pp.preciseY);
        pp.preciseY = (double)(yPos += yDelta) / (double)figureBounds.height;
        if (pp.preciseY > 1.0) {
            pp.preciseY = 1.0;
        } else if (pp.preciseY < 0.0) {
            pp.preciseY = 0.0;
        }
        String newTerminal = new BaseSlidableAnchor(null, pp).getTerminal();
        return new SetValueCommand(new SetRequest((EObject)gmfAnchor, (EStructuralFeature)NotationPackage.Literals.IDENTITY_ANCHOR__ID, (Object)newTerminal));
    }

    protected Object getConstraintFor(ChangeBoundsRequest request, GraphicalEditPart child) {
        Rectangle cons;
        PrecisionRectangle rect = new PrecisionRectangle(child.getFigure().getBounds());
        child.getFigure().translateToAbsolute((Translatable)rect);
        rect = request.getTransformedRectangle((Rectangle)rect);
        child.getFigure().translateToRelative((Translatable)rect);
        rect.translate(this.getLayoutOrigin().getNegated());
        if (request.getSizeDelta().width == 0 && request.getSizeDelta().height == 0) {
            cons = this.getCurrentConstraintFor(child);
            if (cons != null) {
                rect.setSize(cons.width, cons.height);
            }
        } else {
            Dimension minSize = this.getMinimumSizeFor(child);
            if (rect.width < minSize.width) {
                return null;
            }
            if (rect.height < minSize.height) {
                return null;
            }
        }
        rect = (Rectangle)this.getConstraintFor((Rectangle)rect);
        cons = this.getCurrentConstraintFor(child);
        if (request.getSizeDelta().width == 0) {
            rect.width = cons.width;
        }
        if (request.getSizeDelta().height == 0) {
            rect.height = cons.height;
        }
        return rect;
    }

    protected Dimension getMinimumSizeFor(GraphicalEditPart child) {
        Dimension minimunSize = child instanceof LifelineEditPart ? this.getMinimumSizeFor((LifelineEditPart)child) : super.getMinimumSizeFor(child);
        return minimunSize;
    }

    private Dimension getMinimumSizeFor(LifelineEditPart child) {
        LifelineEditPart lifelineEditPart = child;
        Dimension minimunSize = lifelineEditPart.getFigure().getMinimumSize();
        for (LifelineEditPart lifelineEP : lifelineEditPart.getInnerConnectableElementList()) {
            minimunSize.union(this.getMinimumSizeFor(lifelineEP));
        }
        for (ShapeNodeEditPart executionSpecificationEP : lifelineEditPart.getChildShapeNodeEditPart()) {
            int minimunHeight = executionSpecificationEP.getFigure().getBounds().bottom();
            minimunSize.setSize(new Dimension(minimunSize.width, Math.max(minimunSize.height, minimunHeight)));
        }
        return minimunSize;
    }

    public Command getAddCommand(Request request) {
        if (request instanceof ChangeBoundsRequest) {
            return UnexecutableCommand.INSTANCE;
        }
        return super.getAddCommand(request);
    }

    public Command getCommand(Request request) {
        if (request instanceof ChangeBoundsRequest) {
            ChangeBoundsRequest cbr = (ChangeBoundsRequest)request;
            int resizeDirection = cbr.getResizeDirection();
            CompoundCommand compoundCmd = new CompoundCommand("Resize of Interaction Compartment Elements");
            for (EditPart ep : cbr.getEditParts()) {
                if (!(ep instanceof LifelineEditPart) || !this.isVerticalMove(cbr)) continue;
                LifelineEditPart lifelineEP = (LifelineEditPart)ep;
                int preserveY = 0;
                Dimension newSizeDelta = PreserveAnchorsPositionCommand.getSizeDeltaToFitAnchors((ShapeNodeEditPart)lifelineEP, (Dimension)cbr.getSizeDelta(), (int)preserveY);
                compoundCmd.add(this.getSetBoundsCommand(lifelineEP, cbr, newSizeDelta));
                compoundCmd.add((Command)new ICommandProxy((ICommand)new PreserveAnchorsPositionCommand((ShapeNodeEditPart)lifelineEP, newSizeDelta, preserveY, (IFigure)lifelineEP.getPrimaryShape().getFigureLifelineDotLineFigure(), resizeDirection)));
            }
            if (compoundCmd.size() == 0) {
                return super.getCommand(request);
            }
            return compoundCmd;
        }
        return super.getCommand(request);
    }

    protected Command getSetBoundsCommand(LifelineEditPart lifelineEP, ChangeBoundsRequest cbr, Dimension newSizeDelta) {
        List epList = cbr.getEditParts();
        Dimension oldSizeDelta = cbr.getSizeDelta();
        cbr.setEditParts((EditPart)lifelineEP);
        cbr.setSizeDelta(newSizeDelta);
        Command cmd = super.getCommand((Request)cbr);
        cbr.setEditParts(epList);
        cbr.setSizeDelta(oldSizeDelta);
        return cmd;
    }

    protected Rectangle getBoundsOffest(CreateViewRequest request, Rectangle bounds, CreateViewRequest.ViewDescriptor viewDescriptor) {
        int translate = request.getViewDescriptors().indexOf(viewDescriptor) * 10;
        Rectangle target = bounds.getCopy().translate(translate, translate);
        if (((IHintedType)UMLElementTypes.Lifeline_3001).getSemanticHint().equals(viewDescriptor.getSemanticHint())) {
            target.setY(10);
        }
        return target;
    }
}

