/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.policies;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.edithelpers.CreateElementRequestAdapter;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SemanticCreateCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.CreationEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewAndElementRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.EditCommandRequestWrapper;
import org.eclipse.gmf.runtime.diagram.ui.requests.RefreshConnectionsRequest;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.LifelineEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.figures.LifelineDotLineCustomFigure;
import org.eclipse.papyrus.uml.diagram.sequence.providers.UMLElementTypes;
import org.eclipse.papyrus.uml.diagram.sequence.util.SequenceUtil;
import org.eclipse.uml2.uml.InteractionFragment;
import org.eclipse.uml2.uml.OccurrenceSpecification;

public class LifelineCreationEditPolicy
extends CreationEditPolicy {
    protected Command getCreateElementAndViewCommand(CreateViewAndElementRequest request) {
        Command createElementCommand;
        EditPart hostPart;
        CreateElementRequestAdapter requestAdapter = request.getViewAndElementDescriptor().getCreateElementRequestAdapter();
        CreateElementRequest createElementRequest = (CreateElementRequest)requestAdapter.getAdapter(CreateElementRequest.class);
        if (createElementRequest.getContainer() == null) {
            View view = (View)this.getHost().getModel();
            EObject hostElement = ViewUtil.resolveSemanticElement((View)view);
            if (hostElement == null && view.getElement() == null) {
                hostElement = view;
            }
            if (hostElement == null) {
                return null;
            }
            createElementRequest.setContainer(hostElement);
        }
        InteractionFragment ift = SequenceUtil.findInteractionFragmentContainerAt(request.getLocation(), this.getHost());
        Map extendedData = request.getExtendedData();
        extendedData.put("InteractionFragment Container", ift);
        String requestHint = request.getViewAndElementDescriptor().getSemanticHint();
        if (this.isCreatedOnOccurrenceSpecification(requestHint) && (hostPart = this.getHost()) instanceof LifelineEditPart) {
            Map.Entry<Point, List<OccurrenceSpecification>> eventAndLocation = SequenceUtil.findNearestEvent(request.getLocation(), (LifelineEditPart)hostPart);
            List<Object> events = Collections.emptyList();
            Point location = null;
            if (eventAndLocation != null) {
                location = eventAndLocation.getKey();
                events = eventAndLocation.getValue();
            }
            if (extendedData.containsKey("Nearest occurrence specification (end)")) {
                extendedData.put("Nearest occurrence specification (end)", events);
            } else {
                extendedData.put("Nearest occurrence specification", events);
            }
            if (extendedData.containsKey("Nearest occurrence specification location (end)")) {
                extendedData.put("Nearest occurrence specification location (end)", location);
            } else {
                extendedData.put("Nearest occurrence specification location", location);
            }
        }
        if ((createElementCommand = this.getHost().getCommand((Request)new EditCommandRequestWrapper((IEditCommandRequest)((CreateElementRequest)requestAdapter.getAdapter(CreateElementRequest.class)), request.getExtendedData()))) == null) {
            return UnexecutableCommand.INSTANCE;
        }
        if (!createElementCommand.canExecute()) {
            return createElementCommand;
        }
        SemanticCreateCommand semanticCommand = new SemanticCreateCommand(requestAdapter, createElementCommand);
        Command viewCommand = this.getCreateCommand((CreateViewRequest)request);
        Command refreshConnectionCommand = this.getHost().getCommand((Request)new RefreshConnectionsRequest((List)request.getNewObject()));
        CompositeCommand cc = new CompositeCommand(semanticCommand.getLabel());
        cc.compose((IUndoableOperation)semanticCommand);
        cc.compose((IUndoableOperation)new CommandProxy(viewCommand));
        if (refreshConnectionCommand != null) {
            cc.compose((IUndoableOperation)new CommandProxy(refreshConnectionCommand));
        }
        LifelineEditPart parentPart = (LifelineEditPart)this.getHost();
        IHintedType type = (IHintedType)UMLElementTypes.Lifeline_3001;
        if (type.getSemanticHint().equals(request.getViewAndElementDescriptor().getSemanticHint())) {
            this.setChildLifelineBounds(cc, request, parentPart);
        }
        return new ICommandProxy((ICommand)cc);
    }

    private void setChildLifelineBounds(CompositeCommand cc, CreateViewAndElementRequest request, LifelineEditPart parentPart) {
        Point location = request.getLocation().getCopy();
        LifelineDotLineCustomFigure parentFigure = (LifelineDotLineCustomFigure)parentPart.getContentPane();
        Rectangle parentBounds = parentFigure.getBounds().getCopy();
        parentFigure.translateToAbsolute((Translatable)parentBounds);
        Rectangle childBounds = parentBounds.getCopy();
        childBounds.height = parentBounds.height;
        childBounds.width = -1;
        childBounds.y = 0;
        childBounds.x = location.x - parentBounds.x;
        SetBoundsCommand cmd = new SetBoundsCommand(parentPart.getEditingDomain(), "set size", (IAdaptable)request.getViewAndElementDescriptor(), childBounds);
        cc.compose((IUndoableOperation)cmd);
    }

    private boolean isCreatedOnOccurrenceSpecification(String requestHint) {
        return this.isTimeHint(requestHint) || this.isDurationHint(requestHint);
    }

    private boolean isDurationHint(String requestHint) {
        String durCstOnLifelineHint = ((IHintedType)UMLElementTypes.DurationConstraint_3021).getSemanticHint();
        String durCstOnMessage = ((IHintedType)UMLElementTypes.DurationConstraint_3023).getSemanticHint();
        String durObsOnMessage = ((IHintedType)UMLElementTypes.DurationObservation_3024).getSemanticHint();
        return durCstOnLifelineHint.equals(requestHint) || durCstOnMessage.equals(requestHint) || durObsOnMessage.equals(requestHint);
    }

    private boolean isTimeHint(String requestHint) {
        String timeConstraintHint = ((IHintedType)UMLElementTypes.TimeConstraint_3019).getSemanticHint();
        String timeObservationHint = ((IHintedType)UMLElementTypes.TimeObservation_3020).getSemanticHint();
        return timeConstraintHint.equals(requestHint) || timeObservationHint.equals(requestHint);
    }
}

