/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.util;

import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.ICompositeCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.Shape;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.CombinedFragmentCombinedFragmentCompartmentEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.CombinedFragmentEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.InteractionInteractionCompartmentEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.InteractionOperandEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.part.UMLVisualIDRegistry;
import org.eclipse.papyrus.uml.diagram.sequence.providers.UMLElementTypes;
import org.eclipse.papyrus.uml.diagram.sequence.util.CommandHelper;
import org.eclipse.uml2.uml.CombinedFragment;
import org.eclipse.uml2.uml.InteractionOperand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperandBoundsComputeHelper {
    public static final int DEFAULT_INTERACTION_OPERAND_HEIGHT = 61;
    public static final int DEFAULT_INTERACTION_OPERAND_WIDTH = 210;
    public static final int COMBINED_FRAGMENT_FIGURE_BORDER = 1;

    public static InteractionOperandEditPart findFirstIOEP(CombinedFragmentCombinedFragmentCompartmentEditPart compartEP) {
        InteractionOperandEditPart firstIOEP = null;
        List children = compartEP.getChildren();
        int i = 0;
        while (i < children.size()) {
            if (children.get(i) instanceof InteractionOperandEditPart) {
                firstIOEP = (InteractionOperandEditPart)((Object)children.get(i));
                break;
            }
            ++i;
        }
        return firstIOEP;
    }

    public static InteractionOperandEditPart findLastIOEP(CombinedFragmentCombinedFragmentCompartmentEditPart compartEP) {
        InteractionOperandEditPart lastIOEP = null;
        List children = compartEP.getChildren();
        int i = children.size() - 1;
        while (i >= 0) {
            if (children.get(i) instanceof InteractionOperandEditPart) {
                lastIOEP = (InteractionOperandEditPart)((Object)children.get(i));
                break;
            }
            --i;
        }
        return lastIOEP;
    }

    public static InteractionOperandEditPart findPreviousIOEP(CombinedFragmentCombinedFragmentCompartmentEditPart compartEP, InteractionOperandEditPart currentIOEP) {
        InteractionOperandEditPart previousIOEP = null;
        List children = compartEP.getChildren();
        int i = 0;
        while (i < children.size() - 1) {
            if (children.get(i) instanceof InteractionOperandEditPart) {
                if (children.get(i) == currentIOEP) break;
                previousIOEP = (InteractionOperandEditPart)((Object)children.get(i));
            }
            ++i;
        }
        return previousIOEP;
    }

    public static InteractionOperandEditPart findLatterIOEP(CombinedFragmentCombinedFragmentCompartmentEditPart compartEP, InteractionOperandEditPart currentIOEP) {
        InteractionOperandEditPart latterIOEP = null;
        List children = compartEP.getChildren();
        int i = children.size() - 1;
        while (i > 0) {
            if (children.get(i) instanceof InteractionOperandEditPart) {
                if (children.get(i) == currentIOEP) break;
                latterIOEP = (InteractionOperandEditPart)((Object)children.get(i));
            }
            --i;
        }
        return latterIOEP;
    }

    public static void updateEditPartBounds(GraphicalEditPart editpart, Rectangle rect) {
        Node node;
        if (editpart.getModel() instanceof Node && (node = (Node)editpart.getModel()).getLayoutConstraint() instanceof Bounds) {
            Bounds bounds = (Bounds)node.getLayoutConstraint();
            OperandBoundsComputeHelper.updateBounds(bounds, rect, editpart.getEditingDomain());
        }
    }

    public static ICommand createUpdateEditPartBoundsCommand(final GraphicalEditPart editpart, final Rectangle rect) {
        AbstractTransactionalCommand cmd = new AbstractTransactionalCommand(editpart.getEditingDomain(), "Update Operand Bounds", null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                Node node;
                if (editpart.getModel() instanceof Node && (node = (Node)editpart.getModel()).getLayoutConstraint() instanceof Bounds) {
                    Bounds bounds = (Bounds)node.getLayoutConstraint();
                    OperandBoundsComputeHelper.fillBounds(bounds, rect);
                }
                return CommandResult.newOKCommandResult();
            }
        };
        return cmd;
    }

    public static ICommand createUpdateCFAndIOBoundsForCFCreationCommand(final EditPart editPart, final CreateViewRequest request) {
        if (!(editPart instanceof GraphicalEditPart)) {
            return null;
        }
        GraphicalEditPart graphicalEditPart = (GraphicalEditPart)editPart;
        AbstractTransactionalCommand cmd = new AbstractTransactionalCommand(graphicalEditPart.getEditingDomain(), "Create update operand bounds command", null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                OperandBoundsComputeHelper.updateCFAndIOBoundsForCFCreation((GraphicalEditPart)editPart, request);
                return CommandResult.newOKCommandResult();
            }
        };
        return cmd;
    }

    private static void updateCFAndIOBoundsForCFCreation(GraphicalEditPart parent, CreateViewRequest request) {
        Object subEditPart = null;
        if (parent instanceof InteractionInteractionCompartmentEditPart) {
            InteractionInteractionCompartmentEditPart interactionInteractionCompartmentEditPart = (InteractionInteractionCompartmentEditPart)parent;
            subEditPart = interactionInteractionCompartmentEditPart.getChildren().get(interactionInteractionCompartmentEditPart.getChildren().size() - 1);
        } else if (parent instanceof InteractionOperandEditPart) {
            InteractionOperandEditPart interactionOperandEditPart = (InteractionOperandEditPart)parent;
            subEditPart = interactionOperandEditPart.getChildren().get(interactionOperandEditPart.getChildren().size() - 1);
        }
        if (subEditPart != null && subEditPart instanceof CombinedFragmentEditPart) {
            InteractionOperandEditPart lastOperand;
            Shape shape;
            CombinedFragmentEditPart combinedFragmentEditPart = subEditPart;
            Rectangle cfEPAbsoluteRect = null;
            int labelContainerHeight = OperandBoundsComputeHelper.computeCombinedFragementHeaderHeight(combinedFragmentEditPart);
            Shape cfEPShape = (Shape)combinedFragmentEditPart.getModel();
            if (cfEPShape.getLayoutConstraint() instanceof Bounds) {
                if (request.getSize() == null) {
                    Dimension cfEPDefaultSize = new Dimension();
                    cfEPDefaultSize.setWidth(212);
                    cfEPDefaultSize.setHeight(61 + labelContainerHeight + 2);
                    cfEPAbsoluteRect = new Rectangle(request.getLocation(), cfEPDefaultSize);
                } else {
                    cfEPAbsoluteRect = new Rectangle(request.getLocation(), request.getSize());
                }
                Rectangle cfEPRelativeRect = cfEPAbsoluteRect.getCopy();
                combinedFragmentEditPart.getFigure().translateToRelative((Translatable)cfEPRelativeRect);
                Bounds cfEPBounds = (Bounds)cfEPShape.getLayoutConstraint();
                OperandBoundsComputeHelper.fillBounds(cfEPBounds, cfEPRelativeRect);
            }
            if ((shape = (Shape)(lastOperand = OperandBoundsComputeHelper.findLastIOEP((CombinedFragmentCombinedFragmentCompartmentEditPart)combinedFragmentEditPart.getChildBySemanticHint(UMLVisualIDRegistry.getType(7004)))).getModel()).getLayoutConstraint() instanceof Bounds) {
                Bounds bounds = (Bounds)shape.getLayoutConstraint();
                Rectangle rect = new Rectangle(bounds.getX(), bounds.getY(), cfEPAbsoluteRect.width() - 2, cfEPAbsoluteRect.height() - labelContainerHeight - 2);
                OperandBoundsComputeHelper.fillBounds(bounds, rect);
            }
        }
    }

    public static org.eclipse.gef.commands.Command createUpdateIOBoundsForCFResizeCommand(CompoundCommand compoundCmd, ChangeBoundsRequest request, CombinedFragmentEditPart combinedFragmentEditPart) {
        if (combinedFragmentEditPart.getChildren().size() > 0 && combinedFragmentEditPart.getChildren().get(0) instanceof CombinedFragmentCombinedFragmentCompartmentEditPart) {
            CombinedFragmentCombinedFragmentCompartmentEditPart compartment = (CombinedFragmentCombinedFragmentCompartmentEditPart)((Object)combinedFragmentEditPart.getChildren().get(0));
            CombinedFragment cf = (CombinedFragment)combinedFragmentEditPart.resolveSemanticElement();
            InteractionOperandEditPart targetIOEP = null;
            if ((request.getResizeDirection() & 1) != 0) {
                targetIOEP = OperandBoundsComputeHelper.findFirstIOEP(compartment);
            } else if ((request.getResizeDirection() & 4) != 0) {
                targetIOEP = OperandBoundsComputeHelper.findLastIOEP(compartment);
            }
            OperandBoundsComputeHelper.updateIOBoundsForCFResize(request, compoundCmd, compartment.getChildren(), cf, targetIOEP != null ? (InteractionOperand)targetIOEP.resolveSemanticElement() : null, request.getSizeDelta(), request.getResizeDirection());
        }
        return compoundCmd;
    }

    private static void updateIOBoundsForCFResize(ChangeBoundsRequest request, CompoundCommand compoundCmd, List<EditPart> combinedFragmentChildrenEditParts, CombinedFragment cf, InteractionOperand targetOperand, Dimension sizeDelta, int direction) {
        InteractionOperandEditPart targetOperandEditPart = OperandBoundsComputeHelper.findTargetOperandEditPart(cf, targetOperand, combinedFragmentChildrenEditParts);
        for (EditPart ep : combinedFragmentChildrenEditParts) {
            Shape ioEPShape;
            InteractionOperandEditPart ioEP;
            Object ioEPModel;
            if (!(ep instanceof InteractionOperandEditPart) || !((ioEPModel = (ioEP = (InteractionOperandEditPart)ep).getModel()) instanceof Shape) || !((ioEPShape = (Shape)ioEPModel).getLayoutConstraint() instanceof Bounds)) continue;
            Bounds ioEPOriginalBounds = (Bounds)ioEPShape.getLayoutConstraint();
            UpdateIOBoundsForCFResizeCommand cmd = new UpdateIOBoundsForCFResizeCommand(ioEP.getEditingDomain(), "Update operand bounds interaction command", ioEPOriginalBounds, request, sizeDelta, ioEP == targetOperandEditPart, direction);
            compoundCmd.add((org.eclipse.gef.commands.Command)new ICommandProxy((ICommand)cmd));
        }
    }

    public static void updateBounds(final Bounds bounds, final Rectangle rect, TransactionalEditingDomain transactionalEditingDomain) {
        if (bounds != null) {
            final Rectangle originalBounds = new Rectangle();
            originalBounds.setX(bounds.getX());
            originalBounds.setY(bounds.getY());
            originalBounds.setWidth(bounds.getWidth());
            originalBounds.setHeight(bounds.getHeight());
            AbstractCommand cmd = new AbstractCommand(){

                public boolean canExecute() {
                    return true;
                }

                public void execute() {
                    this.exec(rect);
                }

                public void redo() {
                    this.execute();
                }

                public void undo() {
                    this.exec(originalBounds);
                }

                public void exec(Rectangle rect2) {
                    OperandBoundsComputeHelper.fillBounds(bounds, rect2);
                }

                public boolean canUndo() {
                    return true;
                }
            };
            CommandHelper.executeCommandWithoutHistory((EditingDomain)transactionalEditingDomain, (Command)cmd, true);
        }
    }

    public static InteractionOperandEditPart findTargetOperandEditPart(CombinedFragment cf, InteractionOperand targetOperand, List<EditPart> combinedFragmentChildrenEditParts) {
        if (targetOperand == null) {
            return null;
        }
        for (EditPart ep : combinedFragmentChildrenEditParts) {
            if (!(ep instanceof InteractionOperandEditPart)) continue;
            InteractionOperandEditPart ioEP = (InteractionOperandEditPart)ep;
            InteractionOperand io = (InteractionOperand)ioEP.resolveSemanticElement();
            if (!cf.getOperands().contains((Object)io) || !targetOperand.equals(io)) continue;
            return ioEP;
        }
        return null;
    }

    public static Bounds getEditPartBounds(GraphicalEditPart editPart) {
        Node node;
        if (editPart.getModel() instanceof Node && (node = (Node)editPart.getModel()).getLayoutConstraint() instanceof Bounds) {
            Bounds bounds = (Bounds)node.getLayoutConstraint();
            return bounds;
        }
        return null;
    }

    public static Rectangle fillRectangle(Bounds source) {
        if (source == null) {
            return null;
        }
        Rectangle target = new Rectangle();
        target.setX(source.getX());
        target.setY(source.getY());
        target.setWidth(source.getWidth());
        target.setHeight(source.getHeight());
        return target;
    }

    public static Bounds fillBounds(Bounds bounds, Rectangle source) {
        if (bounds == null || source == null) {
            return null;
        }
        bounds.setX(source.x());
        bounds.setY(source.y());
        bounds.setWidth(source.width());
        bounds.setHeight(source.height());
        return bounds;
    }

    public static Bounds getInteractionOperandEPBounds(GraphicalEditPart operandEP) {
        Shape lastOperandShape;
        Object lastChildModel = operandEP.getModel();
        if (lastChildModel instanceof Shape && (lastOperandShape = (Shape)lastChildModel).getLayoutConstraint() instanceof Bounds) {
            return (Bounds)lastOperandShape.getLayoutConstraint();
        }
        return null;
    }

    public static org.eclipse.gef.commands.Command createIOEPResizeCommand(InteractionOperandEditPart currentIOEP, int heightDelta, CombinedFragmentCombinedFragmentCompartmentEditPart compartEP, int direction) {
        Bounds currentIOEPBounds = OperandBoundsComputeHelper.getEditPartBounds((GraphicalEditPart)currentIOEP);
        if (currentIOEPBounds == null) {
            return null;
        }
        InteractionOperandEditPart targetIOEP = null;
        if ((direction & 1) != 0) {
            targetIOEP = OperandBoundsComputeHelper.findPreviousIOEP(compartEP, currentIOEP);
        } else if ((direction & 4) != 0) {
            targetIOEP = OperandBoundsComputeHelper.findLatterIOEP(compartEP, currentIOEP);
        }
        CompositeCommand compositeCommand = new CompositeCommand("Resize Operand");
        if (targetIOEP == null) {
            Node node;
            CombinedFragmentEditPart parent;
            if (heightDelta < 0 && currentIOEPBounds.getHeight() - Math.abs(heightDelta) < 61) {
                return null;
            }
            Rectangle currentIOEPRect = OperandBoundsComputeHelper.fillRectangle(currentIOEPBounds);
            currentIOEPRect.setHeight(currentIOEPBounds.getHeight() + heightDelta);
            ICommand currentIOEPCommand = OperandBoundsComputeHelper.createUpdateEditPartBoundsCommand((GraphicalEditPart)currentIOEP, currentIOEPRect);
            compositeCommand.add((IUndoableOperation)currentIOEPCommand);
            if (compartEP.getParent() instanceof CombinedFragmentEditPart && (parent = (CombinedFragmentEditPart)compartEP.getParent()).getModel() instanceof Node && (node = (Node)parent.getModel()).getLayoutConstraint() instanceof Bounds) {
                Bounds containerBounds = (Bounds)node.getLayoutConstraint();
                Dimension preferredSize = parent.getFigure().getPreferredSize();
                int width = containerBounds.getWidth() != -1 ? containerBounds.getWidth() : preferredSize.width();
                int height = containerBounds.getHeight() != -1 ? containerBounds.getHeight() : preferredSize.height();
                Rectangle containerRect = new Rectangle(containerBounds.getX(), containerBounds.getY(), width, height += heightDelta);
                compositeCommand.add((IUndoableOperation)OperandBoundsComputeHelper.createUpdateEditPartBoundsCommand((GraphicalEditPart)parent, containerRect));
            }
        } else {
            Bounds targetIOEPBounds = OperandBoundsComputeHelper.getEditPartBounds((GraphicalEditPart)targetIOEP);
            if (targetIOEPBounds == null) {
                return null;
            }
            if (heightDelta > 0 ? targetIOEPBounds.getHeight() - heightDelta < 61 : currentIOEPBounds.getHeight() - Math.abs(heightDelta) < 61) {
                return null;
            }
            Rectangle targetIOEPRect = OperandBoundsComputeHelper.fillRectangle(targetIOEPBounds);
            Rectangle currentIOEPRect = OperandBoundsComputeHelper.fillRectangle(currentIOEPBounds);
            targetIOEPRect.setHeight(targetIOEPBounds.getHeight() - heightDelta);
            currentIOEPRect.setHeight(currentIOEPBounds.getHeight() + heightDelta);
            if ((direction & 1) != 0) {
                currentIOEPRect.setY(currentIOEPRect.y() - heightDelta);
            } else if ((direction & 4) != 0) {
                targetIOEPRect.setY(targetIOEPRect.y() + heightDelta);
            }
            ICommand previousIOEPCommand = OperandBoundsComputeHelper.createUpdateEditPartBoundsCommand((GraphicalEditPart)targetIOEP, targetIOEPRect);
            ICommand currentIOEPCommand = OperandBoundsComputeHelper.createUpdateEditPartBoundsCommand((GraphicalEditPart)currentIOEP, currentIOEPRect);
            compositeCommand.add((IUndoableOperation)previousIOEPCommand);
            compositeCommand.add((IUndoableOperation)currentIOEPCommand);
        }
        return new ICommandProxy((ICommand)compositeCommand);
    }

    public static int computeCombinedFragementHeaderHeight(CombinedFragmentEditPart combinedFragmentEditPart) {
        int headerHeight = 0;
        IFigure labelContainer = combinedFragmentEditPart.getPrimaryShape().getHeaderLabel().getParent();
        if (labelContainer != null) {
            headerHeight = labelContainer.getPreferredSize().height();
        }
        return headerHeight;
    }

    public static boolean checkRedistrictOnCFResize(ChangeBoundsRequest request, EditPart child) {
        CombinedFragmentEditPart combinedFragmentEditPart;
        if (child instanceof CombinedFragmentEditPart && (request.getResizeDirection() & 5) != 0 && (combinedFragmentEditPart = (CombinedFragmentEditPart)child).getChildren().size() > 0 && combinedFragmentEditPart.getChildren().get(0) instanceof CombinedFragmentCombinedFragmentCompartmentEditPart) {
            CombinedFragmentCombinedFragmentCompartmentEditPart compartment = (CombinedFragmentCombinedFragmentCompartmentEditPart)((Object)combinedFragmentEditPart.getChildren().get(0));
            List combinedFragmentChildrenEditParts = compartment.getChildren();
            CombinedFragment cf = (CombinedFragment)combinedFragmentEditPart.resolveSemanticElement();
            InteractionOperand targetOperand = null;
            if ((request.getResizeDirection() & 1) != 0) {
                targetOperand = (InteractionOperand)cf.getOperands().get(0);
            } else if ((request.getResizeDirection() & 4) != 0) {
                targetOperand = (InteractionOperand)cf.getOperands().get(cf.getOperands().size() - 1);
            }
            InteractionOperandEditPart targetOperandEditPart = OperandBoundsComputeHelper.findTargetOperandEditPart(cf, targetOperand, combinedFragmentChildrenEditParts);
            if (targetOperandEditPart != null) {
                int height = targetOperandEditPart.getFigure().getBounds().height();
                int heightDelta = request.getSizeDelta().height();
                if (heightDelta < 0 && height - Math.abs(heightDelta) < 61) {
                    return false;
                }
            }
        }
        return true;
    }

    public static void addUpdateBoundsCommandForOperandDelelete(EditPart editPart, ICompositeCommand cmd) {
        CombinedFragmentCombinedFragmentCompartmentEditPart compartment;
        if (editPart instanceof InteractionOperandEditPart && editPart.getParent() instanceof CombinedFragmentCombinedFragmentCompartmentEditPart && (compartment = (CombinedFragmentCombinedFragmentCompartmentEditPart)editPart.getParent()).getParent() instanceof CombinedFragmentEditPart) {
            Shape latterIOEPShape;
            Object latterIOEPModel;
            List combinedFragmentChildrenEditParts = compartment.getChildren();
            InteractionOperandEditPart previousIOEP = null;
            InteractionOperandEditPart latterIOEP = null;
            boolean isFirstOperand = false;
            InteractionOperandEditPart currentioEP = (InteractionOperandEditPart)editPart;
            final Rectangle currentioEPBounds = currentioEP.getFigure().getBounds();
            int i = 0;
            while (i < combinedFragmentChildrenEditParts.size()) {
                EditPart ep = (EditPart)combinedFragmentChildrenEditParts.get(i);
                if (ep instanceof InteractionOperandEditPart) {
                    InteractionOperandEditPart ioEP = (InteractionOperandEditPart)ep;
                    if (currentioEP == ioEP) {
                        if (previousIOEP != null) {
                            Shape previousIOEPShape;
                            Object previousIOEPModel = previousIOEP.getModel();
                            if (!(previousIOEPModel instanceof Shape) || !((previousIOEPShape = (Shape)previousIOEPModel).getLayoutConstraint() instanceof Bounds)) break;
                            final Bounds previousIOEPOriginalBounds = (Bounds)previousIOEPShape.getLayoutConstraint();
                            AbstractTransactionalCommand command = new AbstractTransactionalCommand(previousIOEP.getEditingDomain(), "Merge operand bounds command", null){

                                protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                                    previousIOEPOriginalBounds.setHeight(previousIOEPOriginalBounds.getHeight() + currentioEPBounds.height());
                                    return CommandResult.newOKCommandResult();
                                }
                            };
                            cmd.add((IUndoableOperation)command);
                            break;
                        }
                        isFirstOperand = true;
                    } else {
                        previousIOEP = ioEP;
                        if (isFirstOperand) {
                            latterIOEP = ioEP;
                            break;
                        }
                    }
                }
                ++i;
            }
            if (isFirstOperand && latterIOEP != null && (latterIOEPModel = latterIOEP.getModel()) instanceof Shape && (latterIOEPShape = (Shape)latterIOEPModel).getLayoutConstraint() instanceof Bounds) {
                final Bounds latterIOEPOriginalBounds = (Bounds)latterIOEPShape.getLayoutConstraint();
                AbstractTransactionalCommand command = new AbstractTransactionalCommand(previousIOEP.getEditingDomain(), "Merge operand bounds command", null){

                    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                        latterIOEPOriginalBounds.setY(0);
                        latterIOEPOriginalBounds.setHeight(latterIOEPOriginalBounds.getHeight() + currentioEPBounds.height());
                        return CommandResult.newOKCommandResult();
                    }
                };
                cmd.add((IUndoableOperation)command);
            }
        }
    }

    public static void addUpdateBoundsForIOCreationCommand(CombinedFragmentCombinedFragmentCompartmentEditPart compartment, CreateViewRequest.ViewDescriptor viewDescriptor, CompositeCommand command) {
        Node node;
        CombinedFragmentEditPart parent;
        List children = compartment.getChildren();
        if (children != null && children.size() > 0) {
            Bounds lastOperandBounds;
            InteractionOperandEditPart lastOperandEP = OperandBoundsComputeHelper.findLastIOEP(compartment);
            if (lastOperandEP != null && (lastOperandBounds = OperandBoundsComputeHelper.getInteractionOperandEPBounds((GraphicalEditPart)lastOperandEP)) != null) {
                Node node2;
                CombinedFragmentEditPart parent2;
                Rectangle rect = new Rectangle(lastOperandBounds.getX(), lastOperandBounds.getY() + lastOperandBounds.getHeight(), lastOperandBounds.getWidth(), 61);
                if (compartment.getParent() instanceof CombinedFragmentEditPart && (parent2 = (CombinedFragmentEditPart)compartment.getParent()).getModel() instanceof Node && (node2 = (Node)parent2.getModel()).getLayoutConstraint() instanceof Bounds) {
                    Bounds containerBounds = (Bounds)node2.getLayoutConstraint();
                    Dimension preferredSize = parent2.getFigure().getPreferredSize();
                    int width = containerBounds.getWidth() != -1 ? containerBounds.getWidth() : preferredSize.width();
                    int height = containerBounds.getHeight() != -1 ? containerBounds.getHeight() : preferredSize.height();
                    View shapeView = (View)parent2.getModel();
                    SetBoundsCommand setParentBoundsCmd = new SetBoundsCommand(compartment.getEditingDomain(), DiagramUIMessages.SetLocationCommand_Label_Resize, (IAdaptable)new EObjectAdapter((EObject)shapeView), new Rectangle(containerBounds.getX(), containerBounds.getY(), width, height += 61));
                    command.add((IUndoableOperation)setParentBoundsCmd);
                }
                command.add((IUndoableOperation)new SetBoundsCommand(compartment.getEditingDomain(), DiagramUIMessages.SetLocationCommand_Label_Resize, (IAdaptable)viewDescriptor, rect));
            }
        } else if (compartment.getParent() instanceof CombinedFragmentEditPart && (parent = (CombinedFragmentEditPart)compartment.getParent()).getModel() instanceof Node && (node = (Node)parent.getModel()).getLayoutConstraint() instanceof Bounds) {
            Bounds containerBounds = (Bounds)node.getLayoutConstraint();
            Dimension preferredSize = parent.getFigure().getPreferredSize();
            int width = containerBounds.getWidth() != -1 ? containerBounds.getWidth() : preferredSize.width();
            int height = containerBounds.getHeight() != -1 ? containerBounds.getHeight() : preferredSize.height();
            command.add((IUndoableOperation)new SetBoundsCommand(compartment.getEditingDomain(), DiagramUIMessages.SetLocationCommand_Label_Resize, (IAdaptable)viewDescriptor, new Rectangle(0, 0, width - 2, (height -= OperandBoundsComputeHelper.computeCombinedFragementHeaderHeight(parent)) - 2)));
        }
    }

    public static boolean isDerivedCombinedFragment(String hint) {
        if (((IHintedType)UMLElementTypes.CombinedFragment_3004).getSemanticHint().equals(hint)) {
            return true;
        }
        return ((IHintedType)UMLElementTypes.ConsiderIgnoreFragment_3007).getSemanticHint().equals(hint);
    }

    private static final class UpdateIOBoundsForCFResizeCommand
    extends AbstractTransactionalCommand {
        private final Bounds ioEPOriginalBounds;
        private final ChangeBoundsRequest request;
        private final Dimension sizeDelta;
        private boolean updateHeight = false;
        private int direction;

        private UpdateIOBoundsForCFResizeCommand(TransactionalEditingDomain domain, String label, Bounds ioEPOriginalBounds, ChangeBoundsRequest request, Dimension sizeDelta, boolean updateHeight, int direction) {
            super(domain, label, null);
            this.ioEPOriginalBounds = ioEPOriginalBounds;
            this.request = request;
            this.sizeDelta = sizeDelta;
            this.updateHeight = updateHeight;
            this.direction = direction;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            if (this.updateHeight) {
                this.ioEPOriginalBounds.setHeight(this.ioEPOriginalBounds.getHeight() + this.sizeDelta.height());
            } else if ((this.direction & 1) != 0) {
                this.ioEPOriginalBounds.setY(this.ioEPOriginalBounds.getY() + this.sizeDelta.height());
            }
            if ((this.request.getResizeDirection() & 0x18) != 0) {
                this.ioEPOriginalBounds.setWidth(this.ioEPOriginalBounds.getWidth() + this.sizeDelta.width());
            }
            return CommandResult.newOKCommandResult();
        }
    }
}

