/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.tools.providers;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.papyrus.uml.tools.providers.ServiceEditFilteredContentProvider;
import org.eclipse.papyrus.uml.tools.utils.UMLUtil;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.InstanceValue;
import org.eclipse.uml2.uml.Type;

public class InstanceValueContentProvider
extends ServiceEditFilteredContentProvider {
    private InstanceValue source;

    public InstanceValueContentProvider(InstanceValue source, EStructuralFeature feature, ResourceSet root) {
        super((EObject)source, feature, root);
        this.source = source;
    }

    public InstanceValueContentProvider(InstanceValue source, EStructuralFeature feature, EObject[] roots) {
        super((EObject)source, feature, roots);
        this.source = source;
    }

    public boolean isValidValue(Object element) {
        if (!super.isValidValue(element)) {
            return false;
        }
        if (this.source.getType() == null) {
            return true;
        }
        Type type = this.source.getType();
        InstanceSpecification instance = (InstanceSpecification)UMLUtil.resolveUMLElement((Object)element);
        if (type instanceof Enumeration) {
            return ((Enumeration)type).getOwnedLiterals().contains((Object)instance);
        }
        if (type instanceof Classifier) {
            Classifier classifier = (Classifier)type;
            if (instance.getClassifiers().contains((Object)classifier)) {
                return true;
            }
            for (Classifier implementedClassifier : instance.getClassifiers()) {
                if (!implementedClassifier.conformsTo(classifier)) continue;
                return true;
            }
            return false;
        }
        return true;
    }
}

