/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.textedit.constraintwithessentialocl.xtext;

import com.google.inject.Injector;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.ocl.examples.pivot.Class;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.context.ClassContext;
import org.eclipse.ocl.examples.pivot.context.EClassContext;
import org.eclipse.ocl.examples.pivot.context.OperationContext;
import org.eclipse.ocl.examples.pivot.context.ParserContext;
import org.eclipse.ocl.examples.pivot.context.PropertyContext;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.uml.UML2Ecore2Pivot;
import org.eclipse.ocl.examples.pivot.utilities.BaseResource;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.extensionpoints.editors.ui.IPopupEditorHelper;
import org.eclipse.papyrus.infra.core.Activator;
import org.eclipse.papyrus.uml.textedit.constraintwithessentialocl.xtext.EssentialOCLPartialModelEditor;
import org.eclipse.papyrus.uml.textedit.constraintwithessentialocl.xtext.EssentialOCLPopupPlugin;
import org.eclipse.papyrus.uml.textedit.constraintwithessentialocl.xtext.IXtextEMFReconcilerWithContext;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.LiteralString;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.xtext.gmf.glue.PopupEditorConfiguration;
import org.eclipse.xtext.gmf.glue.edit.part.DefaultXtextSemanticValidator;
import org.eclipse.xtext.gmf.glue.edit.part.IXTextSemanticValidator;
import org.eclipse.xtext.gmf.glue.edit.part.IXtextEMFReconciler;
import org.eclipse.xtext.gmf.glue.edit.part.PopupXtextEditorHelper;
import org.eclipse.xtext.gmf.glue.partialEditing.SourceViewerHandle;
import org.eclipse.xtext.resource.XtextResource;

public class EssentialOCLPopupEditorConfiguration
extends PopupEditorConfiguration {
    protected PopupXtextEditorHelper editorHelper = null;

    public IPopupEditorHelper createPopupEditorHelper(Object editPart) {
        this.editorHelper = null;
        if (!(editPart instanceof IGraphicalEditPart)) {
            return null;
        }
        IGraphicalEditPart graphicalEditPart = (IGraphicalEditPart)editPart;
        Object model = graphicalEditPart.getModel();
        if (model == null) {
            return null;
        }
        if (!(model instanceof View)) {
            return null;
        }
        View view = (View)model;
        EObject element = view.getElement();
        if (element == null) {
            return null;
        }
        if (!(element instanceof Constraint)) {
            return null;
        }
        Constraint constraint = (Constraint)element;
        ValueSpecification specification = constraint.getSpecification();
        if (specification == null) {
            return null;
        }
        if (!(specification instanceof LiteralString) && !(specification instanceof OpaqueExpression)) {
            return null;
        }
        Injector xtextInjector = EssentialOCLPopupPlugin.getInstance().getInjector("org.eclipse.ocl.examples.xtext.essentialocl.EssentialOCL");
        Reconciler modelReconciler = new Reconciler();
        String textToEdit = this.getTextToEdit(element);
        String fileExtension = "essentialocl";
        DefaultXtextSemanticValidator semanticValidator = new DefaultXtextSemanticValidator();
        SourceViewerHandle.bindPartialModelEditorClass(EssentialOCLPartialModelEditor.class);
        this.editorHelper = (PopupXtextEditorHelper)super.createPopupEditorHelper(graphicalEditPart, xtextInjector, (IXtextEMFReconciler)modelReconciler, textToEdit, fileExtension, (IXTextSemanticValidator)semanticValidator);
        return this.editorHelper;
    }

    protected Element getPivotModel(EObject umlObject, MetaModelManager metaModelManager) {
        Resource umlResource = umlObject.eResource();
        if (umlResource == null) {
            return null;
        }
        UML2Ecore2Pivot adapter = UML2Ecore2Pivot.getAdapter((Resource)umlResource, (MetaModelManager)metaModelManager);
        adapter.dispose();
        adapter = UML2Ecore2Pivot.getAdapter((Resource)umlResource, (MetaModelManager)metaModelManager);
        adapter.getPivotRoot();
        return adapter.getCreated(Element.class, umlObject);
    }

    public String getTextToEdit(Object editedObject) {
        Constraint umlConstraint = (Constraint)editedObject;
        String value = "";
        if (umlConstraint.getSpecification() != null) {
            if (umlConstraint.getSpecification() instanceof LiteralString) {
                if (((LiteralString)umlConstraint.getSpecification()).getValue() != null) {
                    value = String.valueOf(value) + ((LiteralString)umlConstraint.getSpecification()).getValue();
                }
            } else if (umlConstraint.getSpecification() instanceof OpaqueExpression) {
                int indexOfOCLBody = -1;
                OpaqueExpression opaqueExpression = (OpaqueExpression)umlConstraint.getSpecification();
                int i = 0;
                while (i < opaqueExpression.getLanguages().size() && indexOfOCLBody == -1) {
                    if (((String)opaqueExpression.getLanguages().get(i)).equals("OCL")) {
                        value = String.valueOf(value) + (String)opaqueExpression.getBodies().get(i);
                        indexOfOCLBody = i;
                    }
                    ++i;
                }
            }
        }
        return value;
    }

    public class Reconciler
    implements IXtextEMFReconcilerWithContext {
        public void configureResource(XtextResource resource, EObject umlObject) {
            if (resource instanceof BaseResource) {
                BaseResource baseResource = (BaseResource)resource;
                ResourceSet resourceSet = baseResource.getResourceSet();
                MetaModelManager metaModelManager = MetaModelManager.getAdapter((ResourceSet)resourceSet);
                if (umlObject instanceof org.eclipse.uml2.uml.Element) {
                    baseResource.setParserContext(this.getParserContext((org.eclipse.uml2.uml.Element)umlObject, metaModelManager));
                }
            }
        }

        public ParserContext getParserContext(org.eclipse.uml2.uml.Element modelelement, MetaModelManager metaModelManager) {
            EClassContext parserContext = null;
            if (this.isInProfileContext(modelelement)) {
                Element pivotElement = EssentialOCLPopupEditorConfiguration.this.getPivotModel((EObject)modelelement, metaModelManager);
                URI uri = metaModelManager.getResourceIdentifier((Object)modelelement, null);
                if (pivotElement instanceof Property) {
                    parserContext = new PropertyContext(metaModelManager, uri, (Property)pivotElement);
                } else if (pivotElement instanceof Operation) {
                    parserContext = new OperationContext(metaModelManager, uri, (Operation)pivotElement, null);
                } else if (pivotElement instanceof Class) {
                    parserContext = new ClassContext(metaModelManager, uri, (Type)((Class)pivotElement));
                } else {
                    Activator.log.error("Unknown context type", (Throwable)new ExecutionException("Unknown context type for " + modelelement));
                }
            } else {
                parserContext = new EClassContext(metaModelManager, null, (EClassifier)modelelement.eClass());
            }
            return parserContext;
        }

        protected boolean isInProfileContext(org.eclipse.uml2.uml.Element element) {
            if (element instanceof Profile) {
                return true;
            }
            if (element.getOwner() != null) {
                return this.isInProfileContext(element.getOwner());
            }
            return false;
        }

        public void reconcile(EObject modelObject, EObject xtextObject) {
            if (!(modelObject instanceof Constraint)) {
                return;
            }
            String newTextualRepresentation = EssentialOCLPopupEditorConfiguration.this.editorHelper.getSourceViewerHandle().getDocument().get();
            TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)((Constraint)modelObject));
            UpdateConstraintCommand updateCommand = new UpdateConstraintCommand(editingDomain, (Constraint)modelObject, newTextualRepresentation);
            editingDomain.getCommandStack().execute((Command)new GMFtoEMFCommandWrapper((ICommand)updateCommand));
        }
    }

    protected class UpdateConstraintCommand
    extends AbstractTransactionalCommand {
        protected final Constraint constraint;
        protected final String newTextualRepresentation;

        public UpdateConstraintCommand(TransactionalEditingDomain editingDomain, Constraint constraint, String newTextualRepresentation) {
            super(editingDomain, "Constraint Update", UpdateConstraintCommand.getWorkspaceFiles((EObject)constraint));
            this.constraint = constraint;
            this.newTextualRepresentation = newTextualRepresentation;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor arg0, IAdaptable arg1) throws ExecutionException {
            OpaqueExpression opaqueExpression = null;
            int indexOfOCLBody = -1;
            if (this.constraint.getSpecification() == null || !(this.constraint.getSpecification() instanceof OpaqueExpression)) {
                opaqueExpression = UMLFactory.eINSTANCE.createOpaqueExpression();
            } else {
                opaqueExpression = (OpaqueExpression)this.constraint.getSpecification();
                int i = 0;
                while (i < opaqueExpression.getLanguages().size() && indexOfOCLBody == -1) {
                    if (((String)opaqueExpression.getLanguages().get(i)).equals("OCL")) {
                        indexOfOCLBody = i;
                    }
                    ++i;
                }
            }
            if (indexOfOCLBody == -1) {
                opaqueExpression.getLanguages().add((Object)"OCL");
                opaqueExpression.getBodies().add((Object)this.newTextualRepresentation);
            } else {
                opaqueExpression.getBodies().remove(indexOfOCLBody);
                opaqueExpression.getBodies().add(indexOfOCLBody, (Object)this.newTextualRepresentation);
            }
            this.constraint.setSpecification((ValueSpecification)opaqueExpression);
            return CommandResult.newOKCommandResult((Object)this.constraint);
        }
    }
}

