/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.modelexplorer.resourceloading.handler;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.notation.NotationUtils;
import org.eclipse.papyrus.infra.services.resourceloading.util.LoadingUtils;
import org.eclipse.papyrus.views.modelexplorer.handler.AbstractCommandHandler;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class UnloadResourceHandler
extends AbstractCommandHandler {
    protected Command getCommand() {
        TransactionalEditingDomain editingDomain = this.getEditingDomain();
        List selection = this.getSelectedElements();
        if (editingDomain != null && editingDomain.getResourceSet() instanceof ModelSet && selection.size() > 0) {
            final ModelSet set = (ModelSet)editingDomain.getResourceSet();
            CompoundCommand command = new CompoundCommand();
            ArrayList<URI> handledURI = new ArrayList<URI>();
            URI mainURI = NotationUtils.getNotationModel((ModelSet)set).getResourceURI().trimFileExtension();
            handledURI.add(mainURI);
            for (EObject sel : selection) {
                URI uriTrim;
                if (sel.eIsProxy() || handledURI.contains(uriTrim = sel.eResource().getURI().trimFileExtension())) continue;
                handledURI.add(uriTrim);
                AbstractCommand cmd = new AbstractCommand(){

                    public void redo() {
                        LoadingUtils.unloadResourcesFromModelSet((ModelSet)set, (URI)uriTrim);
                    }

                    public void execute() {
                        this.redo();
                    }

                    public boolean canExecute() {
                        return true;
                    }
                };
                command.append((Command)cmd);
            }
            return command;
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected IEditorPart getEditor() {
        IWorkbenchPage activePage;
        IEditorPart editor = null;
        IWorkbenchWindow activeWorkbenchWindow = this.getActiveWorkbenchWindow();
        if (activeWorkbenchWindow != null && (activePage = activeWorkbenchWindow.getActivePage()) != null) {
            editor = activePage.getActiveEditor();
        }
        return editor;
    }

    protected IWorkbenchWindow getActiveWorkbenchWindow() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null) {
            return workbench.getActiveWorkbenchWindow();
        }
        return null;
    }
}

