/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.extensionpoints.editors.ui;

import org.eclipse.papyrus.extensionpoints.editors.ui.EmbeddedTextEditor;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class CloseListener
implements ControlListener,
MouseListener,
DisposeListener,
FocusListener,
KeyListener,
TraverseListener,
Listener {
    private final Control control;
    private final EmbeddedTextEditor editor;
    private final Composite composite;

    public CloseListener(Control control, EmbeddedTextEditor editor, Composite composite) {
        this.control = control;
        this.editor = editor;
        this.composite = composite;
        this.install();
    }

    private void install() {
        if (this.isControlValid()) {
            Display display = this.control.getShell().getDisplay();
            display.addListener(1, (Listener)this);
            display.addListener(31, (Listener)this);
            display.addFilter(0, (Listener)this);
            this.control.getShell().addControlListener((ControlListener)this);
            this.control.getShell().addKeyListener((KeyListener)this);
            this.control.addListener(1, (Listener)this);
            this.control.addTraverseListener((TraverseListener)this);
            this.control.addMouseListener((MouseListener)this);
            this.control.addDisposeListener((DisposeListener)this);
            this.control.addFocusListener((FocusListener)this);
            this.control.addControlListener((ControlListener)this);
        }
    }

    protected boolean isControlValid() {
        return this.control != null && !this.control.isDisposed();
    }

    private void uninstall() {
        if (this.isControlValid()) {
            Display display = this.control.getShell().getDisplay();
            display.removeListener(1, (Listener)this);
            display.removeListener(31, (Listener)this);
            this.control.getShell().removeControlListener((ControlListener)this);
            this.control.getShell().removeKeyListener((KeyListener)this);
            this.control.removeListener(1, (Listener)this);
            this.control.removeTraverseListener((TraverseListener)this);
            this.control.removeMouseListener((MouseListener)this);
            this.control.removeDisposeListener((DisposeListener)this);
            this.control.removeFocusListener((FocusListener)this);
            this.control.removeControlListener((ControlListener)this);
        }
    }

    public void controlResized(ControlEvent e) {
        this.editor.close(false);
    }

    public void controlMoved(ControlEvent e) {
        this.editor.close(false);
    }

    public void mouseDown(MouseEvent e) {
        this.editor.close(true);
    }

    public void mouseUp(MouseEvent e) {
    }

    public void mouseDoubleClick(MouseEvent e) {
        this.editor.close(false);
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        this.editor.close(true);
    }

    public void widgetDisposed(DisposeEvent e) {
        this.editor.close(false);
    }

    public void close() {
        this.uninstall();
        if (this.composite != null && !this.composite.isDisposed()) {
            this.composite.setVisible(false);
            this.composite.dispose();
        }
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTraversed(TraverseEvent e) {
        if (27 == e.keyCode) {
            this.editor.close(false);
            e.doit = false;
        }
    }

    public void handleEvent(Event event) {
    }
}

