/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.extensionpoints.editors.ui;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.papyrus.extensionpoints.editors.configuration.IAdvancedEditorConfiguration;
import org.eclipse.papyrus.extensionpoints.editors.configuration.IDirectEditorConfiguration;
import org.eclipse.papyrus.extensionpoints.editors.configuration.IPopupEditorConfiguration;
import org.eclipse.papyrus.extensionpoints.editors.definition.DirectEditorExtensionPoint;
import org.eclipse.papyrus.extensionpoints.editors.ui.ExtendedDirectEditionDialog;
import org.eclipse.papyrus.extensionpoints.editors.ui.ILabelEditorDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public abstract class OpenEmbeddedTextEditorObjectActionDelegate
implements IObjectActionDelegate {
    protected IWorkbenchPart part = null;
    private DirectEditorExtensionPoint directEditorExtensionPoint;

    protected abstract EObject getEditedObject();

    protected abstract GraphicalEditPart getSelectedElement();

    protected abstract Point getPosition();

    protected abstract Control getControl();

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.part = targetPart;
    }

    public void run(IAction action) {
        final IDirectEditorConfiguration configuration = this.directEditorExtensionPoint.getDirectEditorConfiguration();
        configuration.preEditAction(this.getEditedObject());
        Dialog dialog = null;
        if (configuration instanceof IPopupEditorConfiguration) {
            IPopupEditorConfiguration popupEditor = (IPopupEditorConfiguration)configuration;
            popupEditor.createPopupEditorHelper(this.getSelectedElement()).showEditor();
            return;
        }
        if (configuration instanceof IAdvancedEditorConfiguration) {
            dialog = ((IAdvancedEditorConfiguration)configuration).createDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), this.getEditedObject(), configuration.getTextToEdit(this.getEditedObject()));
        } else if (configuration instanceof IDirectEditorConfiguration) {
            dialog = new ExtendedDirectEditionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), this.getEditedObject(), configuration.getTextToEdit(this.getEditedObject()), configuration);
        } else {
            return;
        }
        final Dialog finalDialog = dialog;
        if (dialog.open() == 0) {
            TransactionalEditingDomain domain = ((DiagramEditor)this.part).getEditingDomain();
            RecordingCommand command = new RecordingCommand(domain, "Edit Label"){

                protected void doExecute() {
                    configuration.postEditAction(OpenEmbeddedTextEditorObjectActionDelegate.this.getEditedObject(), ((ILabelEditorDialog)finalDialog).getValue());
                }
            };
            domain.getCommandStack().execute((Command)command);
        }
    }

    public void setExtensionPointConfiguration(DirectEditorExtensionPoint directEditorExtensionPoint) {
        this.directEditorExtensionPoint = directEditorExtensionPoint;
    }

    protected abstract Composite getParentComposite();

    public static boolean isValid(Widget widget) {
        return widget != null && !widget.isDisposed();
    }
}

