/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.table.common.advice;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableInstance;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableinstancePackage;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.TableInstance2;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.commands.DuplicateEObjectsCommand;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.DuplicateElementsRequest;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IPageMngr;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForResource;
import org.eclipse.papyrus.infra.table.common.Activator;
import org.eclipse.papyrus.infra.table.instance.papyrustableinstance.PapyrusTableInstance;
import org.eclipse.papyrus.infra.table.instance.papyrustableinstance.PapyrustableinstancePackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableDuplicateEditHelperAdvice
extends AbstractEditHelperAdvice {
    protected ICommand getBeforeDuplicateCommand(DuplicateElementsRequest request) {
        Object additional = request.getParameter("Additional_Duplicated_Elements");
        if (!(additional instanceof Set)) {
            return super.getBeforeDuplicateCommand(request);
        }
        Set duplicatedObjects = (Set)additional;
        EObject object = this.getDuplicatedEObject(request);
        if (object == null) {
            return super.getBeforeDuplicateCommand(request);
        }
        List<PapyrusTableInstance> tablesToDuplicate = this.getRelatedTables(object, true);
        if (!tablesToDuplicate.isEmpty()) {
            CompositeCommand command = null;
            for (PapyrusTableInstance tableToDuplicate : tablesToDuplicate) {
                if (duplicatedObjects.contains(tableToDuplicate)) continue;
                if (command == null) {
                    command = new CompositeCommand("", Arrays.asList(new DuplicatePapyrusTableCommand(request.getEditingDomain(), "Duplicate Table", tableToDuplicate, request.getAllDuplicatedElementsMap())));
                } else {
                    command.add((IUndoableOperation)new DuplicatePapyrusTableCommand(request.getEditingDomain(), "Duplicate Table", tableToDuplicate, request.getAllDuplicatedElementsMap()));
                }
                duplicatedObjects.add(tableToDuplicate);
            }
            if (command != null) {
                if (super.getBeforeDuplicateCommand(request) != null) {
                    command.add((IUndoableOperation)super.getBeforeDuplicateCommand(request));
                    return command.reduce();
                }
                return command.reduce();
            }
        }
        return super.getBeforeDuplicateCommand(request);
    }

    protected EObject getDuplicatedEObject(DuplicateElementsRequest request) {
        List elementsToBeDuplicated = request.getElementsToBeDuplicated();
        if (elementsToBeDuplicated == null || elementsToBeDuplicated.isEmpty()) {
            return null;
        }
        Object elementToBeDuplicated = elementsToBeDuplicated.get(0);
        if (elementToBeDuplicated instanceof EObject) {
            return (EObject)elementToBeDuplicated;
        }
        return null;
    }

    protected List<PapyrusTableInstance> getRelatedTables(EObject object, boolean lookInChildren) {
        ArrayList<PapyrusTableInstance> tables = new ArrayList<PapyrusTableInstance>();
        ResourceSet resourceSet = object.eResource().getResourceSet();
        ECrossReferenceAdapter adapter = ECrossReferenceAdapter.getCrossReferenceAdapter((Notifier)resourceSet);
        if (adapter == null) {
            adapter = new ECrossReferenceAdapter();
            resourceSet.eAdapters().add((Object)adapter);
        }
        Collection settings = adapter.getInverseReferences(object, false);
        for (EStructuralFeature.Setting setting : settings) {
            EObject value = setting.getEObject();
            if (!(value instanceof TableInstance) || TableinstancePackage.Literals.TABLE_INSTANCE__CONTEXT != setting.getEStructuralFeature()) continue;
            Collection tableSettings = adapter.getInverseReferences((EObject)((TableInstance)value), false);
            for (EStructuralFeature.Setting tableSetting : tableSettings) {
                EObject tableValue = tableSetting.getEObject();
                if (!(tableValue instanceof PapyrusTableInstance) || PapyrustableinstancePackage.Literals.PAPYRUS_TABLE_INSTANCE__TABLE != tableSetting.getEStructuralFeature()) continue;
                tables.add((PapyrusTableInstance)tableValue);
            }
        }
        if (lookInChildren) {
            for (EObject child : object.eContents()) {
                tables.addAll(this.getRelatedTables(child, lookInChildren));
            }
        }
        return tables;
    }

    public Resource getNotationResourceForTable(EObject eObject, TransactionalEditingDomain domain) {
        EObject semanticObject = eObject;
        if (eObject instanceof PapyrusTableInstance) {
            TableInstance2 tableInstance = ((PapyrusTableInstance)eObject).getTable();
            if (tableInstance != null) {
                semanticObject = tableInstance.getContext();
            }
        } else if (eObject instanceof TableInstance2) {
            semanticObject = ((TableInstance2)eObject).getContext();
        }
        if (semanticObject == null) {
            return null;
        }
        Resource containerResource = semanticObject.eResource();
        if (containerResource == null) {
            return null;
        }
        ResourceSet resourceSet = containerResource.getResourceSet();
        if (resourceSet instanceof ModelSet) {
            ModelSet modelSet = (ModelSet)resourceSet;
            Resource destinationResource = modelSet.getAssociatedResource(semanticObject, "notation");
            return destinationResource;
        }
        throw new RuntimeException("Resource Set is not a ModelSet or is null");
    }

    public Resource getDiResourceForTable(EObject eObject, TransactionalEditingDomain domain) {
        EObject semanticObject = eObject;
        if (eObject instanceof PapyrusTableInstance) {
            TableInstance2 tableInstance = ((PapyrusTableInstance)eObject).getTable();
            if (tableInstance != null) {
                semanticObject = tableInstance.getContext();
            }
        } else if (eObject instanceof TableInstance2) {
            semanticObject = ((TableInstance2)eObject).getContext();
        }
        if (semanticObject == null) {
            return null;
        }
        Resource containerResource = semanticObject.eResource();
        if (containerResource == null) {
            return null;
        }
        ResourceSet resourceSet = containerResource.getResourceSet();
        if (resourceSet instanceof ModelSet) {
            ModelSet modelSet = (ModelSet)resourceSet;
            Resource destinationResource = modelSet.getAssociatedResource(semanticObject, "di");
            return destinationResource;
        }
        throw new RuntimeException("Resource Set is not a ModelSet or is null");
    }

    public class DuplicatePapyrusTableCommand
    extends DuplicateEObjectsCommand {
        private final PapyrusTableInstance papyrusTableInstanceToDuplicate;

        public DuplicatePapyrusTableCommand(TransactionalEditingDomain editingDomain, String label, PapyrusTableInstance table) {
            super(editingDomain, label, Collections.singletonList(table));
            this.papyrusTableInstanceToDuplicate = table;
        }

        public DuplicatePapyrusTableCommand(TransactionalEditingDomain editingDomain, String label, PapyrusTableInstance table, Map allDuplicatedObjectsMap) {
            super(editingDomain, label, Collections.singletonList(table), allDuplicatedObjectsMap);
            this.papyrusTableInstanceToDuplicate = table;
        }

        public DuplicatePapyrusTableCommand(TransactionalEditingDomain editingDomain, String label, PapyrusTableInstance table, Map allDuplicatedObjectsMap, EObject targetContainer) {
            super(editingDomain, label, Collections.singletonList(table), allDuplicatedObjectsMap, targetContainer);
            this.papyrusTableInstanceToDuplicate = table;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
            TableCopier copier = new TableCopier(this.getAllDuplicatedObjectsMap());
            TableInstance2 tableInstanceToDuplicate = this.papyrusTableInstanceToDuplicate.getTable();
            copier.copy((EObject)tableInstanceToDuplicate);
            copier.copy((EObject)this.papyrusTableInstanceToDuplicate);
            copier.copyReferences();
            EObject duplicatePapyrusTableInstance = (EObject)copier.get(this.papyrusTableInstanceToDuplicate);
            EObject duplicateTableInstance = (EObject)copier.get(tableInstanceToDuplicate);
            Resource targetResource = TableDuplicateEditHelperAdvice.this.getDiResourceForTable(duplicateTableInstance, this.getEditingDomain());
            if (targetResource == null) {
                targetResource = this.papyrusTableInstanceToDuplicate.eResource();
                if (targetResource != null) {
                    Activator.log.warn("It was not possible to find the Resource with the target EObject");
                    targetResource.getContents().add((Object)duplicateTableInstance);
                    targetResource.getContents().add((Object)duplicatePapyrusTableInstance);
                }
                return CommandResult.newErrorCommandResult((String)"Impossible to find a resource for the new table");
            }
            targetResource.getContents().add((Object)duplicateTableInstance);
            targetResource.getContents().add((Object)duplicatePapyrusTableInstance);
            Resource diResource = TableDuplicateEditHelperAdvice.this.getDiResourceForTable(duplicateTableInstance, this.getEditingDomain());
            if (diResource != null) {
                try {
                    IPageMngr iPageMngr = ServiceUtilsForResource.getInstance().getIPageMngr((Object)diResource);
                    iPageMngr.addPage((Object)duplicatePapyrusTableInstance);
                }
                catch (ServiceException e) {
                    Activator.log.error((Throwable)e);
                    return CommandResult.newErrorCommandResult((String)"Impossible to find a di resource to add the new available page");
                }
            } else {
                return CommandResult.newErrorCommandResult((String)"Impossible to find a di resource to add the new available page");
            }
            return CommandResult.newOKCommandResult((Object)this.getAllDuplicatedObjectsMap());
        }

        public boolean canExecute() {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class TableCopier
    extends EcoreUtil.Copier {
        private static final long serialVersionUID = 8544123249170461708L;
        private Map<EObject, EObject> semanticObjects;

        public TableCopier(Map<EObject, EObject> semanticObjects) {
            this.semanticObjects = semanticObjects;
        }

        public EObject get(Object arg0) {
            EObject object = (EObject)super.get(arg0);
            if (object == null) {
                object = this.semanticObjects.get(arg0);
            }
            return object;
        }
    }
}

