/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.table.common.handlers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.facet.infra.facet.Facet;
import org.eclipse.emf.facet.infra.facet.FacetAttribute;
import org.eclipse.emf.facet.infra.facet.FacetReference;
import org.eclipse.emf.facet.infra.query.ModelQuery;
import org.eclipse.emf.facet.infra.query.ModelQuerySet;
import org.eclipse.emf.facet.infra.query.core.AbstractModelQuery;
import org.eclipse.emf.facet.infra.query.core.ModelQuerySetCatalog;
import org.eclipse.emf.facet.infra.query.core.exception.ModelQueryException;
import org.eclipse.emf.facet.infra.query.runtime.ModelQueryResult;
import org.eclipse.emf.facet.widgets.nattable.NatTableWidgetUtils;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.Column;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.FacetAttributeColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.FeatureColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableInstance;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableinstanceFactory;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.TableInstance2;
import org.eclipse.emf.facet.widgets.nattable.internal.NatTableWidgetInternalUtils;
import org.eclipse.emf.facet.widgets.nattable.tableconfiguration.TableConfiguration;
import org.eclipse.emf.facet.widgets.nattable.tableconfiguration2.TableConfiguration2;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.AbstractEMFOperation;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.commands.CheckedOperationHistory;
import org.eclipse.papyrus.infra.core.editor.BackboneException;
import org.eclipse.papyrus.infra.core.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.infra.core.resource.AbstractBaseModel;
import org.eclipse.papyrus.infra.core.resource.IModel;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.NotFoundException;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IPageMngr;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.EditorUtils;
import org.eclipse.papyrus.infra.core.utils.ServiceUtils;
import org.eclipse.papyrus.infra.core.utils.ServiceUtilsForActionHandlers;
import org.eclipse.papyrus.infra.table.common.Activator;
import org.eclipse.papyrus.infra.table.common.dialog.TwoInputDialog;
import org.eclipse.papyrus.infra.table.common.messages.Messages;
import org.eclipse.papyrus.infra.table.common.modelresource.EMFFacetNattableModel;
import org.eclipse.papyrus.infra.table.common.modelresource.PapyrusNattableModel;
import org.eclipse.papyrus.infra.table.common.util.QueryRepresentation;
import org.eclipse.papyrus.infra.table.instance.papyrustableinstance.PapyrusTableInstance;
import org.eclipse.papyrus.infra.table.instance.papyrustableinstance.PapyrustableinstanceFactory;
import org.eclipse.papyrus.infra.table.papyrustableconfiguration.metamodel.PapyrusTableConfiguration.PapyrusTableConfiguration;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCreateNattableEditorCommand
extends AbstractHandler {
    private final String defaultName;
    private final String defaultDescription = "Table Description";
    private String description;
    private String name;
    private final String editorType;

    public AbstractCreateNattableEditorCommand(String editorType, String defaultName) {
        Assert.isNotNull((Object)(editorType != null ? 1 : 0));
        this.editorType = editorType;
        this.defaultName = defaultName;
    }

    public boolean isEnabled() {
        EObject context = this.getTableContext();
        return context instanceof Element;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            this.runAsTransaction();
        }
        catch (ServiceException e) {
            throw new ExecutionException("Can't create TableEditor", (Throwable)e);
        }
        return null;
    }

    public void runAsTransaction() throws ServiceException {
        this.name = this.defaultName;
        this.description = "Table Description";
        TwoInputDialog dialog = new TwoInputDialog(Display.getCurrent().getActiveShell(), Messages.AbstractCreateNattableEditorCommand_CreateNewTableDialogTitle, Messages.AbstractCreateNattableEditorCommand_CreateNewTableDialog_TableNameMessage, Messages.AbstractCreateNattableEditorCommand_CreateNewTableDialog_TableDescriptionMessage, this.defaultName, "Table Description", null);
        if (dialog.open() == 0) {
            this.name = dialog.getValue();
            this.description = dialog.getValue_2();
            final ServicesRegistry serviceRegistry = ServiceUtilsForActionHandlers.getInstance().getServiceRegistry();
            TransactionalEditingDomain domain = ServiceUtils.getInstance().getTransactionalEditingDomain((Object)serviceRegistry);
            AbstractEMFOperation command = new AbstractEMFOperation(domain, "Create Table Editor"){

                protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    try {
                        AbstractCreateNattableEditorCommand.this.doExecute(serviceRegistry);
                    }
                    catch (ServiceException e) {
                        e.printStackTrace();
                        return Status.CANCEL_STATUS;
                    }
                    catch (NotFoundException e) {
                        e.printStackTrace();
                        return Status.CANCEL_STATUS;
                    }
                    return Status.OK_STATUS;
                }
            };
            try {
                CheckedOperationHistory.getInstance().execute((IUndoableOperation)command, (IProgressMonitor)new NullProgressMonitor(), null);
            }
            catch (ExecutionException e) {
                Activator.getDefault();
                Activator.log.error("Can't create Table Editor", (Throwable)e);
            }
        }
    }

    public void doExecute(ServicesRegistry serviceRegistry) throws ServiceException, NotFoundException {
        Object editorModel = this.createEditorModel(serviceRegistry);
        IPageMngr pageMngr = ServiceUtils.getInstance().getIPageMngr((Object)serviceRegistry);
        pageMngr.openPage(editorModel);
    }

    protected Object createEditorModel(ServicesRegistry serviceRegistry) throws ServiceException, NotFoundException {
        PapyrusTableInstance papyrusTable = PapyrustableinstanceFactory.eINSTANCE.createPapyrusTableInstance();
        papyrusTable.setName(this.name);
        papyrusTable.setType(this.editorType);
        PapyrusNattableModel papyrusModel = (PapyrusNattableModel)ServiceUtils.getInstance().getModelSet((Object)serviceRegistry).getModelChecked("org.eclipse.papyrus.nattable.resource.NattableModel");
        papyrusModel.addPapyrusTableInstance(papyrusTable);
        this.setFillingQueries(papyrusTable);
        this.setSynchronization(papyrusTable);
        EObject context = this.getTableContext();
        Assert.isNotNull((Object)context);
        List<EObject> elements = this.getInitialElement(papyrusTable, context);
        TableInstance2 tableInstance = NatTableWidgetUtils.createTableInstance(elements, (String)"Table Description", (TableConfiguration)this.getTableConfiguration2(), (EObject)this.getTableContext(), null);
        tableInstance.setDescription(this.description);
        PapyrusTableConfiguration papyrusConfiguration = this.getPapyrusTableConfiguration();
        if (papyrusConfiguration != null) {
            papyrusTable.setPastedElementContainmentFeature(papyrusConfiguration.getPastedElementContainmentFeature());
            papyrusTable.setPastedElementId(papyrusConfiguration.getPastedElementId());
            EList defaultFeatures = papyrusConfiguration.getDefaultColumns();
            for (Column column : tableInstance.getColumns()) {
                if (!(column instanceof FeatureColumn)) continue;
                defaultFeatures.remove(((FeatureColumn)column).getFeature());
            }
            for (EStructuralFeature feature : defaultFeatures) {
                FacetAttributeColumn col;
                if (feature instanceof FacetAttribute) {
                    col = TableinstanceFactory.eINSTANCE.createFacetAttributeColumn();
                    col.setAttribute((FacetAttribute)feature);
                    tableInstance.getColumns().add((Object)col);
                    tableInstance.getFacets2().add((Object)((Facet)feature.eContainer()));
                    continue;
                }
                if (feature instanceof FacetReference) {
                    col = TableinstanceFactory.eINSTANCE.createFacetReferenceColumn();
                    col.setReference((FacetReference)feature);
                    tableInstance.getColumns().add((Object)col);
                    tableInstance.getFacets2().add((Object)((Facet)feature.eContainer()));
                    continue;
                }
                if (feature instanceof EAttribute) {
                    col = TableinstanceFactory.eINSTANCE.createAttributeColumn();
                    col.setAttribute((EAttribute)feature);
                    tableInstance.getColumns().add((Object)col);
                    continue;
                }
                if (!(feature instanceof EReference)) continue;
                col = TableinstanceFactory.eINSTANCE.createReferenceColumn();
                col.setReference((EReference)feature);
                tableInstance.getColumns().add((Object)col);
            }
        }
        EMFFacetNattableModel model = (EMFFacetNattableModel)ServiceUtils.getInstance().getModelSet((Object)serviceRegistry).getModelChecked("org.eclipse.papyrus.emf.facet.nattable.resource.NattableModel");
        model.addTableInstance((TableInstance)tableInstance);
        papyrusTable.setTable(tableInstance);
        tableInstance.setContext(context);
        this.setHiddenColumns(papyrusTable);
        return papyrusTable;
    }

    private List<EObject> getInitialElement(PapyrusTableInstance papyrusTable, EObject context) {
        if (papyrusTable.isIsSynchronized() && !papyrusTable.getFillingQueries().isEmpty()) {
            ArrayList<EObject> elements = new ArrayList<EObject>();
            for (ModelQuery query : papyrusTable.getFillingQueries()) {
                ModelQueryResult result;
                Object value;
                ModelQuerySetCatalog catalog = ModelQuerySetCatalog.getSingleton();
                AbstractModelQuery impl = null;
                try {
                    impl = catalog.getModelQueryImpl(query);
                }
                catch (ModelQueryException e) {
                    Activator.getDefault();
                    Activator.log.error((Throwable)e);
                }
                if (impl == null || !((value = (result = impl.evaluate(context)).getValue()) instanceof Collection)) continue;
                for (Object currentObject : (Collection)value) {
                    if (!(currentObject instanceof EObject)) continue;
                    elements.add((EObject)currentObject);
                }
            }
            return elements;
        }
        return Collections.emptyList();
    }

    private void setHiddenColumns(PapyrusTableInstance papyrusTable) {
        List<String> hiddenColumnsName = this.getHiddenColumnName();
        if (!hiddenColumnsName.isEmpty()) {
            for (Column column : papyrusTable.getTable().getColumns()) {
                String name = NatTableWidgetInternalUtils.getColumnName((Column)column);
                if (!hiddenColumnsName.contains(name)) continue;
                column.setIsHidden(true);
            }
        }
    }

    protected List<String> getHiddenColumnName() {
        return Collections.emptyList();
    }

    @Deprecated
    protected TableConfiguration getTableConfiguration() {
        return this.getTableConfiguration2();
    }

    protected TableConfiguration2 getTableConfiguration2() {
        PapyrusTableConfiguration papyrusConfig = this.getPapyrusTableConfiguration();
        if (papyrusConfig != null) {
            return papyrusConfig.getTableConfiguration();
        }
        return null;
    }

    protected PapyrusTableConfiguration getPapyrusTableConfiguration() {
        return null;
    }

    protected void setSynchronization(PapyrusTableInstance papyrusTable) {
        papyrusTable.setIsSynchronized(papyrusTable.getFillingQueries().size() != 0);
    }

    protected void setFillingQueries(PapyrusTableInstance papyrusTable) {
        ModelQuerySetCatalog catalog = ModelQuerySetCatalog.getSingleton();
        for (QueryRepresentation rep : this.getQueryRepresentations()) {
            ModelQuery query;
            ModelQuerySet querySet = catalog.getModelQuerySet(rep.getQuerySetName());
            if (querySet == null || (query = querySet.getQuery(rep.getQueryName())) == null) continue;
            papyrusTable.getFillingQueries().add((Object)query);
        }
    }

    protected IMultiDiagramEditor getMultiDiagramEditor() throws BackboneException {
        return EditorUtils.getMultiDiagramEditorChecked();
    }

    protected EObject getTableContext() {
        IModel model;
        List<EObject> selection = this.getSelection();
        if (!selection.isEmpty()) {
            return selection.get(0);
        }
        ModelSet modelSet = null;
        try {
            ServicesRegistry serviceRegistry = ServiceUtilsForActionHandlers.getInstance().getServiceRegistry();
            modelSet = ServiceUtils.getInstance().getModelSet((Object)serviceRegistry);
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        if (modelSet != null && (model = modelSet.getModel("org.eclipse.papyrus.infra.core.resource.uml.UmlModel")) instanceof AbstractBaseModel) {
            return this.getRootElement(((AbstractBaseModel)model).getResource());
        }
        return null;
    }

    protected List<EObject> getSelection() {
        ISelection selection;
        ArrayList<EObject> selectedElements = new ArrayList<EObject>();
        IWorkbenchWindow ww = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (ww != null && (selection = ww.getSelectionService().getSelection()) instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            for (Object object : structuredSelection) {
                EObject currentEObject;
                if (!(object instanceof IAdaptable) || (currentEObject = (EObject)((IAdaptable)object).getAdapter(EObject.class)) == null) continue;
                selectedElements.add(currentEObject);
            }
        }
        return selectedElements;
    }

    protected EObject getRootElement(Resource modelResource) {
        Object root;
        EObject rootElement = null;
        if (modelResource != null && modelResource.getContents() != null && modelResource.getContents().size() > 0 && (root = modelResource.getContents().get(0)) instanceof EObject) {
            rootElement = (EObject)root;
        }
        return rootElement;
    }

    protected List<QueryRepresentation> getQueryRepresentations() {
        ArrayList<QueryRepresentation> list = new ArrayList<QueryRepresentation>();
        return list;
    }
}

