/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.table.common.listener;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.facet.infra.query.ModelQuery;
import org.eclipse.emf.facet.infra.query.core.AbstractModelQuery;
import org.eclipse.emf.facet.infra.query.core.ModelQuerySetCatalog;
import org.eclipse.emf.facet.infra.query.core.exception.ModelQueryException;
import org.eclipse.emf.facet.infra.query.core.java.ParameterValueList;
import org.eclipse.emf.facet.infra.query.runtime.ModelQueryParameterValue;
import org.eclipse.emf.facet.infra.query.runtime.ModelQueryResult;
import org.eclipse.emf.facet.widgets.celleditors.ICommandFactoriesRegistry;
import org.eclipse.emf.facet.widgets.celleditors.ICommandFactory;
import org.eclipse.emf.facet.widgets.nattable.INatTableWidget;
import org.eclipse.emf.facet.widgets.nattable.INatTableWidgetProvider;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.Row;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableInstance;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableinstancePackage;
import org.eclipse.emf.facet.widgets.nattable.tableconfiguration.TableConfiguration;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.TriggerListener;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.table.common.Activator;
import org.eclipse.papyrus.infra.table.instance.papyrustableinstance.PapyrusTableInstance;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSynchronizedTableTriggerListener
extends TriggerListener {
    protected final PapyrusTableInstance table;
    private INatTableWidgetProvider provider;
    private final ModelQuerySetCatalog catalog = ModelQuerySetCatalog.getSingleton();

    public AbstractSynchronizedTableTriggerListener(PapyrusTableInstance table, INatTableWidgetProvider provider) {
        this.table = table;
        this.provider = provider;
    }

    protected CompoundCommand getSynchronizationCommand(final TransactionalEditingDomain domain) {
        if (!this.table.getFillingQueries().isEmpty()) {
            CompoundCommand command = new CompoundCommand("Command to synchronize table with its context");
            final Collection<EObject> allElements = this.getAllElementsUsingFillingqueries();
            EList currentElements = this.table.getTable().getElements();
            ArrayList<EObject> elementsToAdd = new ArrayList<EObject>(allElements);
            elementsToAdd.removeAll((Collection<?>)currentElements);
            ArrayList<EObject> elementsToRemove = new ArrayList<EObject>((Collection<EObject>)currentElements);
            elementsToRemove.removeAll(allElements);
            if (!elementsToAdd.isEmpty()) {
                List<EObject> forbiddenElements = this.getForbiddenElement(elementsToAdd);
                elementsToAdd.removeAll(forbiddenElements);
                command.append(this.getAddElementCommand(domain, elementsToAdd, this.provider.getNatTableWidget()));
            }
            if (!elementsToRemove.isEmpty()) {
                command.append(this.getRemoveElementCommand(domain, elementsToRemove, this.provider.getNatTableWidget()));
            }
            if (!allElements.isEmpty()) {
                command.append((Command)new GMFtoEMFCommandWrapper((ICommand)new AbstractTransactionalCommand(domain, null, null){

                    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                        TableInstance table = AbstractSynchronizedTableTriggerListener.this.provider.getNatTableWidget().getTableInstance();
                        ArrayList<Row> newOrder = new ArrayList<Row>();
                        EList rows = table.getRows();
                        block0: for (EObject current : allElements) {
                            for (Row currentRow : rows) {
                                if (currentRow.getElement() != current) continue;
                                newOrder.add(currentRow);
                                continue block0;
                            }
                        }
                        ICommandFactory commandFactory = ICommandFactoriesRegistry.INSTANCE.getCommandFactoryFor((EditingDomain)domain);
                        Command command = commandFactory.createSetCommand((EditingDomain)domain, (Object)table, (Object)TableinstancePackage.eINSTANCE.getTableInstance_Rows(), newOrder);
                        command.execute();
                        return null;
                    }
                }));
            }
            if (!command.isEmpty()) {
                return command;
            }
        }
        return null;
    }

    private Collection<EObject> getAllElementsUsingFillingqueries() {
        EList queries = this.table.getFillingQueries();
        if (queries.size() == 1) {
            AbstractModelQuery impl = null;
            try {
                impl = this.catalog.getModelQueryImpl((ModelQuery)queries.get(0));
            }
            catch (ModelQueryException e) {
                Activator.log.error((Throwable)e);
            }
            Assert.isNotNull((Object)(impl != null ? 1 : 0));
            ModelQueryResult result = impl.evaluate(this.table.getTable().getContext());
            Object value = result.getValue();
            Assert.isTrue((boolean)(value instanceof Collection));
            return Collections.checkedCollection((Collection)value, EObject.class);
        }
        LinkedHashSet<EObject> allElements = new LinkedHashSet<EObject>();
        for (ModelQuery query : this.table.getFillingQueries()) {
            ModelQueryResult result;
            Object value;
            AbstractModelQuery impl = null;
            try {
                impl = this.catalog.getModelQueryImpl(query);
            }
            catch (ModelQueryException e) {
                Activator.log.error((Throwable)e);
            }
            if (impl == null || !((value = (result = impl.evaluate(this.table.getTable().getContext())).getValue()) instanceof Collection)) continue;
            for (Object currentObject : (Collection)value) {
                if (!(currentObject instanceof EObject)) continue;
                allElements.add((EObject)currentObject);
            }
        }
        return allElements;
    }

    protected Command getAddElementCommand(TransactionalEditingDomain domain, final List<EObject> elementsToAdd, final INatTableWidget widget) {
        return new GMFtoEMFCommandWrapper((ICommand)new AbstractTransactionalCommand(domain, null, null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                widget.addRows(elementsToAdd);
                for (EObject current : elementsToAdd) {
                    if (widget.getTableInstance().getElements().contains((Object)current)) continue;
                    widget.addRows(Collections.singletonList(current));
                }
                return null;
            }
        });
    }

    protected Command getRemoveElementCommand(final TransactionalEditingDomain domain, final List<EObject> elementsToRemove, final INatTableWidget widget) {
        return new GMFtoEMFCommandWrapper((ICommand)new AbstractTransactionalCommand(domain, null, null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                for (EObject current : elementsToRemove) {
                    if (!widget.getTableInstance().getElements().contains((Object)current)) continue;
                    ArrayList<EObject> toRemove = new ArrayList<EObject>();
                    toRemove.add(current);
                    Command command = AbstractSynchronizedTableTriggerListener.this.createRemoveRowsCommand(domain, toRemove, widget);
                    if (command == null) continue;
                    command.execute();
                }
                return null;
            }
        });
    }

    private Command createRemoveRowsCommand(TransactionalEditingDomain domain, List<EObject> toRemove, INatTableWidget widget) {
        ICommandFactory commandFactory = ICommandFactoriesRegistry.INSTANCE.getCommandFactoryFor((EditingDomain)domain);
        CompoundCommand compoundCommand = new CompoundCommand();
        int i = 0;
        while (i < widget.getTableInstance().getRows().size()) {
            if (toRemove.contains(((Row)widget.getTableInstance().getRows().get(i)).getElement())) {
                Command removeRowCommand = commandFactory.createRemoveCommand((EditingDomain)domain, (Object)widget.getTableInstance(), (Object)TableinstancePackage.eINSTANCE.getTableInstance_Rows(), widget.getTableInstance().getRows().get(i));
                compoundCommand.append(removeRowCommand);
            }
            ++i;
        }
        if (!compoundCommand.isEmpty()) {
            return compoundCommand;
        }
        return null;
    }

    private List<EObject> getForbiddenElement(List<EObject> elementsToAdd) {
        ModelQuery query;
        ArrayList<EObject> forbiddenElements = new ArrayList<EObject>();
        TableConfiguration tableConfiguration = this.table.getTable().getTableConfiguration();
        if (tableConfiguration != null && (query = tableConfiguration.getCanBePresentedInTheTable()) != null) {
            AbstractModelQuery queryImpl = null;
            try {
                queryImpl = ModelQuerySetCatalog.getSingleton().getModelQueryImpl(query);
            }
            catch (ModelQueryException e) {
                Activator.getDefault();
                Activator.log.error((Throwable)e);
            }
            for (EObject current : elementsToAdd) {
                boolean matched = query.getScope().size() == 0;
                Iterator queryScopes = query.getScope().iterator();
                while (queryScopes.hasNext() && !matched) {
                    EClass eClass = (EClass)queryScopes.next();
                    if (!eClass.isInstance((Object)current)) continue;
                    matched = true;
                }
                if (!matched) {
                    forbiddenElements.add(current);
                    continue;
                }
                ModelQueryResult result = queryImpl.evaluate(current, (List)new ParameterValueList(new ModelQueryParameterValue[0]));
                if (result.getValue().equals(Boolean.TRUE)) continue;
                forbiddenElements.add(current);
            }
        }
        return forbiddenElements;
    }
}

