/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.ui.resources.refactoring;

import java.util.Collection;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;
import org.eclipse.papyrus.infra.ui.resources.refactoring.DirtyEditorChange;
import org.eclipse.papyrus.infra.ui.resources.refactoring.ModelParticipantHelpers;
import org.eclipse.papyrus.infra.ui.resources.refactoring.RenameModelChange;

public class RenameModelParticipant
extends RenameParticipant {
    private IFile fileToRename;
    private IFile newFile;
    private Collection<? extends IResource> impacted;

    public Change createPreChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return new DirtyEditorChange(this.fileToRename, this.newFile);
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        return new RefactoringStatus();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return new RenameModelChange(this.fileToRename, this.newFile, this.impacted);
    }

    public String getName() {
        return "Papyrus Model Renaming";
    }

    protected boolean initialize(Object element) {
        if (!(element instanceof IFile)) {
            return false;
        }
        this.fileToRename = (IFile)element;
        String ext = this.fileToRename.getFileExtension();
        IContainer parent = this.fileToRename.getParent();
        String newName = this.getArguments().getNewName();
        int idx = newName.lastIndexOf(46);
        newName = idx > 0 ? newName.substring(0, idx) : String.valueOf(newName) + '.' + ext;
        boolean otherFiles = false;
        for (IResource file : ModelParticipantHelpers.getRelatedFiles(this.fileToRename)) {
            IPath path = file.getFullPath();
            IFile renFile = parent.getFile(path.makeRelativeTo(parent.getFullPath()));
            if (path.equals((Object)this.fileToRename.getFullPath()) || !renFile.exists()) continue;
            otherFiles = true;
            break;
        }
        if (otherFiles) {
            IPath newDiPath = this.fileToRename.getFullPath().removeLastSegments(1);
            newDiPath = newDiPath.append(newName).addFileExtension(ext);
            this.newFile = parent.getFile(newDiPath.makeRelativeTo(parent.getFullPath()));
            this.impacted = ModelParticipantHelpers.getResourceToFix(this.fileToRename);
            return true;
        }
        return false;
    }
}

